/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.search.journal.impl;

import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.MultiReader;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.spell.Dictionary;
import org.apache.lucene.search.spell.LuceneDictionary;
import org.apache.lucene.search.spell.SpellChecker;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.store.NIOFSDirectory;
import org.sakaiproject.cluster.api.ClusterService;
import org.sakaiproject.component.api.ServerConfigurationService;
import org.sakaiproject.search.index.AnalyzerFactory;
import org.sakaiproject.search.journal.api.IndexListener;
import org.sakaiproject.search.journal.api.IndexMonitorListener;
import org.sakaiproject.search.journal.api.IndexStorageProvider;
import org.sakaiproject.search.journal.api.JournalErrorException;
import org.sakaiproject.search.journal.api.JournalManager;
import org.sakaiproject.search.journal.api.JournaledIndex;
import org.sakaiproject.search.journal.api.ThreadBinder;
import org.sakaiproject.search.journal.impl.JournalSettings;
import org.sakaiproject.search.journal.impl.MonitoredIndexWriter;
import org.sakaiproject.search.journal.impl.RefCountIndexSearcher;
import org.sakaiproject.search.journal.impl.RefCountMultiReader;
import org.sakaiproject.search.journal.impl.SegmentListReader;
import org.sakaiproject.search.journal.impl.SegmentListWriter;
import org.sakaiproject.search.transaction.api.IndexTransactionException;
import org.sakaiproject.search.util.FileUtils;
import org.sakaiproject.thread_local.api.ThreadLocalManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JournaledFSIndexStorage
implements JournaledIndex,
IndexStorageProvider {
    private static final Log log = LogFactory.getLog(JournaledFSIndexStorage.class);
    private static final String SEGMENT_LIST_NAME = "local-segments";
    private ServerConfigurationService serverConfigurationService;
    private String serverId;
    private DataSource datasource;
    private ReentrantReadWriteLock rwlock = new ReentrantReadWriteLock(true);
    private ThreadLocal<Long> lastJournalEntryHolder = new ThreadLocal();
    private JournalManager journalManager;
    private List<File> segments = new ArrayList<File>();
    private long lastUpdate;
    private long journalSavePoint = -1L;
    private MultiReader multiReader;
    private List<IndexListener> indexListeners = new ArrayList<IndexListener>();
    private boolean modified = false;
    private IndexWriter permanentIndexWriter;
    private AnalyzerFactory analyzerFactory;
    private IndexSearcher indexSearcher = null;
    private ClusterService clusterService;
    private long lastLoad;
    private long lastLoadTime;
    private JournalSettings journalSettings;
    private ThreadLocalManager threadLocalManager;
    Directory spellIndexDirectory = null;

    public void destroy() {
    }

    public void init() {
        this.serverId = this.serverConfigurationService.getServerId();
        File f = new File(this.journalSettings.getSearchIndexDirectory(), SEGMENT_LIST_NAME);
        if (f.exists()) {
            log.info((Object)"Segment List File Exists, using it");
            try {
                this.loadSegmentList();
            }
            catch (IOException e) {
                log.error((Object)"Unable to load segment list", (Throwable)e);
                System.exit(-10);
            }
        } else {
            log.info((Object)"No Segment List File Exists");
            File searchDirectory = new File(this.journalSettings.getSearchIndexDirectory());
            if (searchDirectory.exists()) {
                log.warn((Object)("Found Existing Search Directory with no local segment list, I will delete " + searchDirectory.getAbsolutePath()));
                try {
                    FileUtils.deleteAll((File)searchDirectory);
                }
                catch (IOException e) {
                    log.warn((Object)"Unable to remove Existing Search Directory ", (Throwable)e);
                }
            }
            this.deleteJournalSavePoint();
        }
        Runtime.getRuntime().addShutdownHook(new Thread(){

            public void run() {
                try {
                    if (JournaledFSIndexStorage.this.multiReader != null) {
                        JournaledFSIndexStorage.this.multiReader.close();
                    }
                }
                catch (Exception ex) {
                    log.debug((Object)ex);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void deleteJournalSavePoint() {
        block31: {
            Statement deleteJournalSavePointPst;
            Connection connection;
            block28: {
                boolean tableExists;
                block32: {
                    ResultSet rs;
                    PreparedStatement checkJournalSavePoint;
                    block25: {
                        connection = null;
                        deleteJournalSavePointPst = null;
                        if (this.datasource == null) break block31;
                        connection = this.datasource.getConnection();
                        tableExists = false;
                        checkJournalSavePoint = null;
                        rs = null;
                        checkJournalSavePoint = connection.prepareStatement("select count(*) from search_node_status ");
                        rs = checkJournalSavePoint.executeQuery();
                        if (!rs.next()) break block25;
                        tableExists = true;
                    }
                    Object var8_7 = null;
                    try {
                        rs.close();
                    }
                    catch (Exception ex2) {
                        log.debug((Object)ex2);
                    }
                    try {
                        checkJournalSavePoint.close();
                    }
                    catch (Exception ex2) {
                        log.debug((Object)ex2);
                    }
                    break block32;
                    {
                        catch (Exception ex) {
                            if (log.isDebugEnabled()) {
                                log.debug((Object)"Failed to check for existance of table, this is Ok on first start ", (Throwable)ex);
                            }
                            Object var8_8 = null;
                            try {
                                rs.close();
                            }
                            catch (Exception ex2) {
                                log.debug((Object)ex2);
                            }
                            try {
                                checkJournalSavePoint.close();
                            }
                            catch (Exception ex2) {
                                log.debug((Object)ex2);
                            }
                        }
                    }
                    catch (Throwable throwable) {
                        Object var8_9 = null;
                        try {
                            rs.close();
                        }
                        catch (Exception ex2) {
                            log.debug((Object)ex2);
                        }
                        try {
                            checkJournalSavePoint.close();
                        }
                        catch (Exception ex2) {
                            log.debug((Object)ex2);
                        }
                        throw throwable;
                    }
                }
                if (!tableExists) break block28;
                deleteJournalSavePointPst = connection.prepareStatement("update search_node_status set jid = -1 where serverid = ? ");
                deleteJournalSavePointPst.clearParameters();
                deleteJournalSavePointPst.setString(1, this.serverId);
                deleteJournalSavePointPst.executeUpdate();
                connection.commit();
            }
            Object var11_15 = null;
            try {
                deleteJournalSavePointPst.close();
            }
            catch (Exception ex3) {
                log.debug((Object)ex3);
            }
            try {
                connection.close();
            }
            catch (Exception ex3) {
                log.debug((Object)ex3);
            }
            break block31;
            {
                catch (Exception ex) {
                    log.warn((Object)"Unable to delete Search Jorunal SavePoint ", (Throwable)ex);
                    Object var11_16 = null;
                    try {
                        deleteJournalSavePointPst.close();
                    }
                    catch (Exception ex3) {
                        log.debug((Object)ex3);
                    }
                    try {
                        connection.close();
                    }
                    catch (Exception ex3) {
                        log.debug((Object)ex3);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var11_17 = null;
                try {
                    deleteJournalSavePointPst.close();
                }
                catch (Exception ex3) {
                    log.debug((Object)ex3);
                }
                try {
                    connection.close();
                }
                catch (Exception ex3) {
                    log.debug((Object)ex3);
                }
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public long getJournalSavePoint() {
        block22: {
            if (this.journalSavePoint == -1L) {
                ResultSet rs;
                PreparedStatement getJournalSavePointPst;
                Connection connection;
                block17: {
                    connection = null;
                    getJournalSavePointPst = null;
                    rs = null;
                    connection = this.datasource.getConnection();
                    getJournalSavePointPst = connection.prepareStatement("select jid from search_node_status where serverid = ? ");
                    getJournalSavePointPst.clearParameters();
                    getJournalSavePointPst.setString(1, this.serverId);
                    rs = getJournalSavePointPst.executeQuery();
                    if (!rs.next()) break block17;
                    this.journalSavePoint = rs.getLong(1);
                    this.lastUpdate = System.currentTimeMillis();
                }
                Object var6_4 = null;
                try {
                    rs.close();
                }
                catch (Exception ex2) {
                    log.debug((Object)ex2);
                }
                try {
                    getJournalSavePointPst.close();
                }
                catch (Exception ex2) {
                    log.debug((Object)ex2);
                }
                try {
                    connection.close();
                }
                catch (Exception ex2) {
                    log.debug((Object)ex2);
                }
                break block22;
                {
                    catch (Exception ex) {
                        log.warn((Object)"Unable to get Search Jorunal SavePoint ", (Throwable)ex);
                        Object var6_5 = null;
                        try {
                            rs.close();
                        }
                        catch (Exception ex2) {
                            log.debug((Object)ex2);
                        }
                        try {
                            getJournalSavePointPst.close();
                        }
                        catch (Exception ex2) {
                            log.debug((Object)ex2);
                        }
                        try {
                            connection.close();
                        }
                        catch (Exception ex2) {
                            log.debug((Object)ex2);
                        }
                    }
                }
                catch (Throwable throwable) {
                    Object var6_6 = null;
                    try {
                        rs.close();
                    }
                    catch (Exception ex2) {
                        log.debug((Object)ex2);
                    }
                    try {
                        getJournalSavePointPst.close();
                    }
                    catch (Exception ex2) {
                        log.debug((Object)ex2);
                    }
                    try {
                        connection.close();
                    }
                    catch (Exception ex2) {
                        log.debug((Object)ex2);
                    }
                    throw throwable;
                }
            }
        }
        return this.journalSavePoint;
    }

    @Override
    public boolean aquireUpdateLock() {
        try {
            boolean locked = this.rwlock.writeLock().tryLock(10L, TimeUnit.SECONDS);
            if (locked) {
                this.setLastJournalEntry(-1L);
            }
            return locked;
        }
        catch (InterruptedException iex) {
            log.debug((Object)iex);
            return false;
        }
    }

    @Override
    public void releaseUpdateLock() {
        if (this.rwlock.isWriteLockedByCurrentThread()) {
            this.rwlock.writeLock().unlock();
            this.setLastJournalEntry(-1L);
        }
    }

    @Override
    public boolean aquireReadLock() {
        try {
            return this.rwlock.readLock().tryLock(10L, TimeUnit.SECONDS);
        }
        catch (InterruptedException iex) {
            log.debug((Object)iex);
            return false;
        }
    }

    @Override
    public void releaseReadLock() {
        this.rwlock.readLock().unlock();
    }

    @Override
    public void setLastJournalEntry(long lastJournalEntry) {
        this.lastJournalEntryHolder.set(lastJournalEntry);
    }

    @Override
    public long getLastJournalEntry() {
        Long l = this.lastJournalEntryHolder.get();
        if (l == null) {
            return -1L;
        }
        return l;
    }

    @Override
    public void addSegment(File f) {
        this.segments.add(f);
        this.modified = true;
    }

    @Override
    public String getWorkingSpace() {
        return this.journalSettings.getLocalIndexWorkingSpace();
    }

    @Override
    public IndexSearcher getIndexSearcher() throws IOException {
        log.debug((Object)("getIndexSearcher(): " + this.indexSearcher));
        if (this.indexSearcher == null) {
            this.loadIndexSearcherInternal();
        }
        if (this.indexSearcher != null) {
            log.debug((Object)("getIndexSearcher(): " + this.indexSearcher + " threadbinder"));
            ((ThreadBinder)this.indexSearcher).bind(this.threadLocalManager);
        }
        return this.indexSearcher;
    }

    private void loadIndexSearcherInternal() throws IOException {
        log.debug((Object)"loadIndexSearcherInternal()");
        MultiReader tmpIndexReader = this.multiReader;
        IndexReader ir = this.getIndexReader();
        log.debug((Object)("index reader is: " + ir));
        if (this.spellIndexDirectory == null) {
            this.createSpellIndex(ir);
        }
        if (tmpIndexReader != ir || this.indexSearcher == null) {
            long end;
            long start = System.currentTimeMillis();
            RefCountIndexSearcher newIndexSearcher = new RefCountIndexSearcher(ir, this);
            if (this.indexSearcher != null) {
                this.indexSearcher.close();
            }
            this.indexSearcher = newIndexSearcher;
            this.lastLoad = end = System.currentTimeMillis();
            this.lastLoadTime = end - start;
            log.debug((Object)("Opened index Searcher in " + (end - start) + " ms"));
            this.fireIndexSearcherOpen(this.indexSearcher);
        }
    }

    @Override
    public IndexReader getDeletionIndexReader() throws IOException {
        return this.getIndexReader();
    }

    public boolean centralIndexExists() {
        return true;
    }

    public void closeIndexReader(IndexReader indexReader) throws IOException {
        indexReader.close();
    }

    public void closeIndexSearcher(IndexSearcher indexSearcher) {
        IndexReader indexReader = indexSearcher.getIndexReader();
        boolean closedAlready = false;
        try {
            if (indexReader != null) {
                indexReader.close();
                closedAlready = true;
            }
        }
        catch (Exception ex) {
            log.error((Object)("Failed to close Index Reader " + ex.getMessage()));
        }
        try {
            indexSearcher.close();
        }
        catch (Exception ex) {
            if (closedAlready) {
                log.debug((Object)("Failed to close Index Searcher " + ex.getMessage()));
            }
            log.error((Object)("Failed to close Index Searcher " + ex.getMessage()));
        }
    }

    public void closeIndexWriter(IndexWriter indexWrite) throws IOException {
        throw new UnsupportedOperationException("Only Readers are available from a JournaledFSIndexStorage class");
    }

    public void doPostIndexUpdate() throws IOException {
        throw new UnsupportedOperationException("Only Readers are available from a JournaledFSIndexStorage class");
    }

    public void doPreIndexUpdate() throws IOException {
        throw new UnsupportedOperationException("Only Readers are available from a JournaledFSIndexStorage class");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IndexReader getIndexReader() throws IOException {
        long f;
        long start2;
        log.debug((Object)"getIndexReader()");
        boolean current = false;
        long start = System.currentTimeMillis();
        try {
            if (this.multiReader != null) {
                current = this.multiReader.isCurrent();
            }
        }
        catch (Exception ex) {
            log.warn((Object)"Failed to get current status assuming index reload is required ", (Throwable)ex);
        }
        long x1 = start2 = System.currentTimeMillis();
        long f1 = start2;
        long r1 = start2;
        long r2 = start2;
        long f2 = start2;
        long f3 = start2;
        log.debug((Object)("Check 1: modified=" + this.modified + " multiReader=" + this.multiReader + " current=" + current));
        if (this.modified || this.multiReader == null || !current) {
            f1 = x1 = System.currentTimeMillis();
            boolean locked = false;
            locked = this.rwlock.isWriteLockedByCurrentThread() ? true : this.aquireReadLock();
            if (locked) {
                current = false;
                try {
                    if (this.multiReader != null) {
                        current = this.multiReader.isCurrent();
                    }
                }
                catch (Exception ex) {
                    log.warn((Object)"Failed to get current status assuming index reload is required ", (Throwable)ex);
                }
                log.debug((Object)("Check 2: modified=" + this.modified + " multiReader=" + this.multiReader + " current=" + current));
                if (this.modified || this.multiReader == null || !current) {
                    f1 = System.currentTimeMillis();
                    try {
                        r1 = System.currentTimeMillis();
                        this.getIndexReaderInternal();
                        this.modified = false;
                        r2 = System.currentTimeMillis();
                        Object var21_14 = null;
                    }
                    catch (Throwable throwable) {
                        Object var21_15 = null;
                        f2 = System.currentTimeMillis();
                        if (!this.rwlock.isWriteLockedByCurrentThread()) {
                            this.releaseReadLock();
                        }
                        f3 = System.currentTimeMillis();
                        throw throwable;
                    }
                    f2 = System.currentTimeMillis();
                    if (!this.rwlock.isWriteLockedByCurrentThread()) {
                        this.releaseReadLock();
                    }
                    f3 = System.currentTimeMillis();
                    {
                    }
                }
            } else {
                f1 = System.currentTimeMillis();
                log.warn((Object)"Failed to get read lock on index ");
            }
        }
        if ((f = System.currentTimeMillis()) - start > 1000L) {
            log.info((Object)("Long time opening " + (start2 - start) + ":" + (f - start2) + " ms"));
            log.info((Object)("Read Lock aquire " + (f1 - x1) + " ms"));
            log.info((Object)("Index Load aquire " + (r2 - r1) + " ms"));
            log.info((Object)("Read Lock Release " + (f2 - f3) + " ms"));
        }
        if (this.multiReader != null) {
            ((ThreadBinder)this.multiReader).bind(this.threadLocalManager);
        }
        log.debug((Object)("getIndexReader() returning " + this.multiReader));
        return this.multiReader;
    }

    private IndexReader getIndexReaderInternal() throws IOException {
        long start = System.currentTimeMillis();
        File f = new File(this.journalSettings.getSearchIndexDirectory());
        FSDirectory d = null;
        if (!f.exists()) {
            if (!f.mkdirs()) {
                throw new IOException("can't create index directory " + f.getPath());
            }
            log.debug((Object)("Indexing in " + f.getAbsolutePath()));
            d = FSDirectory.open((File)new File(this.journalSettings.getSearchIndexDirectory()));
        } else {
            d = FSDirectory.open((File)new File(this.journalSettings.getSearchIndexDirectory()));
        }
        if (IndexWriter.isLocked((Directory)d)) {
            IndexWriter.unlock((Directory)d);
            log.warn((Object)"Unlocked Lucene Directory for update, hope this is Ok");
        }
        if (!d.fileExists("segments.gen")) {
            IndexWriter iw = new IndexWriter((Directory)FSDirectory.open((File)f), this.getAnalyzer(), IndexWriter.MaxFieldLength.UNLIMITED);
            iw.setUseCompoundFile(true);
            iw.setMaxMergeDocs(this.journalSettings.getLocalMaxMergeDocs());
            iw.setMaxBufferedDocs(this.journalSettings.getLocalMaxBufferedDocs());
            iw.setMergeFactor(this.journalSettings.getLocalMaxMergeFactor());
            Document doc = new Document();
            doc.add((Fieldable)new Field("indexcreated", new Date().toString(), Field.Store.YES, Field.Index.NOT_ANALYZED, Field.TermVector.NO));
            iw.addDocument(doc);
            iw.close();
        }
        IndexReader[] indexReaders = new IndexReader[this.segments.size() + 1];
        indexReaders[0] = IndexReader.open((Directory)d, (boolean)false);
        int i = 1;
        for (File s : this.segments) {
            FSDirectory fsd = FSDirectory.open((File)s);
            if (IndexWriter.isLocked((Directory)fsd)) {
                log.warn((Object)("++++++++++++++++++Unlocking Index " + fsd.toString()));
                IndexWriter.unlock((Directory)fsd);
            }
            indexReaders[i] = IndexReader.open((Directory)FSDirectory.open((File)s), (boolean)false);
            ++i;
        }
        RefCountMultiReader newMultiReader = new RefCountMultiReader(indexReaders, this);
        if (this.multiReader != null) {
            this.multiReader.close();
        }
        this.multiReader = newMultiReader;
        this.lastUpdate = System.currentTimeMillis();
        log.debug((Object)("Reopened Index Reader in " + (this.lastUpdate - start) + " ms"));
        this.fireIndexReaderOpen((IndexReader)newMultiReader);
        return this.multiReader;
    }

    public IndexWriter getIndexWriter(boolean create) throws IOException {
        throw new UnsupportedOperationException("A JournaledFSIndexStorage only supports readers");
    }

    @Override
    public long getLastUpdate() {
        return this.lastUpdate;
    }

    @Override
    public List<Object[]> getSegmentInfoList() {
        ArrayList<Object[]> seginfo = new ArrayList<Object[]>();
        try {
            SizeAction sa = new SizeAction();
            File searchDir = new File(this.journalSettings.getSearchIndexDirectory());
            FileUtils.recurse((File)searchDir, (FileUtils.RecurseAction)sa);
            seginfo.add(new Object[]{"mainsegment", sa.sizeToString(sa.getSize()), sa.dateToString(sa.getLastUpdated())});
            sa.reset();
            for (File s : this.segments) {
                FileUtils.recurse((File)s, (FileUtils.RecurseAction)sa);
                seginfo.add(new Object[]{s.getName(), sa.sizeToString(sa.getSize()), sa.dateToString(sa.getLastUpdated())});
                sa.reset();
            }
            seginfo.add(new Object[]{"Total", sa.sizeToString(sa.getTotalSize()), ""});
        }
        catch (IOException ex) {
            if (log.isDebugEnabled()) {
                ex.printStackTrace();
            }
            seginfo.add(new Object[]{"Failed to get Segment Info list " + ex.getClass().getName() + " " + ex.getMessage()});
        }
        return seginfo;
    }

    public boolean indexExists() {
        File f = new File(this.journalSettings.getSearchIndexDirectory());
        return f.exists();
    }

    public boolean isMultipleIndexers() {
        return true;
    }

    public void setRecoverCorruptedIndex(boolean recover) {
        log.debug((Object)"Recover Indexes not implemented, yet");
    }

    public DataSource getDatasource() {
        return this.datasource;
    }

    public void setDatasource(DataSource datasource) {
        this.datasource = datasource;
    }

    public JournalManager getJournalManager() {
        return this.journalManager;
    }

    public void setJournalManager(JournalManager journalManager) {
        this.journalManager = journalManager;
    }

    public ServerConfigurationService getServerConfigurationService() {
        return this.serverConfigurationService;
    }

    public void setServerConfigurationService(ServerConfigurationService serverConfigurationService) {
        this.serverConfigurationService = serverConfigurationService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public void setJournalIndexEntry(long journalEntry) {
        block32: {
            if (this.journalSavePoint != journalEntry) {
                Connection connection = null;
                PreparedStatement updateJournalSavePointPst = null;
                Statement insertJournalSavePointPst = null;
                connection = this.datasource.getConnection();
                updateJournalSavePointPst = connection.prepareStatement("update search_node_status set jid = ?, jidts = ? where  serverid = ? ");
                updateJournalSavePointPst.clearParameters();
                updateJournalSavePointPst.setLong(1, journalEntry);
                updateJournalSavePointPst.setLong(2, System.currentTimeMillis());
                updateJournalSavePointPst.setString(3, this.serverId);
                if (updateJournalSavePointPst.executeUpdate() != 1) {
                    insertJournalSavePointPst = connection.prepareStatement("insert into  search_node_status (jid,jidts,serverid) values (?,?,?) ");
                    insertJournalSavePointPst.clearParameters();
                    insertJournalSavePointPst.setLong(1, journalEntry);
                    insertJournalSavePointPst.setLong(2, System.currentTimeMillis());
                    insertJournalSavePointPst.setString(3, this.serverId);
                    if (insertJournalSavePointPst.executeUpdate() != 1) {
                        throw new SQLException("Unable to update journal entry for some reason ");
                    }
                }
                connection.commit();
                this.journalSavePoint = journalEntry;
                Object var9_5 = null;
                try {
                    if (updateJournalSavePointPst != null) {
                        updateJournalSavePointPst.close();
                    }
                }
                catch (Exception ex2) {
                    log.debug((Object)ex2);
                }
                try {
                    if (insertJournalSavePointPst != null) {
                        insertJournalSavePointPst.close();
                    }
                }
                catch (Exception ex2) {
                    log.debug((Object)ex2);
                }
                try {
                    if (connection != null) {
                        connection.close();
                    }
                    break block32;
                }
                catch (Exception ex2) {
                    log.debug((Object)ex2);
                }
                break block32;
                {
                    catch (Exception ex) {
                        try {
                            connection.rollback();
                        }
                        catch (Exception ex2) {
                            log.debug((Object)ex);
                        }
                        log.warn((Object)"Unable to get Search Jorunal SavePoint ", (Throwable)ex);
                        Object var9_6 = null;
                        try {
                            if (updateJournalSavePointPst != null) {
                                updateJournalSavePointPst.close();
                            }
                        }
                        catch (Exception ex2) {
                            log.debug((Object)ex2);
                        }
                        try {
                            if (insertJournalSavePointPst != null) {
                                insertJournalSavePointPst.close();
                            }
                        }
                        catch (Exception ex2) {
                            log.debug((Object)ex2);
                        }
                        try {
                            if (connection != null) {
                                connection.close();
                            }
                            break block32;
                        }
                        catch (Exception ex2) {
                            log.debug((Object)ex2);
                        }
                    }
                }
                catch (Throwable throwable) {
                    Object var9_7 = null;
                    try {
                        if (updateJournalSavePointPst != null) {
                            updateJournalSavePointPst.close();
                        }
                    }
                    catch (Exception ex2) {
                        log.debug((Object)ex2);
                    }
                    try {
                        if (insertJournalSavePointPst != null) {
                            insertJournalSavePointPst.close();
                        }
                    }
                    catch (Exception ex2) {
                        log.debug((Object)ex2);
                    }
                    try {
                        if (connection != null) {
                            connection.close();
                        }
                    }
                    catch (Exception ex2) {
                        log.debug((Object)ex2);
                    }
                    throw throwable;
                }
            }
        }
    }

    protected void fireIndexReaderClose(IndexReader oldMultiReader) throws IOException {
        if (oldMultiReader == this.multiReader) {
            this.multiReader = null;
        }
        for (IndexListener tl : this.getIndexListeners()) {
            tl.doIndexReaderClose(oldMultiReader);
        }
    }

    protected void fireIndexReaderOpen(IndexReader newMultiReader) {
        for (IndexListener tl : this.getIndexListeners()) {
            tl.doIndexReaderOpen(newMultiReader);
        }
    }

    void fireIndexSearcherClose(IndexSearcher indexSearcher) throws IOException {
        for (IndexListener tl : this.getIndexListeners()) {
            tl.doIndexSearcherClose(indexSearcher);
        }
    }

    private void fireIndexSearcherOpen(IndexSearcher indexSearcher) throws IOException {
        for (IndexListener tl : this.getIndexListeners()) {
            tl.doIndexSearcherOpen(indexSearcher);
        }
    }

    private List<IndexListener> getIndexListeners() {
        return this.indexListeners;
    }

    @Override
    public void addIndexListener(IndexListener indexListener) {
        ArrayList<IndexListener> tl = new ArrayList<IndexListener>();
        tl.addAll(this.indexListeners);
        tl.add(indexListener);
        this.indexListeners = tl;
    }

    public void setIndexListener(List<IndexListener> indexListeners) {
        ArrayList<IndexListener> tl = new ArrayList<IndexListener>();
        tl.addAll(indexListeners);
        this.indexListeners = tl;
    }

    @Override
    public IndexWriter getPermanentIndexWriter() throws IndexTransactionException {
        if (!this.rwlock.isWriteLockedByCurrentThread()) {
            throw new JournalErrorException("Thread Does not hold a write lock, permanent index cannot be written to ");
        }
        if (this.permanentIndexWriter == null) {
            try {
                File f = new File(this.journalSettings.getSearchIndexDirectory());
                FSDirectory d = null;
                if (!f.exists()) {
                    if (!f.mkdirs()) {
                        throw new IOException("can't create index folder " + f.getPath());
                    }
                    log.debug((Object)("Indexing in " + f.getAbsolutePath()));
                    d = FSDirectory.open((File)new File(this.journalSettings.getSearchIndexDirectory()));
                } else {
                    d = FSDirectory.open((File)new File(this.journalSettings.getSearchIndexDirectory()));
                }
                if (!d.fileExists("segments.gen")) {
                    this.permanentIndexWriter = new IndexWriter((Directory)FSDirectory.open((File)f), this.getAnalyzer(), true, IndexWriter.MaxFieldLength.UNLIMITED);
                    this.permanentIndexWriter.setUseCompoundFile(true);
                    this.permanentIndexWriter.setMaxMergeDocs(this.journalSettings.getLocalMaxMergeDocs());
                    this.permanentIndexWriter.setMaxBufferedDocs(this.journalSettings.getLocalMaxBufferedDocs());
                    this.permanentIndexWriter.setMergeFactor(this.journalSettings.getLocalMaxMergeFactor());
                    Document doc = new Document();
                    doc.add((Fieldable)new Field("indexcreated", new Date().toString(), Field.Store.YES, Field.Index.NOT_ANALYZED, Field.TermVector.NO));
                    this.permanentIndexWriter.addDocument(doc);
                    this.permanentIndexWriter.close();
                }
                this.permanentIndexWriter = new MonitoredIndexWriter(f, this.getAnalyzer(), false);
                ((MonitoredIndexWriter)this.permanentIndexWriter).addMonitorIndexListener(new IndexMonitorListener(){

                    public void doIndexMonitorClose(IndexWriter writer) {
                        JournaledFSIndexStorage.this.permanentIndexWriter = null;
                    }
                });
                this.permanentIndexWriter.setUseCompoundFile(true);
                this.permanentIndexWriter.setMaxMergeDocs(100000);
                this.permanentIndexWriter.setMaxBufferedDocs(50);
                this.permanentIndexWriter.setMergeFactor(50);
            }
            catch (IOException ioex) {
                throw new JournalErrorException("Failed to open permanent Index ", ioex);
            }
        }
        return this.permanentIndexWriter;
    }

    @Override
    public File[] getSegments() {
        return this.segments.toArray(new File[0]);
    }

    @Override
    public void setSegments(List<File> keep) {
        this.segments = keep;
    }

    @Override
    public Analyzer getAnalyzer() {
        return this.analyzerFactory.newAnalyzer();
    }

    public AnalyzerFactory getAnalyzerFactory() {
        return this.analyzerFactory;
    }

    public void setAnalyzerFactory(AnalyzerFactory analzyserFactory) {
        this.analyzerFactory = analzyserFactory;
    }

    @Override
    public void saveSegmentList() throws IOException {
        File f = new File(this.journalSettings.getSearchIndexDirectory(), SEGMENT_LIST_NAME);
        SegmentListWriter sw = new SegmentListWriter(f);
        sw.write(this.segments);
    }

    public void loadSegmentList() throws IOException {
        File f = new File(this.journalSettings.getSearchIndexDirectory(), SEGMENT_LIST_NAME);
        SegmentListReader sr = new SegmentListReader(f);
        this.segments = sr.read();
    }

    public ClusterService getClusterService() {
        return this.clusterService;
    }

    public void setClusterService(ClusterService clusterService) {
        this.clusterService = clusterService;
    }

    @Override
    public void loadIndexReader() throws IOException {
        this.loadIndexSearcherInternal();
    }

    @Override
    public void debugLock() {
        log.info((Object)(this + " Locks Waiting " + this.rwlock.getQueueLength()));
        log.info((Object)(this + " Read Locks Locks " + this.rwlock.getReadLockCount()));
        log.info((Object)(this + " Write Holds this thread " + this.rwlock.getWriteHoldCount()));
        log.info((Object)(this + " is Write Locked " + this.rwlock.isWriteLocked()));
    }

    @Override
    public long getLastLoad() {
        return this.lastLoad;
    }

    @Override
    public long getLastLoadTime() {
        return this.lastLoadTime;
    }

    public JournalSettings getJournalSettings() {
        return this.journalSettings;
    }

    public void setJournalSettings(JournalSettings journalSettings) {
        this.journalSettings = journalSettings;
    }

    public void markModified() throws IOException {
        this.modified = true;
        if (this.multiReader != null) {
            this.multiReader.close();
            this.multiReader = null;
        }
    }

    public ThreadLocalManager getThreadLocalManager() {
        return this.threadLocalManager;
    }

    public void setThreadLocalManager(ThreadLocalManager threadLocalManager) {
        this.threadLocalManager = threadLocalManager;
    }

    private void createSpellIndex(IndexReader indexReader) {
        if (!this.serverConfigurationService.getBoolean("search.experimental.didyoumean", false)) {
            return;
        }
        log.info((Object)"create Spell Index");
        Long start = System.currentTimeMillis();
        try {
            log.info((Object)("main index is in: " + this.journalSettings.getSearchIndexDirectory()));
            log.info((Object)("local base is: " + this.journalSettings.getLocalIndexBase()));
            this.spellIndexDirectory = new NIOFSDirectory(new File(this.journalSettings.getLocalIndexBase() + "/spellindex"));
            if (indexReader == null) {
                log.info((Object)"unable to get index reader aborting spellindex creation");
                return;
            }
            LuceneDictionary dictionary = new LuceneDictionary(indexReader, "contents");
            SpellChecker spellChecker = new SpellChecker(this.spellIndexDirectory);
            spellChecker.clearIndex();
            spellChecker.indexDictionary((Dictionary)dictionary);
            log.info((Object)("New Spell dictionary constructed in " + (System.currentTimeMillis() - start)));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        log.info((Object)("All done in " + (System.currentTimeMillis() - start)));
    }

    @Override
    public Directory getSpellDirectory() {
        return this.spellIndexDirectory;
    }

    private static class SizeAction
    implements FileUtils.RecurseAction {
        private long size = 0L;
        private long totalSize = 0L;
        private long lastUpdate = 0L;

        private SizeAction() {
        }

        public void doAfterFile(File f) {
        }

        public String dateToString(long lastUpdated) {
            return new Date(lastUpdated).toString();
        }

        public long getLastUpdated() {
            return this.lastUpdate;
        }

        public void doBeforeFile(File f) {
        }

        public void doFile(File file) throws IOException {
            this.size += file.length();
            this.lastUpdate = Math.max(this.lastUpdate, file.lastModified());
            this.totalSize += file.length();
        }

        public long getSize() {
            return this.size;
        }

        public long getTotalSize() {
            return this.totalSize;
        }

        public void reset() {
            this.lastUpdate = 0L;
            this.size = 0L;
        }

        public String sizeToString(long tsize) {
            if (tsize > 0xA00000L) {
                return String.valueOf(tsize / 0x100000L) + "MB";
            }
            if (tsize >= 0x100000L) {
                return String.valueOf(tsize / 0x100000L) + "." + String.valueOf(tsize / 104448L + "MB");
            }
            return String.valueOf(tsize / 1024L) + "KB";
        }
    }
}

