/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.search.optimize.impl;

import java.util.HashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sakaiproject.search.journal.api.JournalErrorException;
import org.sakaiproject.search.journal.api.JournalExhausetedException;
import org.sakaiproject.search.journal.api.JournaledObject;
import org.sakaiproject.search.journal.api.ManagementOperation;
import org.sakaiproject.search.optimize.api.NoOptimizationRequiredException;
import org.sakaiproject.search.optimize.impl.IndexOptimizeTransactionImpl;
import org.sakaiproject.search.optimize.impl.OptimizeIndexManager;
import org.sakaiproject.search.transaction.api.IndexTransactionException;
import org.sakaiproject.search.transaction.impl.IndexTransactionImpl;

public class OptimizeIndexOperation
implements ManagementOperation {
    private static final Log log = LogFactory.getLog(OptimizeIndexOperation.class);
    private JournaledObject journaledObject;
    private OptimizeIndexManager optimizeUpdateManager;

    public void destroy() {
    }

    public void init() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void runOnce() {
        if (this.journaledObject.aquireUpdateLock()) {
            log.debug((Object)("Now Locked Journaled savePoint is " + this.journaledObject.getLastJournalEntry()));
            try {
                try {
                    IndexTransactionImpl optimizeUpdateTransaction = null;
                    try {
                        HashMap<String, Object> m = new HashMap<String, Object>();
                        optimizeUpdateTransaction = (IndexOptimizeTransactionImpl)this.optimizeUpdateManager.openTransaction(m);
                        optimizeUpdateTransaction.prepare();
                        optimizeUpdateTransaction.commit();
                        log.debug((Object)"Optimize complete ");
                        return;
                    }
                    catch (JournalErrorException jex) {
                        if (optimizeUpdateTransaction != null) {
                            log.warn((Object)"Failed to complete Optimize ", (Throwable)jex);
                        } else {
                            log.warn((Object)"Failed to start merge operation ", (Throwable)jex);
                        }
                        try {
                            if (optimizeUpdateTransaction == null) return;
                            optimizeUpdateTransaction.rollback();
                            return;
                        }
                        catch (Exception ex) {
                            log.warn((Object)"Failed to rollback transaction ", (Throwable)ex);
                        }
                        return;
                    }
                    catch (NoOptimizationRequiredException nop) {
                        log.debug((Object)("No Merge Performed " + nop.getMessage()));
                        return;
                    }
                    catch (IndexTransactionException iupex) {
                        log.warn((Object)"Failed to complete optimize ", (Throwable)iupex);
                        try {
                            optimizeUpdateTransaction.rollback();
                            return;
                        }
                        catch (Exception ex) {
                            log.warn((Object)"Failed to rollback transaction ", (Throwable)ex);
                        }
                        return;
                        {
                            catch (Throwable throwable) {
                                throw throwable;
                            }
                        }
                    }
                    finally {
                        try {
                            if (optimizeUpdateTransaction != null) {
                                optimizeUpdateTransaction.close();
                            }
                        }
                        catch (Exception ex) {
                            log.debug((Object)ex);
                        }
                    }
                }
                catch (JournalExhausetedException ex) {
                    if (!log.isDebugEnabled()) return;
                    log.debug((Object)"No More Jounral Entries ", (Throwable)ex);
                }
                return;
            }
            finally {
                this.journaledObject.releaseUpdateLock();
            }
        }
        log.warn((Object)"No Lock, index update abandoned");
    }

    public JournaledObject getJournaledObject() {
        return this.journaledObject;
    }

    public void setJournaledObject(JournaledObject journaledObject) {
        this.journaledObject = journaledObject;
    }

    public OptimizeIndexManager getOptimizeUpdateManager() {
        return this.optimizeUpdateManager;
    }

    public void setOptimizeUpdateManager(OptimizeIndexManager optimizeUpdateManager) {
        this.optimizeUpdateManager = optimizeUpdateManager;
    }
}

