/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.search.optimize.shared.impl;

import java.util.HashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sakaiproject.component.api.ServerConfigurationService;
import org.sakaiproject.search.indexer.api.LockTimeoutException;
import org.sakaiproject.search.journal.api.JournalErrorException;
import org.sakaiproject.search.journal.api.ManagementOperation;
import org.sakaiproject.search.optimize.api.NoOptimizationRequiredException;
import org.sakaiproject.search.optimize.shared.api.JournalOptimizationManager;
import org.sakaiproject.search.optimize.shared.api.JournalOptimizationTransaction;
import org.sakaiproject.search.transaction.api.IndexTransaction;
import org.sakaiproject.search.transaction.api.IndexTransactionException;

public class JournalOptimizationOperation
implements ManagementOperation {
    private static final Log log = LogFactory.getLog(JournalOptimizationOperation.class);
    private JournalOptimizationManager journalOptimizationManager;
    private ServerConfigurationService serverConfigurationService;

    public void init() {
    }

    public void destroy() {
    }

    public void setServerConfigurationService(ServerConfigurationService serverConfigurationService) {
        this.serverConfigurationService = serverConfigurationService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runOnce() {
        if (!this.serverConfigurationService.getBoolean("search.sharedmerge", true)) {
            return;
        }
        IndexTransaction journalOptimizationTransaction = null;
        try {
            HashMap<String, Object> m = new HashMap<String, Object>();
            journalOptimizationTransaction = (JournalOptimizationTransaction)this.journalOptimizationManager.openTransaction(m);
            journalOptimizationTransaction.prepare();
            journalOptimizationTransaction.commit();
        }
        catch (NoOptimizationRequiredException nop) {
            log.debug((Object)("No Merge Performed " + nop.getMessage()));
        }
        catch (LockTimeoutException jex) {
            log.info((Object)("Failed to perform optimise, pending  Optimize on other node if cause is a DB lock timeout Cause:" + jex.getMessage()));
            try {
                journalOptimizationTransaction.rollback();
            }
            catch (Exception ex) {
                log.warn((Object)"Failed to rollback transaction ", (Throwable)ex);
            }
        }
        catch (JournalErrorException jex) {
            if (journalOptimizationTransaction != null) {
                log.warn((Object)"Failed to complete Optimize ", (Throwable)jex);
            } else {
                log.warn((Object)"Failed to start merge operation ", (Throwable)jex);
            }
            try {
                if (journalOptimizationTransaction != null) {
                    journalOptimizationTransaction.rollback();
                }
            }
            catch (Exception ex) {
                log.warn((Object)"Failed to rollback transaction ", (Throwable)ex);
            }
        }
        catch (IndexTransactionException iupex) {
            log.warn((Object)"Failed to complete optimize ", (Throwable)iupex);
            try {
                if (journalOptimizationTransaction != null) {
                    journalOptimizationTransaction.rollback();
                }
            }
            catch (Exception ex) {
                log.warn((Object)"Failed to rollback transaction ", (Throwable)ex);
            }
        }
        finally {
            try {
                if (journalOptimizationTransaction != null) {
                    journalOptimizationTransaction.close();
                }
            }
            catch (Exception ex) {
                log.debug((Object)ex);
            }
        }
    }

    public JournalOptimizationManager getJournalOptimizationManager() {
        return this.journalOptimizationManager;
    }

    public void setJournalOptimizationManager(JournalOptimizationManager journalOptimizationManager) {
        this.journalOptimizationManager = journalOptimizationManager;
    }
}

