/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.search.optimize.shared.impl;

import java.io.File;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sakaiproject.search.indexer.api.IndexJournalException;
import org.sakaiproject.search.indexer.api.IndexUpdateTransactionListener;
import org.sakaiproject.search.journal.impl.SharedFilesystemJournalStorage;
import org.sakaiproject.search.optimize.shared.api.JournalOptimizationTransaction;
import org.sakaiproject.search.transaction.api.IndexTransaction;
import org.sakaiproject.search.transaction.api.IndexTransactionException;
import org.sakaiproject.search.util.FileUtils;

public class SharedFilesystemLoadTransactionListener
implements IndexUpdateTransactionListener {
    private static final Log log = LogFactory.getLog(SharedFilesystemLoadTransactionListener.class);
    private SharedFilesystemJournalStorage sharedFilesystemJournalStorage;

    public void init() {
    }

    public void destroy() {
    }

    public void prepare(IndexTransaction transaction) throws IndexJournalException {
        try {
            JournalOptimizationTransaction jtransaction = (JournalOptimizationTransaction)transaction;
            String workingSpace = jtransaction.getWorkingSpace();
            for (long savePoint : jtransaction.getMergeList()) {
                this.sharedFilesystemJournalStorage.retrieveSavePoint(savePoint, workingSpace);
                jtransaction.addMergeSegment(this.sharedFilesystemJournalStorage.getLocalJournalLocation(savePoint, workingSpace));
            }
            this.sharedFilesystemJournalStorage.retrieveSavePoint(jtransaction.getTargetSavePoint(), workingSpace);
            jtransaction.setTargetSegment(this.sharedFilesystemJournalStorage.getLocalJournalLocation(jtransaction.getTargetSavePoint(), workingSpace));
        }
        catch (Exception ex) {
            throw new IndexJournalException("Failed to retrieve Journaled Segments for processing ", ex);
        }
    }

    public void commit(IndexTransaction transaction) throws IndexTransactionException {
        try {
            JournalOptimizationTransaction jtransaction = (JournalOptimizationTransaction)transaction;
            List<Long> mergeList = jtransaction.getMergeList();
            mergeList.remove(mergeList.size() - 1);
            Iterator<Comparable<Long>> i$ = jtransaction.getMergeList().iterator();
            while (i$.hasNext()) {
                long savePoint = i$.next();
                this.sharedFilesystemJournalStorage.removeJournal(savePoint);
            }
            for (File f : jtransaction.getMergeSegmentList()) {
                log.debug((Object)("Deleting Segment " + f.getPath()));
                FileUtils.deleteAll((File)f);
            }
            log.debug((Object)("Deleting Segment " + jtransaction.getTargetSegment().getPath()));
            FileUtils.deleteAll((File)jtransaction.getTargetSegment());
        }
        catch (Exception ex) {
            throw new IndexJournalException("Failed to retrieve Journaled Segments for processing ", ex);
        }
    }

    public void open(IndexTransaction transaction) {
    }

    public void close(IndexTransaction transaction) throws IndexTransactionException {
    }

    public void rollback(IndexTransaction transaction) throws IndexJournalException {
        try {
            JournalOptimizationTransaction jtransaction = (JournalOptimizationTransaction)transaction;
            if (jtransaction.getMergeSegmentList() != null) {
                for (File f : jtransaction.getMergeSegmentList()) {
                    FileUtils.deleteAll((File)f);
                }
            }
            if (jtransaction.getTargetSegment() != null) {
                FileUtils.deleteAll((File)jtransaction.getTargetSegment());
            }
        }
        catch (Exception ex) {
            throw new IndexJournalException("Failed to rollback Journaled Segments ", ex);
        }
    }

    public SharedFilesystemJournalStorage getSharedFilesystemJournalStorage() {
        return this.sharedFilesystemJournalStorage;
    }

    public void setSharedFilesystemJournalStorage(SharedFilesystemJournalStorage sharedFilesystemJournalStorage) {
        this.sharedFilesystemJournalStorage = sharedFilesystemJournalStorage;
    }
}

