/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.search.component.adapter.contenthosting;

import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sakaiproject.search.component.adapter.contenthosting.ContentDigester;
import org.sakaiproject.search.component.adapter.contenthosting.ContentHostingContentProducer;

public abstract class BaseContentDigester
implements ContentDigester {
    private static Log log = LogFactory.getLog(BaseContentDigester.class);
    private ContentHostingContentProducer contentProducer = null;
    protected int maxDigestSize = 0x500000;
    private Map mimeTypes = null;

    public void init() {
        try {
            this.contentProducer.addDigester(this);
        }
        catch (Throwable t) {
            log.error((Object)"Failed to init", t);
        }
    }

    public void destroy() {
        this.contentProducer.removeDigester(this);
    }

    public boolean accept(String mimeType) {
        return this.mimeTypes.get(mimeType) != null;
    }

    public Map getMimeTypes() {
        return this.mimeTypes;
    }

    public void setMimeTypes(Map mimeTypes) {
        this.mimeTypes = mimeTypes;
    }

    public ContentHostingContentProducer getContentProducer() {
        return this.contentProducer;
    }

    public void setContentProducer(ContentHostingContentProducer contentProducer) {
        this.contentProducer = contentProducer;
    }

    public int getMaxDigestSize() {
        return this.maxDigestSize;
    }

    public void setMaxDigestSize(int maxDigestSize) {
        this.maxDigestSize = maxDigestSize;
    }
}

