/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.search.component.service.impl;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sakaiproject.event.api.Event;
import org.sakaiproject.event.api.Notification;
import org.sakaiproject.search.api.EntityContentProducer;
import org.sakaiproject.search.api.SearchIndexBuilder;
import org.sakaiproject.search.dao.SearchBuilderItemDao;
import org.sakaiproject.search.indexer.api.IndexQueueListener;
import org.sakaiproject.search.model.SearchBuilderItem;
import org.sakaiproject.site.api.Site;
import org.sakaiproject.site.api.ToolConfiguration;
import org.sakaiproject.site.cover.SiteService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SearchIndexBuilderImpl
implements SearchIndexBuilder {
    private static Log log = LogFactory.getLog(SearchIndexBuilderImpl.class);
    private SearchBuilderItemDao searchBuilderItemDao = null;
    private List<EntityContentProducer> producers = new ArrayList<EntityContentProducer>();
    private boolean onlyIndexSearchToolSites = false;
    private List<IndexQueueListener> indexQueueListeners = new ArrayList<IndexQueueListener>();
    private boolean excludeUserSites = true;

    public void init() {
    }

    public void registerEntityContentProducer(EntityContentProducer ecp) {
        log.debug((Object)("register " + ecp));
        this.producers.add(ecp);
    }

    public void addResource(Notification notification, Event event) {
        log.debug((Object)("Add resource " + notification + "::" + event));
        String resourceName = event.getResource();
        if (resourceName == null) {
            resourceName = "";
        }
        if (resourceName.length() > 255) {
            log.warn((Object)("Entity Reference is longer than 255 characters, not indexing. Reference=" + resourceName));
            return;
        }
        EntityContentProducer ecp = this.newEntityContentProducer(event);
        if (ecp == null || ecp.getSiteId(resourceName) == null) {
            log.debug((Object)("Not indexing " + resourceName + " as it has no context"));
            return;
        }
        if (this.onlyIndexSearchToolSites) {
            try {
                String siteId = ecp.getSiteId(resourceName);
                Site s = SiteService.getSite((String)siteId);
                ToolConfiguration t = s.getToolForCommonId("sakai.search");
                if (t == null) {
                    log.debug((Object)("Not indexing " + resourceName + " as it has no search tool"));
                    return;
                }
            }
            catch (Exception ex) {
                log.debug((Object)("Not indexing  " + resourceName + " as it has no site"), (Throwable)ex);
                return;
            }
        }
        Integer action = ecp.getAction(event);
        try {
            String siteId;
            SearchBuilderItem sb = this.searchBuilderItemDao.findByName(resourceName);
            if (sb == null) {
                sb = this.searchBuilderItemDao.create();
                sb.setSearchaction(action);
                sb.setName(resourceName);
                siteId = ecp.getSiteId(resourceName);
                if (siteId == null || siteId.length() == 0) {
                    siteId = "none";
                }
                sb.setContext(siteId);
                sb.setSearchstate(SearchBuilderItem.STATE_PENDING);
                sb.setItemscope(SearchBuilderItem.ITEM);
            } else {
                sb.setSearchaction(action);
                siteId = ecp.getSiteId(resourceName);
                if (siteId == null || siteId.length() == 0) {
                    siteId = "none";
                }
                sb.setContext(siteId);
                sb.setName(resourceName);
                sb.setSearchstate(SearchBuilderItem.STATE_PENDING);
                sb.setItemscope(SearchBuilderItem.ITEM);
            }
            this.searchBuilderItemDao.update(sb);
            log.debug((Object)("SEARCHBUILDER: Added Resource " + action + " " + sb.getName()));
            this.fireResourceAdded(resourceName);
        }
        catch (Throwable t) {
            log.debug((Object)("In trying to register resource " + resourceName + " in search engine this resource will" + " not be indexed untill it is modified"));
        }
    }

    protected void fireResourceAdded(String name) {
        for (IndexQueueListener tl : this.indexQueueListeners) {
            tl.added(name);
        }
    }

    public void addIndexQueueListener(IndexQueueListener indexQueueListener) {
        ArrayList<IndexQueueListener> tl = new ArrayList<IndexQueueListener>();
        tl.addAll(this.indexQueueListeners);
        tl.add(indexQueueListener);
        this.indexQueueListeners = tl;
    }

    public void removeIndexQueueListener(IndexQueueListener indexQueueListener) {
        ArrayList<IndexQueueListener> tl = new ArrayList<IndexQueueListener>();
        tl.addAll(this.indexQueueListeners);
        tl.remove(indexQueueListener);
        this.indexQueueListeners = tl;
    }

    public void refreshIndex() {
        SearchBuilderItem sb = this.searchBuilderItemDao.findByName("_master_control_global");
        if (sb == null) {
            log.debug((Object)"Created NEW _master_control_global");
            sb = this.searchBuilderItemDao.create();
        }
        if (SearchBuilderItem.STATE_COMPLETED.equals(sb.getSearchstate()) || !SearchBuilderItem.ACTION_REBUILD.equals(sb.getSearchaction()) && !SearchBuilderItem.STATE_PENDING.equals(sb.getSearchstate()) && !SearchBuilderItem.STATE_PENDING_2.equals(sb.getSearchstate())) {
            sb.setSearchaction(SearchBuilderItem.ACTION_REFRESH);
            sb.setName("_master_control_global");
            sb.setContext("global");
            sb.setSearchstate(SearchBuilderItem.STATE_PENDING);
            sb.setItemscope(SearchBuilderItem.ITEM_GLOBAL_MASTER);
            this.searchBuilderItemDao.update(sb);
            log.debug((Object)("SEARCHBUILDER: REFRESH ALL " + sb.getSearchaction() + " " + sb.getName()));
            this.fireResourceAdded(String.valueOf("_master_control_global"));
        } else {
            log.debug((Object)("SEARCHBUILDER: REFRESH ALL IN PROGRESS " + sb.getSearchaction() + " " + sb.getName()));
        }
    }

    public void destroy() {
    }

    public void rebuildIndex() {
        try {
            SearchBuilderItem sb = this.searchBuilderItemDao.findByName("_master_control_global");
            if (sb == null) {
                sb = this.searchBuilderItemDao.create();
            }
            sb.setSearchaction(SearchBuilderItem.ACTION_REBUILD);
            sb.setName("_master_control_global");
            sb.setContext("global");
            sb.setSearchstate(SearchBuilderItem.STATE_PENDING);
            sb.setItemscope(SearchBuilderItem.ITEM_GLOBAL_MASTER);
            this.searchBuilderItemDao.update(sb);
            log.debug((Object)("SEARCHBUILDER: REBUILD ALL " + sb.getSearchaction() + " " + sb.getName()));
            this.fireResourceAdded(String.valueOf("_master_control_global"));
        }
        catch (Exception ex) {
            log.warn((Object)(" rebuild index encountered a problme " + ex.getMessage()));
        }
    }

    public EntityContentProducer newEntityContentProducer(String ref) {
        log.debug((Object)" new entitycontent producer");
        for (EntityContentProducer ecp : this.producers) {
            if (!ecp.matches(ref)) continue;
            return ecp;
        }
        return null;
    }

    public EntityContentProducer newEntityContentProducer(Event event) {
        log.debug((Object)" new entitycontent producer");
        for (EntityContentProducer ecp : this.producers) {
            if (ecp.matches(event)) {
                log.debug((Object)(" Matched Entity Content Producer for event " + event + " with " + ecp));
                return ecp;
            }
            log.debug((Object)("Skipped ECP " + ecp));
        }
        log.debug((Object)("Failed to match any Entity Content Producer for event " + event));
        return null;
    }

    public SearchBuilderItemDao getSearchBuilderItemDao() {
        return this.searchBuilderItemDao;
    }

    public void setSearchBuilderItemDao(SearchBuilderItemDao searchBuilderItemDao) {
        this.searchBuilderItemDao = searchBuilderItemDao;
    }

    public boolean isBuildQueueEmpty() {
        int n = this.searchBuilderItemDao.countPending();
        log.debug((Object)("Queue has " + n));
        return n == 0;
    }

    public List<EntityContentProducer> getContentProducers() {
        return new ArrayList<EntityContentProducer>(this.producers);
    }

    public int getPendingDocuments() {
        return this.searchBuilderItemDao.countPending();
    }

    public void rebuildIndex(String currentSiteId) {
        try {
            String siteMaster;
            SearchBuilderItem sb;
            if (currentSiteId == null || currentSiteId.length() == 0) {
                currentSiteId = "none";
            }
            if ((sb = this.searchBuilderItemDao.findByName(siteMaster = MessageFormat.format("_master_control_{0}", currentSiteId))) == null) {
                sb = this.searchBuilderItemDao.create();
            }
            sb.setSearchaction(SearchBuilderItem.ACTION_REBUILD);
            sb.setName(siteMaster);
            sb.setContext(currentSiteId);
            sb.setSearchstate(SearchBuilderItem.STATE_PENDING);
            sb.setItemscope(SearchBuilderItem.ITEM_SITE_MASTER);
            this.searchBuilderItemDao.update(sb);
            log.debug((Object)("SEARCHBUILDER: REBUILD CONTEXT " + sb.getSearchaction() + " " + sb.getName()));
            this.fireResourceAdded(sb.getName());
        }
        catch (Exception ex) {
            log.warn((Object)(" rebuild index encountered a problme " + ex.getMessage()));
        }
    }

    public void refreshIndex(String currentSiteId) {
        String siteMaster;
        SearchBuilderItem sb;
        if (currentSiteId == null || currentSiteId.length() == 0) {
            currentSiteId = "none";
        }
        if ((sb = this.searchBuilderItemDao.findByName(siteMaster = MessageFormat.format("_master_control_{0}", currentSiteId))) == null) {
            log.debug((Object)("Created NEW " + siteMaster));
            sb = this.searchBuilderItemDao.create();
            sb.setContext(currentSiteId);
            sb.setName(siteMaster);
            sb.setSearchstate(SearchBuilderItem.STATE_COMPLETED);
            sb.setSearchaction(SearchBuilderItem.ACTION_REFRESH);
            sb.setItemscope(SearchBuilderItem.ITEM_SITE_MASTER);
        }
        if (SearchBuilderItem.STATE_COMPLETED.equals(sb.getSearchstate()) || !SearchBuilderItem.ACTION_REBUILD.equals(sb.getSearchaction()) && !SearchBuilderItem.STATE_PENDING.equals(sb.getSearchstate()) && !SearchBuilderItem.STATE_PENDING_2.equals(sb.getSearchstate())) {
            sb.setSearchaction(SearchBuilderItem.ACTION_REFRESH);
            sb.setName(siteMaster);
            sb.setContext(currentSiteId);
            sb.setSearchstate(SearchBuilderItem.STATE_PENDING);
            sb.setItemscope(SearchBuilderItem.ITEM_SITE_MASTER);
            this.searchBuilderItemDao.update(sb);
            log.debug((Object)("SEARCHBUILDER: REFRESH CONTEXT " + sb.getSearchaction() + " " + sb.getName()));
            this.fireResourceAdded(sb.getName());
        } else {
            log.debug((Object)("SEARCHBUILDER: REFRESH CONTEXT IN PROGRESS " + sb.getSearchaction() + " " + sb.getName()));
        }
    }

    public List<SearchBuilderItem> getAllSearchItems() {
        return this.searchBuilderItemDao.getAll();
    }

    public List<SearchBuilderItem> getGlobalMasterSearchItems() {
        return this.searchBuilderItemDao.getGlobalMasters();
    }

    public List<SearchBuilderItem> getSiteMasterSearchItems() {
        return this.searchBuilderItemDao.getSiteMasters();
    }

    public boolean isOnlyIndexSearchToolSites() {
        return this.onlyIndexSearchToolSites;
    }

    public void setOnlyIndexSearchToolSites(boolean onlyIndexSearchToolSites) {
        this.onlyIndexSearchToolSites = onlyIndexSearchToolSites;
    }

    public void setExcludeUserSites(boolean excludeUserSites) {
        this.excludeUserSites = excludeUserSites;
    }

    public boolean isExcludeUserSites() {
        return this.excludeUserSites;
    }
}

