/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.search.component.service.impl;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class StringUtils {
    private static final Log log = LogFactory.getLog(StringUtils.class);
    public static final char HIGHEST_CHARACTER = '>';
    public static final char[][] specialChars = new char[63][];

    public static String escapeHtml(String value, boolean escapeNewlines) {
        if (value == null) {
            return "";
        }
        try {
            StringBuilder buf = null;
            int len = value.length();
            block9: for (int i = 0; i < len; ++i) {
                char c = value.charAt(i);
                switch (c) {
                    case '<': {
                        if (buf == null) {
                            buf = new StringBuilder(value.substring(0, i));
                        }
                        buf.append("&lt;");
                        continue block9;
                    }
                    case '>': {
                        if (buf == null) {
                            buf = new StringBuilder(value.substring(0, i));
                        }
                        buf.append("&gt;");
                        continue block9;
                    }
                    case '&': {
                        if (buf == null) {
                            buf = new StringBuilder(value.substring(0, i));
                        }
                        buf.append("&amp;");
                        continue block9;
                    }
                    case '\"': {
                        if (buf == null) {
                            buf = new StringBuilder(value.substring(0, i));
                        }
                        buf.append("&quot;");
                        continue block9;
                    }
                    case '\n': {
                        if (escapeNewlines) {
                            if (buf == null) {
                                buf = new StringBuilder(value.substring(0, i));
                            }
                            buf.append("<br />\n");
                            continue block9;
                        }
                        if (buf == null) continue block9;
                        buf.append(c);
                        continue block9;
                    }
                    default: {
                        if (c < '\u0080') {
                            if (buf == null) continue block9;
                            buf.append(c);
                            continue block9;
                        }
                        if (buf == null) {
                            buf = new StringBuilder(value.substring(0, i));
                        }
                        buf.append("&#");
                        buf.append(Integer.toString(c));
                        buf.append(";");
                    }
                }
            }
            return buf == null ? value : buf.toString();
        }
        catch (Exception e) {
            log.warn((Object)"Validator.escapeHtml: ", (Throwable)e);
            return value;
        }
    }

    public static String xmlEscape(String toEscape) {
        char[] chars = toEscape.toCharArray();
        int lastEscapedBefore = 0;
        StringBuilder escapedString = null;
        for (int i = 0; i < chars.length; ++i) {
            char[] escapedPortion;
            if (chars[i] > '>' || (escapedPortion = specialChars[chars[i]]) == null) continue;
            if (lastEscapedBefore == 0) {
                escapedString = new StringBuilder(chars.length + 5);
            }
            if (lastEscapedBefore < i) {
                escapedString.append(chars, lastEscapedBefore, i - lastEscapedBefore);
            }
            lastEscapedBefore = i + 1;
            escapedString.append(escapedPortion);
        }
        if (lastEscapedBefore == 0) {
            return toEscape;
        }
        if (lastEscapedBefore < chars.length) {
            escapedString.append(chars, lastEscapedBefore, chars.length - lastEscapedBefore);
        }
        return escapedString.toString();
    }

    static {
        StringUtils.specialChars[62] = "&gt;".toCharArray();
        StringUtils.specialChars[60] = "&lt;".toCharArray();
        StringUtils.specialChars[38] = "&amp;".toCharArray();
        StringUtils.specialChars[34] = "&#34;".toCharArray();
        StringUtils.specialChars[39] = "&#39;".toCharArray();
    }
}

