/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.search.indexer.impl;

import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sakaiproject.db.cover.SqlService;
import org.sakaiproject.javax.PagingPosition;
import org.sakaiproject.search.api.EntityContentProducer;
import org.sakaiproject.search.api.SearchIndexBuilder;
import org.sakaiproject.search.indexer.api.IndexUpdateTransactionListener;
import org.sakaiproject.search.model.SearchBuilderItem;
import org.sakaiproject.search.model.impl.SearchBuilderItemImpl;
import org.sakaiproject.search.transaction.api.IndexItemsTransaction;
import org.sakaiproject.search.transaction.api.IndexTransaction;
import org.sakaiproject.search.transaction.api.IndexTransactionException;
import org.sakaiproject.search.transaction.api.TransactionSequence;
import org.sakaiproject.site.api.Site;
import org.sakaiproject.site.api.SiteService;
import org.sakaiproject.site.api.ToolConfiguration;
import org.sakaiproject.thread_local.api.ThreadLocalManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SearchBuilderQueueManager
implements IndexUpdateTransactionListener {
    private static final Log log = LogFactory.getLog(SearchBuilderQueueManager.class);
    private static final String SEARCH_BUILDER_ITEM_FIELDS = " name, context,  searchaction, searchstate, version, itemscope, id ";
    private static final String SEARCH_BUILDER_ITEM_T = "searchbuilderitem";
    private static final String SEARCH_BUILDER_ITEM_FIELDS_PARAMS = " ?, ?, ?,  ?, ?, ?, ? ";
    private static final String SEARCH_BUILDER_ITEM_FIELDS_UPDATE = " name = ?, context = ?,  searchaction = ?, searchstate = ?, version = ?, itemscope = ? where id = ? ";
    public static final String BATCH_SIZE = "batch-size";
    private SearchIndexBuilder searchIndexBuilder;
    private DataSource datasource;
    private int nodeLock;
    private TransactionSequence sequence;
    private SiteService siteService;
    private ThreadLocalManager threadLocalManager;
    protected boolean autoDdl = false;

    public void setThreadLocalManager(ThreadLocalManager threadLocalManager) {
        this.threadLocalManager = threadLocalManager;
    }

    public void init() {
        try {
            if (this.autoDdl) {
                SqlService.getInstance().ddl(this.getClass().getClassLoader(), "sakai_search_parallel");
            }
        }
        catch (Exception ex) {
            log.error((Object)"Perform additional SQL setup", (Throwable)ex);
        }
        this.nodeLock = (int)this.sequence.getNextId();
    }

    public void destroy() {
    }

    @Override
    public void prepare(IndexTransaction transaction) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public void commit(IndexTransaction transaction) {
        block14: {
            Connection connection = null;
            connection = this.datasource.getConnection();
            this.commitPendingAndUnLock(((IndexItemsTransaction)transaction).getItems(), connection);
            connection.commit();
            Object var6_3 = null;
            try {
                if (connection != null) {
                    connection.close();
                }
                break block14;
            }
            catch (Exception ex2) {
                log.warn((Object)"error closing connection in commit", (Throwable)ex2);
            }
            break block14;
            {
                catch (Exception ex) {
                    try {
                        if (connection != null) {
                            connection.rollback();
                        }
                    }
                    catch (Exception ex2) {
                        log.warn((Object)"error during rollback in commit", (Throwable)ex2);
                    }
                    Object var6_4 = null;
                    try {
                        if (connection != null) {
                            connection.close();
                        }
                        break block14;
                    }
                    catch (Exception ex2) {
                        log.warn((Object)"error closing connection in commit", (Throwable)ex2);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var6_5 = null;
                try {
                    if (connection != null) {
                        connection.close();
                    }
                }
                catch (Exception ex2) {
                    log.warn((Object)"error closing connection in commit", (Throwable)ex2);
                }
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public void rollback(IndexTransaction transaction) {
        block14: {
            Connection connection = null;
            connection = this.datasource.getConnection();
            this.rollbackPendingAndUnLock(((IndexItemsTransaction)transaction).getItems(), connection);
            connection.commit();
            Object var6_3 = null;
            try {
                if (connection != null) {
                    connection.close();
                }
                break block14;
            }
            catch (Exception ex2) {
                log.debug((Object)"Exception closing connection", (Throwable)ex2);
            }
            break block14;
            {
                catch (Exception ex) {
                    try {
                        if (connection != null) {
                            connection.rollback();
                        }
                    }
                    catch (Exception ex2) {
                        log.debug((Object)"Exception during rollback", (Throwable)ex2);
                    }
                    Object var6_4 = null;
                    try {
                        if (connection != null) {
                            connection.close();
                        }
                        break block14;
                    }
                    catch (Exception ex2) {
                        log.debug((Object)"Exception closing connection", (Throwable)ex2);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var6_5 = null;
                try {
                    if (connection != null) {
                        connection.close();
                    }
                }
                catch (Exception ex2) {
                    log.debug((Object)"Exception closing connection", (Throwable)ex2);
                }
                throw throwable;
            }
        }
    }

    /*
     * Loose catch block
     */
    @Override
    public void open(IndexTransaction transaction) throws IndexTransactionException {
        block13: {
            Connection connection = null;
            connection = this.datasource.getConnection();
            Integer bs = (Integer)transaction.get(BATCH_SIZE);
            int batchSize = 100;
            if (bs != null) {
                batchSize = bs;
            }
            List<SearchBuilderItem> items = this.findPendingAndLock(batchSize, connection);
            log.debug((Object)("Adding " + items.size() + " items to indexing queue: batch size was " + batchSize));
            ((IndexItemsTransaction)transaction).setItems(items);
            connection.commit();
            Object var7_9 = null;
            try {
                if (connection != null) {
                    connection.close();
                }
                break block13;
            }
            catch (Exception ex2) {
                log.debug((Object)"Exception closing connection", (Throwable)ex2);
            }
            break block13;
            {
                catch (IndexTransactionException itex) {
                    log.info((Object)("Rethrowing " + itex.getMessage()));
                    throw itex;
                }
                catch (Exception ex) {
                    log.info((Object)"Failed to Open Transaction ", (Throwable)ex);
                    try {
                        connection.rollback();
                    }
                    catch (Exception ex2) {
                        log.debug((Object)"Exception during rollback", (Throwable)ex2);
                    }
                    throw new IndexTransactionException("Failed to open transaction ", ex);
                }
            }
            catch (Throwable throwable) {
                Object var7_10 = null;
                try {
                    if (connection != null) {
                        connection.close();
                    }
                }
                catch (Exception ex2) {
                    log.debug((Object)"Exception closing connection", (Throwable)ex2);
                }
                throw throwable;
            }
        }
    }

    @Override
    public void close(IndexTransaction transaction) throws IndexTransactionException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive exception aggregation
     */
    private List<SearchBuilderItem> findPendingAndLock(int batchSize, Connection connection) throws SQLException {
        ArrayList<SearchBuilderItem> arrayList;
        ResultSet rst;
        PreparedStatement pst;
        long start = System.currentTimeMillis();
        try {
            log.debug((Object)("TXFind pending with " + connection));
            SearchBuilderItem masterItem = this.getMasterItem(connection);
            try {
                Integer masterAction = this.getMasterAction(masterItem);
                log.debug((Object)(" Master Item is " + masterItem.getName() + ":" + masterItem.getSearchaction() + ":" + masterItem.getSearchstate() + "::" + masterItem.getVersion()));
                if (SearchBuilderItem.ACTION_REFRESH.equals(masterAction)) {
                    log.debug((Object)(" Master Action is " + masterAction));
                    log.debug((Object)("  REFRESH = " + SearchBuilderItem.ACTION_REFRESH));
                    log.debug((Object)("  RELOAD = " + SearchBuilderItem.ACTION_REBUILD));
                    this.refreshIndex(connection, masterItem);
                } else if (SearchBuilderItem.ACTION_REBUILD.equals(masterAction)) {
                    this.rebuildIndex(connection, masterItem);
                } else {
                    List<SearchBuilderItem> siteMasters = this.getSiteMasterItems(connection);
                    for (SearchBuilderItem siteMaster : siteMasters) {
                        ArrayList<Object> l;
                        Object var12_10;
                        try {
                            Integer action = this.getSiteMasterAction(siteMaster);
                            if (SearchBuilderItem.ACTION_REBUILD.equals(action)) {
                                this.rebuildIndex(connection, siteMaster);
                            } else if (SearchBuilderItem.ACTION_REFRESH.equals(action)) {
                                this.refreshIndex(connection, siteMaster);
                            }
                            var12_10 = null;
                        }
                        catch (Throwable throwable) {
                            var12_10 = null;
                            if (siteMaster.getLock() == this.nodeLock) {
                                l = new ArrayList<SearchBuilderItem>();
                                l.add(siteMaster);
                                this.commitPendingAndUnLock(l, connection);
                            }
                            throw throwable;
                        }
                        if (siteMaster.getLock() != this.nodeLock) continue;
                        l = new ArrayList();
                        l.add(siteMaster);
                        this.commitPendingAndUnLock(l, connection);
                        {
                        }
                    }
                }
                Object var15_13 = null;
            }
            catch (Throwable throwable) {
                Object var15_14 = null;
                if (masterItem.getLock() == this.nodeLock) {
                    ArrayList<SearchBuilderItem> l = new ArrayList<SearchBuilderItem>();
                    l.add(masterItem);
                    this.commitPendingAndUnLock(l, connection);
                }
                throw throwable;
            }
            if (masterItem.getLock() == this.nodeLock) {
                ArrayList<SearchBuilderItem> l = new ArrayList<SearchBuilderItem>();
                l.add(masterItem);
                this.commitPendingAndUnLock(l, connection);
            }
            pst = null;
            PreparedStatement lockedPst = null;
            rst = null;
            pst = connection.prepareStatement("select  name, context,  searchaction, searchstate, version, itemscope, id  from searchbuilderitem where searchstate = ? and             itemscope = ?  order by version ");
            lockedPst = connection.prepareStatement("update searchbuilderitem set searchstate = ?  where id = ?  and  searchstate = ? ");
            pst.clearParameters();
            pst.setInt(1, SearchBuilderItem.STATE_PENDING);
            pst.setInt(2, SearchBuilderItem.ITEM);
            rst = pst.executeQuery();
            ArrayList<SearchBuilderItem> a = new ArrayList<SearchBuilderItem>();
            while (rst.next() && a.size() < batchSize) {
                SearchBuilderItemImpl sbi = new SearchBuilderItemImpl();
                this.populateSearchBuilderItem(rst, sbi);
                if (SearchBuilderItem.ACTION_UNKNOWN.equals(sbi.getSearchaction())) continue;
                lockedPst.clearParameters();
                lockedPst.setInt(1, this.nodeLock);
                lockedPst.setString(2, sbi.getId());
                lockedPst.setInt(3, SearchBuilderItem.STATE_PENDING);
                if (lockedPst.executeUpdate() == 1) {
                    sbi.setSearchstate(SearchBuilderItem.STATE_LOCKED);
                    sbi.setLock(this.nodeLock);
                    a.add((SearchBuilderItem)sbi);
                }
                connection.commit();
            }
            arrayList = a;
            Object var18_18 = null;
            try {
                if (rst != null) {
                    rst.close();
                }
            }
            catch (Exception ex) {
                log.warn((Object)"Error closing result set", (Throwable)ex);
            }
            try {
                if (pst != null) {
                    pst.close();
                }
            }
            catch (Exception ex) {
                log.warn((Object)"Error closing statement", (Throwable)ex);
            }
            Object var21_22 = null;
        }
        catch (Throwable throwable) {
            Object var21_23 = null;
            long finish = System.currentTimeMillis();
            log.debug((Object)(" findPending took " + (finish - start) + " ms"));
            throw throwable;
        }
        long finish = System.currentTimeMillis();
        log.debug((Object)(" findPending took " + (finish - start) + " ms"));
        {
            return arrayList;
            catch (Throwable throwable) {
                Object var18_19 = null;
                try {
                    if (rst != null) {
                        rst.close();
                    }
                }
                catch (Exception ex) {
                    log.warn((Object)"Error closing result set", (Throwable)ex);
                }
                try {
                    if (pst != null) {
                        pst.close();
                    }
                }
                catch (Exception ex) {
                    log.warn((Object)"Error closing statement", (Throwable)ex);
                }
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void commitPendingAndUnLock(List<SearchBuilderItem> runtimeToDo, Connection connection) throws SQLException {
        PreparedStatement unLockPst = null;
        PreparedStatement deletePst = null;
        try {
            unLockPst = connection.prepareStatement("update searchbuilderitem set searchstate = ?  where id = ?  and  searchstate = ? ");
            deletePst = connection.prepareStatement(" delete from searchbuilderitem where id = ? ");
            for (SearchBuilderItem sbi : runtimeToDo) {
                if (SearchBuilderItem.ACTION_DELETE.equals(sbi.getSearchaction())) {
                    deletePst.clearParameters();
                    deletePst.setString(1, sbi.getId());
                    if (deletePst.executeUpdate() != 1) {
                        log.warn((Object)("Failed to delete " + sbi.getName() + "  "));
                    } else {
                        log.debug((Object)("Delete " + sbi.getName() + "  "));
                    }
                    connection.commit();
                    continue;
                }
                unLockPst.clearParameters();
                unLockPst.setInt(1, SearchBuilderItem.STATE_COMPLETED);
                unLockPst.setString(2, sbi.getId());
                unLockPst.setInt(3, sbi.getLock());
                if (unLockPst.executeUpdate() != 1) {
                    log.warn((Object)("Failed to mark " + sbi + " as completed "));
                } else {
                    log.debug((Object)("Marked " + sbi.getName() + " as completed "));
                }
                sbi.setSearchstate(SearchBuilderItem.STATE_COMPLETED);
                connection.commit();
            }
            Object var8_7 = null;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            try {
                unLockPst.close();
            }
            catch (Exception ex) {
                log.warn((Object)"Error unlocking pst", (Throwable)ex);
            }
            try {
                deletePst.close();
            }
            catch (Exception ex) {
                log.warn((Object)"Error deleting pst", (Throwable)ex);
            }
            throw throwable;
        }
        try {
            unLockPst.close();
        }
        catch (Exception ex) {
            log.warn((Object)"Error unlocking pst", (Throwable)ex);
        }
        try {
            deletePst.close();
        }
        catch (Exception ex) {
            log.warn((Object)"Error deleting pst", (Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rollbackPendingAndUnLock(List<SearchBuilderItem> runtimeToDo, Connection connection) throws SQLException {
        PreparedStatement unLockPst = null;
        try {
            unLockPst = connection.prepareStatement("update searchbuilderitem set searchstate = ?  where id = ?  and  searchstate = ? ");
            for (SearchBuilderItem sbi : runtimeToDo) {
                unLockPst.clearParameters();
                if (SearchBuilderItem.STATE_FAILED.equals(sbi.getSearchstate())) {
                    sbi.setSearchstate(SearchBuilderItem.STATE_FAILED);
                    unLockPst.setInt(1, SearchBuilderItem.STATE_FAILED);
                } else {
                    sbi.setSearchstate(SearchBuilderItem.STATE_PENDING);
                    unLockPst.setInt(1, SearchBuilderItem.STATE_PENDING);
                }
                unLockPst.setString(2, sbi.getId());
                unLockPst.setInt(3, sbi.getSearchstate());
                if (unLockPst.executeUpdate() == 1) {
                    log.warn((Object)("Failed to mark " + sbi.getName() + " as pending "));
                }
                connection.commit();
            }
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            try {
                unLockPst.close();
            }
            catch (Exception ex) {
                log.warn((Object)"Error unlocking pst", (Throwable)ex);
            }
            throw throwable;
        }
        try {
            unLockPst.close();
        }
        catch (Exception ex) {
            log.warn((Object)"Error unlocking pst", (Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SearchBuilderItem getMasterItem(Connection connection) throws SQLException {
        SearchBuilderItemImpl searchBuilderItemImpl;
        log.debug((Object)("get Master Items with " + connection));
        Statement pst = null;
        PreparedStatement lockMaster = null;
        ResultSet rst = null;
        try {
            lockMaster = connection.prepareStatement("update searchbuilderitem set searchstate = ? where itemscope = ? and searchstate = ? ");
            lockMaster.clearParameters();
            lockMaster.setInt(1, this.nodeLock);
            lockMaster.setInt(2, SearchBuilderItem.ITEM_GLOBAL_MASTER);
            lockMaster.setInt(3, SearchBuilderItem.STATE_PENDING);
            lockMaster.executeUpdate();
            pst = connection.prepareStatement("select  name, context,  searchaction, searchstate, version, itemscope, id  from searchbuilderitem where itemscope = ? and searchstate = ? ");
            pst.clearParameters();
            pst.setInt(1, SearchBuilderItem.ITEM_GLOBAL_MASTER);
            pst.setInt(2, this.nodeLock);
            rst = pst.executeQuery();
            SearchBuilderItemImpl sbi = new SearchBuilderItemImpl();
            if (rst.next()) {
                this.populateSearchBuilderItem(rst, sbi);
                sbi.setLock(this.nodeLock);
                log.info((Object)("Locked Master item to this node " + sbi));
                rst.close();
                connection.commit();
            } else {
                rst.close();
                connection.rollback();
                sbi.setName("_master_control");
                sbi.setContext("global");
                sbi.setSearchaction(SearchBuilderItem.ACTION_UNKNOWN);
                sbi.setSearchstate(SearchBuilderItem.STATE_UNKNOWN);
                sbi.setItemscope(SearchBuilderItem.ITEM_GLOBAL_MASTER);
            }
            searchBuilderItemImpl = sbi;
            Object var8_7 = null;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            try {
                if (rst != null) {
                    rst.close();
                }
            }
            catch (Exception ex) {
                log.warn((Object)"Error closing rst", (Throwable)ex);
            }
            try {
                if (pst != null) {
                    pst.close();
                }
            }
            catch (Exception ex) {
                log.warn((Object)"Error closing pst", (Throwable)ex);
            }
            try {
                lockMaster.close();
            }
            catch (Exception ex) {
                log.warn((Object)"Error closing lockMaster", (Throwable)ex);
            }
            throw throwable;
        }
        try {
            if (rst != null) {
                rst.close();
            }
        }
        catch (Exception ex) {
            log.warn((Object)"Error closing rst", (Throwable)ex);
        }
        try {
            if (pst != null) {
                pst.close();
            }
        }
        catch (Exception ex) {
            log.warn((Object)"Error closing pst", (Throwable)ex);
        }
        try {
            lockMaster.close();
        }
        catch (Exception ex) {
            log.warn((Object)"Error closing lockMaster", (Throwable)ex);
        }
        return searchBuilderItemImpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<SearchBuilderItem> getSiteMasterItems(Connection connection) throws SQLException {
        ArrayList<SearchBuilderItem> arrayList;
        Statement pst = null;
        PreparedStatement lockMaster = null;
        ResultSet rst = null;
        try {
            lockMaster = connection.prepareStatement("update searchbuilderitem set searchstate = ? where itemscope = ? and searchstate = ? ");
            lockMaster.clearParameters();
            lockMaster.setInt(1, this.nodeLock);
            lockMaster.setInt(2, SearchBuilderItem.ITEM_SITE_MASTER);
            lockMaster.setInt(3, SearchBuilderItem.STATE_PENDING);
            lockMaster.executeUpdate();
            pst = connection.prepareStatement("select  name, context,  searchaction, searchstate, version, itemscope, id  from searchbuilderitem where itemscope =   ? and searchstate = ?  ");
            pst.clearParameters();
            pst.setInt(1, SearchBuilderItem.ITEM_SITE_MASTER);
            pst.setInt(2, this.nodeLock);
            rst = pst.executeQuery();
            ArrayList<SearchBuilderItem> a = new ArrayList<SearchBuilderItem>();
            while (rst.next()) {
                SearchBuilderItemImpl sbi = new SearchBuilderItemImpl();
                this.populateSearchBuilderItem(rst, sbi);
                a.add((SearchBuilderItem)sbi);
            }
            if (a.size() > 0) {
                connection.commit();
            } else {
                connection.rollback();
            }
            arrayList = a;
            Object var8_7 = null;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            try {
                rst.close();
            }
            catch (Exception ex) {
                log.warn((Object)"Error closing rst", (Throwable)ex);
            }
            try {
                pst.close();
            }
            catch (Exception ex) {
                log.warn((Object)"Error closing pst", (Throwable)ex);
            }
            try {
                lockMaster.close();
            }
            catch (Exception ex) {
                log.warn((Object)"Error closing lockMaster", (Throwable)ex);
            }
            throw throwable;
        }
        try {
            rst.close();
        }
        catch (Exception ex) {
            log.warn((Object)"Error closing rst", (Throwable)ex);
        }
        try {
            pst.close();
        }
        catch (Exception ex) {
            log.warn((Object)"Error closing pst", (Throwable)ex);
        }
        try {
            lockMaster.close();
        }
        catch (Exception ex) {
            log.warn((Object)"Error closing lockMaster", (Throwable)ex);
        }
        return arrayList;
    }

    private Integer getMasterAction(SearchBuilderItem master) {
        if (master.getName().equals("_master_control_global") && master.getLock() == this.nodeLock) {
            return master.getSearchaction();
        }
        return SearchBuilderItem.STATE_UNKNOWN;
    }

    private Integer getSiteMasterAction(SearchBuilderItem siteMaster) {
        if (siteMaster.getName().startsWith("_master_control") && !"global".equals(siteMaster.getContext()) && siteMaster.getLock() == this.nodeLock) {
            return siteMaster.getSearchaction();
        }
        return SearchBuilderItem.ACTION_UNKNOWN;
    }

    private void populateSearchBuilderItem(ResultSet rst, SearchBuilderItemImpl sbi) throws SQLException {
        sbi.setName(rst.getString(1));
        sbi.setContext(rst.getString(2));
        sbi.setSearchaction(Integer.valueOf(rst.getInt(3)));
        sbi.setSearchstate(Integer.valueOf(rst.getInt(4)));
        sbi.setVersion((java.util.Date)rst.getDate(5));
        sbi.setItemscope(Integer.valueOf(rst.getInt(6)));
        sbi.setId(rst.getString(7));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rebuildIndex(Connection connection, SearchBuilderItem controlItem) throws SQLException {
        log.debug((Object)"DELETE ALL RECORDS ==========================================================");
        Statement stm = null;
        try {
            stm = connection.createStatement();
            if ("global".equals(controlItem.getContext())) {
                stm.execute("delete from searchbuilderitem where itemscope = " + SearchBuilderItem.ITEM + " or itemscope = " + SearchBuilderItem.ITEM_SITE_MASTER);
            } else {
                stm.execute("delete from searchbuilderitem where context = '" + controlItem.getContext() + "' and name <> '" + controlItem.getName() + "' ");
            }
            log.debug((Object)"DONE DELETE ALL RECORDS ===========================================================");
            connection.commit();
            log.debug((Object)"ADD ALL RECORDS ===========================================================");
            List<String> contextList = this.getAllContentexts(controlItem);
            List contentProducers = this.searchIndexBuilder.getContentProducers();
            long sleepTime = 60000L;
            long sleepInterval = 1000L;
            long count = 0L;
            long totalCount = 0L;
            Iterator<String> c = contextList.iterator();
            while (c.hasNext()) {
                Object obj = this.threadLocalManager.get("SakaiSecurity.advisor.stack");
                this.threadLocalManager.clear();
                this.threadLocalManager.set("SakaiSecurity.advisor.stack", obj);
                if (count == sleepInterval) {
                    log.info((Object)"sleeping to stop GC craziness");
                    log.info((Object)("done " + totalCount + "/" + contextList.size()));
                    try {
                        Thread.sleep(sleepTime);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    count = 0L;
                    ++totalCount;
                } else {
                    ++count;
                    ++totalCount;
                }
                String siteContext = c.next();
                log.info((Object)("Rebuild for " + siteContext + " (" + totalCount + "/" + contextList.size() + ")"));
                for (EntityContentProducer ecp : contentProducers) {
                    Iterator contentIterator = null;
                    try {
                        contentIterator = ecp.getSiteContentIterator(siteContext);
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Using ECP " + ecp));
                        }
                        int added = 0;
                        while (contentIterator.hasNext()) {
                            String resourceName = (String)contentIterator.next();
                            if (log.isDebugEnabled()) {
                                log.debug((Object)("Checking " + resourceName));
                            }
                            if (resourceName == null || resourceName.length() > 255) {
                                log.warn((Object)("Entity Reference Longer than 255 characters, ignored: Reference=" + resourceName));
                                continue;
                            }
                            SearchBuilderItemImpl sbi = new SearchBuilderItemImpl();
                            sbi.setName(resourceName);
                            sbi.setSearchaction(SearchBuilderItem.ACTION_ADD);
                            sbi.setSearchstate(SearchBuilderItem.STATE_PENDING);
                            sbi.setId(UUID.randomUUID().toString());
                            sbi.setVersion((java.util.Date)new Date(System.currentTimeMillis()));
                            sbi.setItemscope(SearchBuilderItem.ITEM);
                            String context = null;
                            try {
                                context = ecp.getSiteId(resourceName);
                            }
                            catch (Exception ex) {
                                log.debug((Object)("No context for resource " + resourceName + " defaulting to none"));
                            }
                            if (context == null || context.length() == 0) {
                                context = "none";
                            }
                            sbi.setContext(context);
                            try {
                                this.updateOrSave(connection, (SearchBuilderItem)sbi);
                            }
                            catch (SQLException sqlex) {
                                log.error((Object)("Failed to update " + sqlex.getMessage()));
                            }
                            connection.commit();
                        }
                        if (!log.isDebugEnabled()) continue;
                        log.debug((Object)(" Added " + added));
                    }
                    catch (Exception ex) {
                        log.warn((Object)("Failed to index site " + siteContext + " site has not been indexed"), (Throwable)ex);
                    }
                }
            }
            log.debug((Object)"DONE ADD ALL RECORDS ===========================================================");
            connection.commit();
            Object var26_25 = null;
        }
        catch (Throwable throwable) {
            Object var26_26 = null;
            try {
                stm.close();
            }
            catch (Exception ex) {
                log.warn((Object)"Error closing stm", (Throwable)ex);
            }
            throw throwable;
        }
        try {
            stm.close();
        }
        catch (Exception ex) {
            log.warn((Object)"Error closing stm", (Throwable)ex);
        }
    }

    private List<String> getAllContentexts(SearchBuilderItem controlItem) {
        ArrayList<String> contextList = new ArrayList<String>();
        if ("global".equals(controlItem.getContext())) {
            int increment;
            int first = 1;
            int last = increment = 1000;
            boolean doAnother = true;
            while (doAnother) {
                List sites = this.siteService.getSites(SiteService.SelectionType.ANY, null, null, null, SiteService.SortType.NONE, new PagingPosition(first, last));
                for (Site s : sites) {
                    if (this.siteService.isSpecialSite(s.getId()) && !this.siteService.isUserSite(s.getId())) continue;
                    if (this.searchIndexBuilder.isOnlyIndexSearchToolSites()) {
                        ToolConfiguration t = s.getToolForCommonId("sakai.search");
                        if (t == null) continue;
                        contextList.add(s.getId());
                        continue;
                    }
                    contextList.add(s.getId());
                }
                if (sites.size() < increment) {
                    doAnother = false;
                    continue;
                }
                first = last + 1;
                last += increment;
            }
        } else {
            contextList.add(controlItem.getContext());
        }
        return contextList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshIndex(Connection connection, SearchBuilderItem controlItem) throws SQLException {
        log.debug((Object)"UPDATE ALL RECORDS ==========================================================");
        Statement stm = null;
        try {
            stm = connection.createStatement();
            if ("global".equals(controlItem.getContext())) {
                stm.execute("update searchbuilderitem set searchstate = " + SearchBuilderItem.STATE_PENDING + " where itemscope = " + SearchBuilderItem.ITEM);
            } else {
                stm.execute("update searchbuilderitem set searchstate = " + SearchBuilderItem.STATE_PENDING + " where itemscope = " + SearchBuilderItem.ITEM_SITE_MASTER + " and context = '" + controlItem.getContext() + "' and name <> '" + controlItem.getName() + "'");
            }
            connection.commit();
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            try {
                stm.close();
            }
            catch (Exception ex) {
                log.warn((Object)"Error closing stm", (Throwable)ex);
            }
            throw throwable;
        }
        try {
            stm.close();
        }
        catch (Exception ex) {
            log.warn((Object)"Error closing stm", (Throwable)ex);
        }
    }

    /*
     * Loose catch block
     */
    private void updateOrSave(Connection connection, SearchBuilderItem sbi) throws SQLException {
        block11: {
            PreparedStatement pst = null;
            try {
                this.save(connection, sbi);
            }
            catch (SQLException sqlex) {
                pst = connection.prepareStatement("update searchbuilderitem set  name = ?, context = ?,  searchaction = ?, searchstate = ?, version = ?, itemscope = ? where id = ? ");
                this.populateStatement(pst, sbi);
                pst.executeUpdate();
            }
            Object var6_6 = null;
            try {
                if (pst != null) {
                    pst.close();
                }
                break block11;
            }
            catch (Exception ex) {
                log.warn((Object)"Error closing pst", (Throwable)ex);
            }
            break block11;
            {
                catch (SQLException ex) {
                    log.warn((Object)"Failed ", (Throwable)ex);
                    throw ex;
                }
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                try {
                    if (pst != null) {
                        pst.close();
                    }
                }
                catch (Exception ex) {
                    log.warn((Object)"Error closing pst", (Throwable)ex);
                }
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void save(Connection connection, SearchBuilderItem sbi) throws SQLException {
        PreparedStatement pst = null;
        try {
            pst = connection.prepareStatement(" insert into searchbuilderitem (  name, context,  searchaction, searchstate, version, itemscope, id  ) values (  ?, ?, ?,  ?, ?, ?, ?  ) ");
            pst.clearParameters();
            this.populateStatement(pst, sbi);
            pst.executeUpdate();
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            try {
                pst.close();
            }
            catch (Exception ex) {
                log.warn((Object)"Error closing pst", (Throwable)ex);
            }
            throw throwable;
        }
        try {
            pst.close();
        }
        catch (Exception ex) {
            log.warn((Object)"Error closing pst", (Throwable)ex);
        }
    }

    private int populateStatement(PreparedStatement pst, SearchBuilderItem sbi) throws SQLException {
        pst.setString(1, sbi.getName());
        pst.setString(2, sbi.getContext());
        pst.setInt(3, sbi.getSearchaction());
        pst.setInt(4, sbi.getSearchstate());
        pst.setDate(5, new Date(sbi.getVersion().getTime()));
        pst.setInt(6, sbi.getItemscope());
        pst.setString(7, sbi.getId());
        return 7;
    }

    public SearchIndexBuilder getSearchIndexBuilder() {
        return this.searchIndexBuilder;
    }

    public void setSearchIndexBuilder(SearchIndexBuilder searchIndexBuilder) {
        this.searchIndexBuilder = searchIndexBuilder;
    }

    public DataSource getDatasource() {
        return this.datasource;
    }

    public void setDatasource(DataSource datasource) {
        this.datasource = datasource;
    }

    public void setSiteService(SiteService siteService) {
        this.siteService = siteService;
    }

    public TransactionSequence getSequence() {
        return this.sequence;
    }

    public void setSequence(TransactionSequence sequence) {
        this.sequence = sequence;
    }

    public void setAutoDdl(String value) {
        this.autoDdl = Boolean.valueOf(value);
    }

    public String getAutoDdl() {
        return String.valueOf(this.autoDdl);
    }
}

