/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.search.journal.impl;

import java.util.HashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sakaiproject.search.journal.api.IndexMergeTransaction;
import org.sakaiproject.search.journal.api.JournalErrorException;
import org.sakaiproject.search.journal.api.JournalExhausetedException;
import org.sakaiproject.search.journal.api.JournaledObject;
import org.sakaiproject.search.journal.api.ManagementOperation;
import org.sakaiproject.search.journal.impl.MergeUpdateManager;
import org.sakaiproject.search.optimize.api.NoOptimizationRequiredException;
import org.sakaiproject.search.optimize.impl.IndexOptimizeTransactionImpl;
import org.sakaiproject.search.optimize.impl.OptimizeIndexManager;
import org.sakaiproject.search.transaction.api.IndexTransaction;
import org.sakaiproject.search.transaction.api.IndexTransactionException;
import org.sakaiproject.search.transaction.impl.IndexTransactionImpl;

public class MergeUpdateOperation
implements ManagementOperation {
    private static final Log log = LogFactory.getLog(MergeUpdateOperation.class);
    private JournaledObject journaledObject;
    private MergeUpdateManager mergeUpdateManager;
    private OptimizeIndexManager optimizeUpdateManager;

    public void init() {
    }

    public void destroy() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runOnce() {
        log.debug((Object)("Last Journaled savePoint is " + this.journaledObject.getLastJournalEntry()));
        int count = 0;
        if (this.journaledObject.aquireUpdateLock()) {
            log.debug((Object)("Now Locked Journaled savePoint is " + this.journaledObject.getLastJournalEntry()));
            try {
                StringBuilder sb = new StringBuilder();
                while (true) {
                    try {
                        IndexTransaction mergeUpdateTransaction = null;
                        try {
                            long start = System.currentTimeMillis();
                            HashMap<String, Object> m = new HashMap<String, Object>();
                            mergeUpdateTransaction = (IndexMergeTransaction)this.mergeUpdateManager.openTransaction(m);
                            mergeUpdateTransaction.prepare();
                            mergeUpdateTransaction.commit();
                            long timeTaken = System.currentTimeMillis() - start;
                            sb.append("\n\tMerged Journal ").append(mergeUpdateTransaction.getJournalEntry()).append(" from the redolog in " + timeTaken + " ms");
                            if ((++count <= 10 || timeTaken <= 500L) && count <= 50) continue;
                            count = 0;
                            IndexTransactionImpl optimizeUpdateTransaction = null;
                            try {
                                start = System.currentTimeMillis();
                                m = new HashMap();
                                optimizeUpdateTransaction = (IndexOptimizeTransactionImpl)this.optimizeUpdateManager.openTransaction(m);
                                optimizeUpdateTransaction.prepare();
                                optimizeUpdateTransaction.commit();
                                timeTaken = System.currentTimeMillis() - start;
                                sb.append("Optimize complete in  ").append(timeTaken).append("ms");
                            }
                            catch (JournalErrorException jex) {
                                if (optimizeUpdateTransaction != null) {
                                    log.warn((Object)"Failed to complete Optimize ", (Throwable)jex);
                                } else {
                                    log.warn((Object)"Failed to start merge operation ", (Throwable)jex);
                                }
                                try {
                                    optimizeUpdateTransaction.rollback();
                                }
                                catch (Exception ex) {
                                    log.warn((Object)"Failed to rollback transaction ", (Throwable)ex);
                                }
                            }
                            catch (NoOptimizationRequiredException nop) {
                                log.debug((Object)("No Merge Performed " + nop.getMessage()));
                            }
                            catch (IndexTransactionException iupex) {
                                log.warn((Object)"Failed to complete optimize ", (Throwable)iupex);
                                try {
                                    optimizeUpdateTransaction.rollback();
                                }
                                catch (Exception ex) {
                                    log.warn((Object)"Failed to rollback transaction ", (Throwable)ex);
                                }
                            }
                            finally {
                                try {
                                    optimizeUpdateTransaction.close();
                                }
                                catch (Exception ex) {}
                            }
                        }
                        catch (JournalErrorException jex) {
                            if (mergeUpdateTransaction != null) {
                                log.warn((Object)("Failed to complete merge of " + mergeUpdateTransaction.getJournalEntry() + " "), (Throwable)jex);
                                try {
                                    mergeUpdateTransaction.rollback();
                                }
                                catch (Exception ex) {
                                    log.warn((Object)"Failed to rollback transaction ", (Throwable)ex);
                                }
                                break;
                            }
                            log.warn((Object)"Failed to start merge operation ", (Throwable)jex);
                            break;
                        }
                        catch (IndexTransactionException iupex) {
                            if (mergeUpdateTransaction != null) {
                                log.warn((Object)("Failed to complete merge of " + mergeUpdateTransaction.getJournalEntry() + ""), (Throwable)iupex);
                                try {
                                    mergeUpdateTransaction.rollback();
                                }
                                catch (Exception ex) {
                                    log.warn((Object)"Failed to rollback transaction ", (Throwable)ex);
                                }
                                continue;
                            }
                            log.warn((Object)"Failed to start merge operation ", (Throwable)iupex);
                        }
                        finally {
                            try {
                                if (mergeUpdateTransaction == null) continue;
                                mergeUpdateTransaction.close();
                            }
                            catch (Exception ex) {
                                log.debug((Object)ex);
                            }
                        }
                    }
                    catch (JournalExhausetedException ex) {
                        if (!log.isDebugEnabled()) break;
                        log.debug((Object)"No More Journal Entries ");
                        break;
                    }
                }
                log.info((Object)("Local Merge Operation " + sb.toString() + "\n"));
            }
            finally {
                this.journaledObject.releaseUpdateLock();
            }
        }
        log.warn((Object)"No Lock, index update abandoned");
        this.journaledObject.debugLock();
    }

    public JournaledObject getJournaledObject() {
        return this.journaledObject;
    }

    public void setJournaledObject(JournaledObject journaledObject) {
        this.journaledObject = journaledObject;
    }

    public MergeUpdateManager getMergeUpdateManager() {
        return this.mergeUpdateManager;
    }

    public void setMergeUpdateManager(MergeUpdateManager mergeUpdateManager) {
        this.mergeUpdateManager = mergeUpdateManager;
    }

    public OptimizeIndexManager getOptimizeUpdateManager() {
        return this.optimizeUpdateManager;
    }

    public void setOptimizeUpdateManager(OptimizeIndexManager optimizeUpdateManager) {
        this.optimizeUpdateManager = optimizeUpdateManager;
    }
}

