/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.search.journal.impl;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sakaiproject.search.journal.api.JournalStorage;
import org.sakaiproject.search.journal.api.JournalStorageState;
import org.sakaiproject.search.journal.impl.JournalSettings;
import org.sakaiproject.search.transaction.api.IndexTransaction;
import org.sakaiproject.search.transaction.api.IndexTransactionException;
import org.sakaiproject.search.util.FileUtils;

public class SharedFilesystemJournalStorage
implements JournalStorage {
    private static final Log log = LogFactory.getLog(SharedFilesystemJournalStorage.class);
    private JournalSettings journalSettings;

    public void init() {
    }

    public void destroy() {
    }

    private File[] getTransactionFile(long transactionId) {
        File f;
        File testFile = f = new File(this.journalSettings.getJournalLocation(), transactionId + ".zip");
        for (int i = 0; testFile.exists() && i < 1000; ++i) {
            f = testFile;
            testFile = new File(this.journalSettings.getJournalLocation(), transactionId + "-" + i + ".zip");
        }
        File[] result = new File[]{f, testFile};
        if (log.isDebugEnabled()) {
            log.debug((Object)("F0:" + result[0] + ":" + result[0].exists() + " F1:" + result[1] + ":" + result[1].exists()));
        }
        return result;
    }

    public JournalStorageState prepareSave(String location, long transactionId) throws IOException {
        File indexLocation = new File(location);
        log.info((Object)("++++++ Saving " + indexLocation + " to shared"));
        File tmpZip = new File(this.journalSettings.getJournalLocation(), transactionId + ".zip." + System.currentTimeMillis());
        if (!tmpZip.getParentFile().exists() && !tmpZip.getParentFile().mkdirs()) {
            log.warn((Object)("Couldn't create directory " + tmpZip.getParentFile().getPath()));
        }
        String basePath = indexLocation.getPath();
        String replacePath = String.valueOf(transactionId);
        FileOutputStream zout = new FileOutputStream(tmpZip);
        FileUtils.pack((File)indexLocation, (String)basePath, (String)replacePath, (OutputStream)zout, (boolean)this.journalSettings.getCompressShared());
        zout.close();
        File[] journalZip = this.getTransactionFile(transactionId);
        return new JournalStorageStateImpl(tmpZip, journalZip[1]);
    }

    public void commitSave(JournalStorageState jss) throws IOException {
        File tmpZip = ((JournalStorageStateImpl)jss).tmpZip;
        File journalZip = ((JournalStorageStateImpl)jss).journalZip;
        if (!tmpZip.renameTo(journalZip)) {
            log.warn((Object)("couldn't rename " + tmpZip.getPath() + " to " + journalZip.getPath()));
        }
    }

    public void rollbackSave(JournalStorageState jss) {
        if (jss != null) {
            File journalZip = ((JournalStorageStateImpl)jss).journalZip;
            File tmpZip = ((JournalStorageStateImpl)jss).tmpZip;
            if (tmpZip != null && tmpZip.exists() && !tmpZip.delete()) {
                log.warn((Object)("counldn't delete " + tmpZip.getPath()));
            }
            if (journalZip != null && journalZip.exists() && !journalZip.delete()) {
                log.warn((Object)("counldn't delete " + journalZip.getPath()));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void retrieveSavePoint(long savePoint, String workingSpace) throws IOException {
        File[] f;
        File ws = new File(workingSpace);
        if (!ws.exists() && !ws.mkdirs()) {
            log.warn((Object)("Couldn't create directory " + ws.getPath()));
        }
        if (!(f = this.getTransactionFile(savePoint))[0].exists()) {
            log.error((Object)("======================================= Lost Shared Segment ================= \n\t" + f[0] + "\n" + "\tThe above file does not exist, this should not happen and should be investigated "));
        } else {
            FileInputStream source = new FileInputStream(f[0]);
            try {
                FileUtils.unpack((InputStream)source, (File)ws);
            }
            finally {
                source.close();
            }
        }
    }

    public void close(IndexTransaction transaction) throws IndexTransactionException {
    }

    public File getLocalJournalLocation(long savePoint, String workingSpace) {
        return new File(workingSpace, String.valueOf(savePoint));
    }

    public void removeJournal(long savePoint) throws IOException {
        File[] f = this.getTransactionFile(savePoint);
        while (f[0].exists()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Removing " + f[0]));
            }
            FileUtils.deleteAll((File)f[0]);
            f = this.getTransactionFile(savePoint);
        }
    }

    public JournalSettings getJournalSettings() {
        return this.journalSettings;
    }

    public void setJournalSettings(JournalSettings journalSettings) {
        this.journalSettings = journalSettings;
    }

    private static class JournalStorageStateImpl
    implements JournalStorageState {
        protected File tmpZip;
        protected File journalZip;

        public JournalStorageStateImpl(File tmpZip, File journalZip) {
            this.tmpZip = tmpZip;
            this.journalZip = journalZip;
        }
    }
}

