/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.search.optimize.impl;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.lucene.index.IndexWriter;
import org.sakaiproject.search.journal.impl.JournalSettings;
import org.sakaiproject.search.optimize.api.IndexOptimizeTransaction;
import org.sakaiproject.search.optimize.impl.OptimizeIndexManager;
import org.sakaiproject.search.transaction.api.IndexTransaction;
import org.sakaiproject.search.transaction.api.IndexTransactionException;
import org.sakaiproject.search.transaction.impl.IndexTransactionImpl;
import org.sakaiproject.search.transaction.impl.TransactionManagerImpl;
import org.sakaiproject.search.util.FileUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IndexOptimizeTransactionImpl
extends IndexTransactionImpl
implements IndexOptimizeTransaction {
    private static final Log log = LogFactory.getLog(IndexOptimizeTransactionImpl.class);
    private IndexWriter indexWriter;
    private File tempIndex;
    private IndexWriter permanentIndexWriter;
    private File[] optimizableSegments;
    private JournalSettings journalSettings;

    public IndexOptimizeTransactionImpl(TransactionManagerImpl manager, JournalSettings journalSettings, Map<String, Object> m) throws IndexTransactionException {
        super(manager, m);
        this.journalSettings = journalSettings;
    }

    @Override
    protected void doAfterRollback() throws IndexTransactionException {
        try {
            if (this.indexWriter != null) {
                this.indexWriter.close();
            }
            this.indexWriter = null;
            if (this.tempIndex != null) {
                FileUtils.deleteAll((File)this.tempIndex);
            }
        }
        catch (Exception ex) {
            throw new IndexTransactionException("Failed to complete rollback ", ex);
        }
        super.doAfterRollback();
        this.tempIndex = null;
        this.indexWriter = null;
    }

    @Override
    protected void doAfterCommit() throws IndexTransactionException {
        try {
            this.indexWriter.close();
            this.indexWriter = null;
            FileUtils.deleteAll((File)this.tempIndex);
        }
        catch (Exception e) {
            throw new IndexTransactionException("Failed to commit ", e);
        }
        super.doAfterCommit();
        this.tempIndex = null;
    }

    public IndexWriter getIndexWriter() throws IndexTransactionException {
        if (this.transactionState == 3 || this.transactionState == 4) {
            throw new IndexTransactionException("Transaction is not active: State is " + IndexTransaction.TRANSACTION_STATUS[this.transactionState]);
        }
        if (this.indexWriter == null) {
            if (!IndexTransaction.TRANSACTION_ACTIVE[this.transactionState]) {
                throw new IndexTransactionException("Transaction is not active: State is " + IndexTransaction.TRANSACTION_STATUS[this.transactionState]);
            }
            try {
                this.tempIndex = ((OptimizeIndexManager)this.manager).getTemporarySegment(this.transactionId);
                this.indexWriter = new IndexWriter(this.tempIndex, ((OptimizeIndexManager)this.manager).getAnalyzer(), true);
                this.indexWriter.setUseCompoundFile(true);
                this.indexWriter.setMaxMergeDocs(this.journalSettings.getLocalMaxMergeDocs());
                this.indexWriter.setMaxBufferedDocs(this.journalSettings.getLocalMaxBufferedDocs());
                this.indexWriter.setMergeFactor(this.journalSettings.getLocalMaxMergeFactor());
            }
            catch (IOException ex) {
                throw new IndexTransactionException("Cant Create Transaction Index working space ", ex);
            }
        }
        return this.indexWriter;
    }

    @Override
    public File[] getOptimizableSegments() {
        return this.optimizableSegments;
    }

    @Override
    public IndexWriter getPermanentIndexWriter() {
        return this.permanentIndexWriter;
    }

    @Override
    public IndexWriter getTemporaryIndexWriter() throws IndexTransactionException {
        return this.getIndexWriter();
    }

    @Override
    public void setOptimizableSegments(File[] optimzableSegments) {
        this.optimizableSegments = optimzableSegments;
    }

    @Override
    public void setPermanentIndexWriter(IndexWriter pw) {
        this.permanentIndexWriter = pw;
    }
}

