/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.search.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sakaiproject.search.api.SearchService;

public class DigestStorageUtil {
    private static final Log log = LogFactory.getLog(DigestStorageUtil.class);
    private SearchService searchService;

    public DigestStorageUtil(SearchService searchService) {
        this.searchService = searchService;
        if (searchService == null) {
            throw new IllegalArgumentException("SearchService can't be null");
        }
    }

    private String getHashOfFile(String ref) {
        return DigestUtils.md5Hex((String)ref);
    }

    public String getPath(String reference) {
        log.debug((Object)("getPath(" + reference));
        String ret = "";
        reference = this.getHashOfFile(reference);
        ret = reference.substring(0, 1) + "/" + reference.substring(0, 3) + "/" + reference;
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StringBuilder getFileContents(String ref, String digestCount) {
        StringBuilder sb = new StringBuilder();
        BufferedReader input = null;
        try {
            String storePath = this.searchService.getDigestStoragePath();
            if (storePath == null) {
                StringBuilder stringBuilder = null;
                return stringBuilder;
            }
            String digestFilePath = storePath + this.getPath(ref) + "/digest." + digestCount;
            log.debug((Object)("opening: " + digestFilePath));
            input = new BufferedReader(new FileReader(digestFilePath));
            String line = null;
            while ((line = input.readLine()) != null) {
                sb.append(line);
                sb.append(System.getProperty("line.separator"));
            }
        }
        catch (FileNotFoundException e) {
            log.warn((Object)("Unable to open digest for item: reference with count " + digestCount + " fileNotFound"));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (input != null) {
                try {
                    input.close();
                }
                catch (IOException iox) {
                    log.debug((Object)"exeption in final block!");
                }
            }
        }
        return sb;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveContentToStore(String ref, String content, int version) {
        if (content == null) {
            return;
        }
        String storePath = this.searchService.getDigestStoragePath();
        if (storePath != null) {
            FileOutputStream fileOutput = null;
            try {
                if (!new File(storePath).exists() && !new File(storePath).mkdirs()) {
                    log.error((Object)("error creating digestStorePath: " + storePath));
                    return;
                }
                String exPath = this.getPath(ref);
                String filePath = storePath + exPath;
                if (!new File(filePath).exists()) {
                    log.debug((Object)("creating folder" + filePath));
                    if (!new File(filePath).mkdirs()) {
                        log.error((Object)("error creating  digest file path " + filePath));
                        return;
                    }
                }
                log.debug((Object)("filePath: " + filePath));
                fileOutput = new FileOutputStream(filePath + "/digest." + version);
                fileOutput.write(content.getBytes("UTF8"));
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                try {
                    if (fileOutput != null) {
                        fileOutput.close();
                    }
                }
                catch (IOException e) {
                    log.error((Object)("Exception in finally block: " + e));
                }
            }
        }
    }

    public int getDocCount(String ref) {
        String storePath = this.searchService.getDigestStoragePath();
        int count = 0;
        if (storePath != null) {
            String exPath = this.getPath(ref);
            String filePath = storePath + exPath;
            if (new File(filePath).exists()) {
                File dir = new File(filePath);
                String[] children = dir.list();
                if (children == null) {
                    return 0;
                }
                for (int i = 0; i < children.length; ++i) {
                    Integer countIn;
                    String fileName = children[i];
                    if (!fileName.contains(".") || (countIn = this.getCountFromFileName(fileName)) <= count) continue;
                    count = countIn;
                }
                return count;
            }
        }
        return 0;
    }

    private Integer getCountFromFileName(String fileName) {
        if (!fileName.contains(".")) {
            return null;
        }
        Integer countIn = null;
        String countStr = fileName.substring(fileName.lastIndexOf(46) + 1, fileName.length());
        log.debug((Object)("count string is: " + countStr));
        try {
            countIn = Integer.valueOf(countStr);
        }
        catch (NumberFormatException nfe) {
            log.warn((Object)("filename:  " + fileName + "has nonNumeric exension"));
        }
        return countIn;
    }

    public void cleanOldDigests(String ref) {
        String storePath = this.searchService.getDigestStoragePath();
        int docCount = this.getDocCount(ref);
        GregorianCalendar cal = new GregorianCalendar();
        ((Calendar)cal).add(5, -1);
        Date yesterDay = cal.getTime();
        if (storePath != null) {
            String exPath = this.getPath(ref);
            String filePath = storePath + exPath;
            if (new File(filePath).exists()) {
                File dir = new File(filePath);
                String[] children = dir.list();
                if (children == null) {
                    return;
                }
                for (int i = 0; i < children.length; ++i) {
                    Date lastMod;
                    File file;
                    String fileName = children[i];
                    if (docCount <= this.getCountFromFileName(fileName) || !(file = new File(filePath + "/" + fileName)).exists() || !(lastMod = new Date(file.lastModified())).before(yesterDay) || file.delete()) continue;
                    log.warn((Object)("cleanOldDigests: unable to delete digest: " + filePath + "/" + fileName));
                }
            }
        }
    }

    public void deleteAllDigests(String reference) {
        String storePath = this.searchService.getDigestStoragePath();
        if (storePath != null) {
            String exPath = this.getPath(reference);
            String filePath = storePath + exPath;
            File dir = new File(filePath);
            if (dir.exists()) {
                String[] children = dir.list();
                if (children != null) {
                    for (int i = 0; i < children.length; ++i) {
                        String fileName = children[i];
                        File file = new File(filePath + "/" + fileName);
                        if (file.delete()) continue;
                        log.warn((Object)("unable to delete file: " + filePath + "/" + fileName));
                    }
                }
                log.debug((Object)("about to delete: " + filePath));
                if (!dir.delete()) {
                    log.warn((Object)("unable to delete: " + filePath));
                }
            }
        }
    }
}

