/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.search.component.adapter.contenthosting;

import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sakaiproject.content.api.ContentResource;
import org.sakaiproject.entity.api.ResourceProperties;
import org.sakaiproject.search.api.SearchUtils;
import org.sakaiproject.search.component.adapter.contenthosting.ContentDigester;

public class DefaultContentDigester
implements ContentDigester {
    private static final Log log = LogFactory.getLog(DefaultContentDigester.class);
    private int maxDigestSize = 0x1400000;
    private Properties binaryTypes = null;

    public void init() {
        try {
            this.binaryTypes = new Properties();
            InputStream pi = this.getClass().getResourceAsStream("/org/sakaiproject/search/component/bundle/binarytypes.config");
            this.binaryTypes.load(pi);
            pi.close();
        }
        catch (Exception e) {
            log.error((Object)"Cant find binary types file /org/sakaiproject/search/component/bundle/binarytypes.config in class path", (Throwable)e);
            System.exit(-1);
        }
    }

    public String getContent(ContentResource contentResource) {
        try {
            ResourceProperties rp = contentResource.getProperties();
            StringBuilder sb = new StringBuilder();
            sb.append(rp.getProperty("DAV:displayname")).append(" ");
            sb.append(rp.getProperty("CHEF:description")).append(" ");
            if (!this.isBinary(contentResource) && contentResource.getContentLength() < (long)this.maxDigestSize) {
                try {
                    SearchUtils.appendCleanString((String)new String(contentResource.getContent(), "UTF-8"), (StringBuilder)sb);
                }
                catch (Exception e) {
                    log.debug((Object)e);
                }
            }
            return sb.toString();
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to get content", e);
        }
    }

    public boolean isBinary(ContentResource contentResource) {
        String mimeType = contentResource.getContentType();
        return "true".equals(this.binaryTypes.get(mimeType));
    }

    public boolean accept(String mimeType) {
        return true;
    }

    public Reader getContentReader(ContentResource contentResource) {
        return new StringReader(this.getContent(contentResource));
    }

    public int getMaxDigestSize() {
        return this.maxDigestSize;
    }

    public void setMaxDigestSize(int maxDigestSize) {
        this.maxDigestSize = maxDigestSize;
    }
}

