/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.search.component.service.impl;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.highlight.Encoder;
import org.apache.lucene.search.highlight.Formatter;
import org.apache.lucene.search.highlight.Highlighter;
import org.apache.lucene.search.highlight.InvalidTokenOffsetsException;
import org.apache.lucene.search.highlight.QueryScorer;
import org.apache.lucene.search.highlight.Scorer;
import org.apache.lucene.search.highlight.SimpleHTMLEncoder;
import org.apache.lucene.search.highlight.SimpleHTMLFormatter;
import org.sakaiproject.search.api.EntityContentProducer;
import org.sakaiproject.search.api.PortalUrlEnabledProducer;
import org.sakaiproject.search.api.SearchIndexBuilder;
import org.sakaiproject.search.api.SearchResult;
import org.sakaiproject.search.api.SearchService;
import org.sakaiproject.search.api.TermFrequency;
import org.sakaiproject.search.component.Messages;
import org.xml.sax.Attributes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SearchResultResponseImpl
implements SearchResult {
    private static Log log = LogFactory.getLog(SearchResultResponseImpl.class);
    String[] fieldNames = null;
    private Query query = null;
    private Analyzer analyzer = null;
    private String url;
    private SearchIndexBuilder searchIndexBuilder;
    private Map<String, String> attributes;

    public SearchResultResponseImpl(Map<String, String> attributes, Query query, Analyzer analyzer, SearchIndexBuilder searchIndexBuilder, SearchService searchService) throws IOException {
        this.attributes = attributes;
        this.query = query;
        this.analyzer = analyzer;
        this.searchIndexBuilder = searchIndexBuilder;
    }

    public SearchResultResponseImpl(Attributes atts, Query query, Analyzer analyzer, SearchIndexBuilder searchIndexBuilder, SearchService searchService) throws IOException {
        HashMap<String, String> m = new HashMap<String, String>();
        for (int i = 0; i < atts.getLength(); ++i) {
            m.put(atts.getLocalName(i), atts.getValue(i));
        }
        try {
            String title = (String)m.get("title");
            if (title != null) {
                m.put("title", new String(Base64.decodeBase64((byte[])title.getBytes("UTF-8")), "UTF-8"));
            }
        }
        catch (UnsupportedEncodingException e) {
            log.debug((Object)e);
        }
        this.attributes = m;
        this.query = query;
        this.analyzer = analyzer;
        this.searchIndexBuilder = searchIndexBuilder;
    }

    public float getScore() {
        return Float.parseFloat(this.attributes.get("score"));
    }

    public String getId() {
        return this.attributes.get("sid");
    }

    public String[] getFieldNames() {
        if (this.fieldNames != null) {
            return this.fieldNames;
        }
        this.fieldNames = new String[this.attributes.size()];
        int ii = 0;
        Iterator<String> i = this.attributes.keySet().iterator();
        while (i.hasNext()) {
            this.fieldNames[ii++] = i.next();
        }
        return this.fieldNames;
    }

    public String[] getValues(String fieldName) {
        return new String[]{this.attributes.get(fieldName)};
    }

    public Map<String, String[]> getValueMap() {
        HashMap<String, String[]> hm = new HashMap<String, String[]>();
        String[] fieldNames = this.getFieldNames();
        for (int i = 0; i < fieldNames.length; ++i) {
            hm.put(fieldNames[i], new String[]{this.attributes.get(fieldNames[i])});
        }
        return hm;
    }

    public String getUrl() {
        if (this.url == null) {
            this.url = this.attributes.get("url");
        }
        return this.url;
    }

    public String getTitle() {
        return this.attributes.get("title");
    }

    public String getTool() {
        return this.attributes.get("tool");
    }

    public int getIndex() {
        return Integer.parseInt(this.attributes.get("index"));
    }

    public String getSearchResult() {
        try {
            QueryScorer scorer = new QueryScorer(this.query);
            Highlighter hightlighter = new Highlighter((Formatter)new SimpleHTMLFormatter(), (Encoder)new SimpleHTMLEncoder(), (Scorer)scorer);
            StringBuilder sb = new StringBuilder();
            EntityContentProducer sep = this.searchIndexBuilder.newEntityContentProducer(this.getReference());
            if (sep != null) {
                sb.append(sep.getContent(this.getReference()));
            }
            String text = sb.toString();
            TokenStream tokenStream = this.analyzer.tokenStream("contents", (Reader)new StringReader(text));
            return hightlighter.getBestFragments(tokenStream, text, 5, " ... ");
        }
        catch (IOException e) {
            return Messages.getString("SearchResultResponseImpl.11") + e.getMessage();
        }
        catch (InvalidTokenOffsetsException e) {
            return Messages.getString("SearchResultResponseImpl.11") + e.getMessage();
        }
    }

    public String getReference() {
        return this.attributes.get("reference");
    }

    public TermFrequency getTerms() throws IOException {
        return null;
    }

    public void toXMLString(StringBuilder sb) {
        sb.append("<result");
        sb.append(" index=\"").append(this.getIndex()).append("\" ");
        sb.append(" score=\"").append(this.getScore()).append("\" ");
        sb.append(" sid=\"").append(StringEscapeUtils.escapeXml((String)this.getId())).append("\" ");
        sb.append(" reference=\"").append(StringEscapeUtils.escapeXml((String)this.getReference())).append("\" ");
        try {
            sb.append(" title=\"").append(new String(Base64.encodeBase64((byte[])this.getTitle().getBytes("UTF-8")), "UTF-8")).append("\" ");
        }
        catch (UnsupportedEncodingException e) {
            sb.append(" title=\"").append(StringEscapeUtils.escapeXml((String)this.getTitle())).append("\" ");
        }
        sb.append(" tool=\"").append(StringEscapeUtils.escapeXml((String)this.getTool())).append("\" ");
        sb.append(" url=\"").append(StringEscapeUtils.escapeXml((String)this.getUrl())).append("\" />");
    }

    public String getSiteId() {
        return this.attributes.get("site");
    }

    public boolean isCensored() {
        return false;
    }

    public void setUrl(String newUrl) {
        this.url = newUrl;
    }

    public boolean hasPortalUrl() {
        log.info((Object)("hasPortalUrl(" + this.getReference()));
        EntityContentProducer sep = this.searchIndexBuilder.newEntityContentProducer(this.getReference());
        if (sep != null) {
            log.info((Object)("got ECP for " + this.getReference()));
            if (PortalUrlEnabledProducer.class.isAssignableFrom(sep.getClass())) {
                log.info((Object)"has portalURL!");
                return true;
            }
        }
        return false;
    }
}

