/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.search.entitybroker;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sakaiproject.entitybroker.EntityReference;
import org.sakaiproject.entitybroker.entityprovider.capabilities.CollectionResolvable;
import org.sakaiproject.entitybroker.entityprovider.capabilities.Describeable;
import org.sakaiproject.entitybroker.entityprovider.capabilities.Outputable;
import org.sakaiproject.entitybroker.entityprovider.search.Restriction;
import org.sakaiproject.entitybroker.entityprovider.search.Search;
import org.sakaiproject.entitybroker.util.AbstractEntityProvider;
import org.sakaiproject.search.api.InvalidSearchQueryException;
import org.sakaiproject.search.api.SearchList;
import org.sakaiproject.search.api.SearchResult;
import org.sakaiproject.search.api.SearchService;
import org.sakaiproject.site.api.Site;
import org.sakaiproject.site.api.SiteService;
import org.sakaiproject.user.api.UserDirectoryService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SearchEntityProvider
extends AbstractEntityProvider
implements CollectionResolvable,
Outputable,
Describeable {
    private static Log log = LogFactory.getLog(SearchEntityProvider.class);
    private SearchService searchService = null;
    private SiteService siteService = null;
    public UserDirectoryService userDirectoryService;

    public void setSearchService(SearchService searchService) {
        this.searchService = searchService;
    }

    public void setSiteService(SiteService siteService) {
        this.siteService = siteService;
    }

    public void setUserDirectoryService(UserDirectoryService userDirectoryService) {
        this.userDirectoryService = userDirectoryService;
    }

    public String getEntityPrefix() {
        return "search";
    }

    public String[] getHandledOutputFormats() {
        return new String[]{"json", "xml"};
    }

    public List<?> getEntities(EntityReference ref, Search search) {
        SearchList searchResults;
        Restriction searchTermsRestriction = search.getRestrictionByProperty("searchTerms");
        if (searchTermsRestriction == null) {
            throw new IllegalArgumentException("No searchTerms supplied");
        }
        String searchTerms = searchTermsRestriction.getStringValue();
        if (search.getLimit() > 50L || search.getLimit() == 0L) {
            search.setLimit(50L);
        }
        if (search.getStart() > 49L) {
            search.setStart(0L);
        }
        List<String> contexts = null;
        Restriction contextsRestriction = search.getRestrictionByProperty("contexts");
        if (contextsRestriction != null) {
            String[] contextsArray = contextsRestriction.getStringValue().split(",");
            contexts = Arrays.asList(contextsArray);
        } else {
            contexts = this.getAllUsersSites();
        }
        try {
            searchResults = this.searchService.search(searchTerms, contexts, (int)search.getStart(), (int)search.getLimit(), "normal", "normal");
        }
        catch (InvalidSearchQueryException e) {
            throw new IllegalArgumentException(searchTerms + " is not a valid query expression");
        }
        Restriction toolRestriction = search.getRestrictionByProperty("tool");
        String tool = null;
        if (toolRestriction != null) {
            tool = toolRestriction.getStringValue();
        }
        ArrayList<SearchResultEntity> results = new ArrayList<SearchResultEntity>();
        for (SearchResult result : searchResults) {
            if (tool != null && !result.getTool().equalsIgnoreCase(tool)) continue;
            results.add(new SearchResultEntity(result));
        }
        return results;
    }

    public Object getEntity(EntityReference ref) {
        System.out.println("getEntity(" + ref.getReference() + ")");
        return null;
    }

    private List<String> getAllUsersSites() {
        List sites = this.siteService.getSites(SiteService.SelectionType.ACCESS, null, null, null, null, null);
        ArrayList<String> siteIds = new ArrayList<String>(sites.size());
        for (Site site : sites) {
            if (site == null || site.getId() == null) continue;
            siteIds.add(site.getId());
        }
        siteIds.add(this.siteService.getUserSiteId(this.userDirectoryService.getCurrentUser().getId()));
        return siteIds;
    }

    public class SearchResultEntity {
        private SearchResult result = null;

        private SearchResultEntity(SearchResult result) {
            this.result = result;
        }

        public String getId() {
            return this.result.getId();
        }

        public float getScore() {
            return this.result.getScore();
        }

        public String getSearchResult() {
            return this.result.getSearchResult();
        }

        public String getTitle() {
            return this.result.getTitle();
        }

        public String getTool() {
            return this.result.getTool();
        }

        public String getUrl() {
            return this.result.getUrl();
        }
    }
}

