/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.search.index.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.search.IndexSearcher;
import org.sakaiproject.search.index.AnalyzerFactory;
import org.sakaiproject.search.index.IndexReloadListener;
import org.sakaiproject.search.index.IndexStorage;

public abstract class BaseIndexStorage
implements IndexStorage {
    private static final Log log = LogFactory.getLog(BaseIndexStorage.class);
    private IndexSearcher runningIndexSearcher;
    private Object reloadObjectSemaphore = new Object();
    private Timer indexCloseTimer = new Timer(true);
    private long reloadStart;
    private long reloadEnd;
    protected boolean diagnostics;
    private List<IndexReloadListener> indexReloadListeners = new ArrayList<IndexReloadListener>();
    private AnalyzerFactory analyzerFactory = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IndexSearcher getIndexSearcher(boolean reload) throws IOException {
        if (this.runningIndexSearcher == null || reload) {
            long lastUpdate = this.getLastUpdate();
            if (lastUpdate > this.reloadStart || this.runningIndexSearcher == null) {
                this.reloadStart = System.currentTimeMillis();
                long startLoad = System.currentTimeMillis();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Reloading Index, force=" + reload));
                }
                try {
                    IndexSearcher newRunningIndexSearcher = this.getIndexSearcher();
                    Object object = this.reloadObjectSemaphore;
                    synchronized (object) {
                        final IndexSearcher oldRunningIndexSearcher = this.runningIndexSearcher;
                        this.runningIndexSearcher = newRunningIndexSearcher;
                        this.reloadEnd = System.currentTimeMillis();
                        if (oldRunningIndexSearcher != null) {
                            this.indexCloseTimer.schedule(new TimerTask(){

                                /*
                                 * WARNING - Removed try catching itself - possible behaviour change.
                                 * Enabled aggressive block sorting
                                 * Enabled unnecessary exception pruning
                                 * Enabled aggressive exception aggregation
                                 */
                                public void run() {
                                    try {
                                        try {
                                            BaseIndexStorage.this.closeIndexSearcher(oldRunningIndexSearcher);
                                        }
                                        catch (Exception ex) {
                                            log.error((Object)"Failed to close old searcher ", (Throwable)ex);
                                            Object var3_2 = null;
                                            this.cancel();
                                            BaseIndexStorage.this.indexCloseTimer.purge();
                                            return;
                                        }
                                        Object var3_1 = null;
                                    }
                                    catch (Throwable throwable) {
                                        Object var3_3 = null;
                                        this.cancel();
                                        BaseIndexStorage.this.indexCloseTimer.purge();
                                        throw throwable;
                                    }
                                    this.cancel();
                                    BaseIndexStorage.this.indexCloseTimer.purge();
                                }
                            }, 30000L);
                        }
                    }
                    this.fireIndexReload(this.reloadStart, this.reloadEnd);
                }
                catch (IOException e) {
                    this.reloadStart = this.reloadEnd;
                }
                long loadPause = System.currentTimeMillis() - startLoad;
                if (loadPause > 10000L) {
                    log.warn((Object)("Reload of blocked this thread for " + loadPause + " ms "));
                }
            } else if (log.isDebugEnabled()) {
                log.debug((Object)("No Reload lastUpdate " + lastUpdate + " < lastReload " + this.reloadStart));
            }
        }
        return this.runningIndexSearcher;
    }

    protected abstract IndexSearcher getIndexSearcher() throws IOException;

    protected void fireIndexReload(long reloadStart, long reloadEnd) {
        for (IndexReloadListener tl : this.indexReloadListeners) {
            tl.reloaded(reloadStart, reloadEnd);
        }
    }

    public long getLastLoad() {
        return this.reloadEnd;
    }

    public long getLastLoadTime() {
        return this.reloadEnd - this.reloadStart;
    }

    public void addReloadListener(IndexReloadListener indexReloadListener) {
        ArrayList<IndexReloadListener> tl = new ArrayList<IndexReloadListener>();
        tl.addAll(this.indexReloadListeners);
        tl.add(indexReloadListener);
        this.indexReloadListeners = tl;
    }

    public void removeReloadListener(IndexReloadListener indexReloadListener) {
        ArrayList<IndexReloadListener> tl = new ArrayList<IndexReloadListener>();
        tl.addAll(this.indexReloadListeners);
        tl.remove(indexReloadListener);
        this.indexReloadListeners = tl;
    }

    public void forceNextReload() {
        this.reloadStart = 0L;
    }

    public void disableDiagnostics() {
        this.diagnostics = false;
    }

    public void enableDiagnostics() {
        this.diagnostics = true;
    }

    public boolean hasDiagnostics() {
        return this.diagnostics;
    }

    public AnalyzerFactory getAnalyzerFactory() {
        return this.analyzerFactory;
    }

    public void setAnalyzerFactory(AnalyzerFactory analzyserFactory) {
        this.analyzerFactory = analzyserFactory;
    }

    public Analyzer getAnalyzer() {
        return this.analyzerFactory.newAnalyzer();
    }
}

