/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.search.index.impl;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.sakaiproject.search.index.impl.BaseIndexStorage;

public class FSIndexStorage
extends BaseIndexStorage {
    private static Log log = LogFactory.getLog(FSIndexStorage.class);
    protected String searchIndexDirectory = "searchindex";
    protected boolean recoverCorruptedIndex = false;
    private long lastUpdate = System.currentTimeMillis();
    private Directory spellDirectory = null;

    public void init() {
    }

    public void doPreIndexUpdate() throws IOException {
        log.debug((Object)("Starting process List on " + this.searchIndexDirectory));
        File f = new File(this.searchIndexDirectory);
        if (!f.exists()) {
            if (!f.mkdirs()) {
                log.warn((Object)("doPreIndexUpdate() couldn't delete " + f.getPath()));
            }
            log.debug((Object)("Indexing in " + f.getAbsolutePath()));
        }
        if (IndexReader.isLocked((String)this.searchIndexDirectory)) {
            IndexReader.unlock((Directory)FSDirectory.getDirectory((String)this.searchIndexDirectory, (boolean)true));
            log.warn((Object)"Unlocked Lucene Directory for update, hope this is Ok");
        }
    }

    public IndexReader getIndexReader() throws IOException {
        return IndexReader.open((String)this.searchIndexDirectory);
    }

    public IndexWriter getIndexWriter(boolean create) throws IOException {
        return new IndexWriter(this.searchIndexDirectory, this.getAnalyzer(), create);
    }

    public void doPostIndexUpdate() throws IOException {
        this.lastUpdate = System.currentTimeMillis();
    }

    public String getSearchIndexDirectory() {
        return this.searchIndexDirectory;
    }

    protected IndexSearcher getIndexSearcher() throws IOException {
        IndexSearcher indexSearcher;
        block7: {
            indexSearcher = null;
            try {
                long reloadStart = System.currentTimeMillis();
                File indexDirectoryFile = new File(this.searchIndexDirectory);
                if (!indexDirectoryFile.exists() && !indexDirectoryFile.mkdirs()) {
                    log.warn((Object)("getIdexSearch couldn't create directory " + indexDirectoryFile.getPath()));
                }
                if ((indexSearcher = new IndexSearcher(this.searchIndexDirectory)) == null) {
                    log.warn((Object)"No search Index exists at this time");
                }
                long reloadEnd = System.currentTimeMillis();
                if (this.diagnostics) {
                    log.info((Object)("Reload Complete " + indexSearcher.getIndexReader().numDocs() + " in " + (reloadEnd - reloadStart)));
                }
            }
            catch (FileNotFoundException e) {
                log.error((Object)"There has been a major poblem with the Search Index which has become corrupted ", (Throwable)e);
                if (this.doIndexRecovery()) {
                    indexSearcher = new IndexSearcher(this.searchIndexDirectory);
                }
            }
            catch (IOException e) {
                log.error((Object)"There has been a major poblem with the Search Index which has become corrupted", (Throwable)e);
                if (!this.doIndexRecovery()) break block7;
                indexSearcher = new IndexSearcher(this.searchIndexDirectory);
            }
        }
        return indexSearcher;
    }

    protected boolean doIndexRecovery() throws IOException {
        if (this.recoverCorruptedIndex) {
            IndexWriter iw = this.getIndexWriter(true);
            Document doc = new Document();
            String message = "Index Recovery performed on " + new Date().toString();
            doc.add((Fieldable)new Field("contents", message, Field.Store.NO, Field.Index.TOKENIZED));
            iw.addDocument(doc);
            iw.close();
            log.error((Object)"Sucess fully recoverd From a corrupted index, the index will be empty and require a complete rebuild");
            return true;
        }
        return false;
    }

    public boolean indexExists() {
        return IndexReader.indexExists((String)this.searchIndexDirectory);
    }

    public boolean isRecoverCorruptedIndex() {
        return this.recoverCorruptedIndex;
    }

    public void setRecoverCorruptedIndex(boolean recoverCorruptedIndex) {
        log.info((Object)("Using FSIndexStorage, storing the index on the local file system in " + this.searchIndexDirectory + " if the index is corrupted recovery will " + (recoverCorruptedIndex ? "" : "NOT ") + " be automatic"));
        this.recoverCorruptedIndex = recoverCorruptedIndex;
    }

    public void setLocation(String location) {
        this.searchIndexDirectory = location;
    }

    public long getLastUpdate() {
        return this.lastUpdate;
    }

    public List getSegmentInfoList() {
        ArrayList<Object[]> l = new ArrayList<Object[]>();
        l.add(new Object[]{"Index Segment Info is not implemented for Local file system index stores", "", ""});
        return l;
    }

    public void closeIndexReader(IndexReader indexReader) throws IOException {
        if (indexReader != null) {
            indexReader.close();
        }
    }

    public void closeIndexWriter(IndexWriter indexWrite) throws IOException {
        if (indexWrite != null) {
            indexWrite.close();
        }
    }

    public boolean isMultipleIndexers() {
        return false;
    }

    public void closeIndexSearcher(IndexSearcher indexSearcher) {
        IndexReader indexReader = indexSearcher.getIndexReader();
        boolean closedAlready = false;
        try {
            if (indexReader != null) {
                indexReader.close();
                closedAlready = true;
            }
        }
        catch (Exception ex) {
            log.error((Object)("Failed to close Index Reader " + ex.getMessage()));
        }
        try {
            indexSearcher.close();
        }
        catch (Exception ex) {
            if (closedAlready) {
                log.debug((Object)("Failed to close Index Searcher " + ex.getMessage()));
            }
            log.error((Object)("Failed to close Index Searcher " + ex.getMessage()));
        }
    }

    public boolean centralIndexExists() {
        return this.indexExists();
    }

    public Directory getSpellDirectory() {
        return this.spellDirectory;
    }
}

