/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.search.index.impl;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.store.Directory;
import org.sakaiproject.search.index.IndexReloadListener;
import org.sakaiproject.search.index.IndexStorage;

public class SearchIndexStorage
implements IndexStorage {
    private static final Log log = LogFactory.getLog(SearchIndexStorage.class);
    private IndexStorage runningIndexStorage = null;
    private Map currentStores = null;
    private IndexStorage defaultIndexStorage;
    private String indexStorageName;
    private boolean recover;
    private String location;

    public void init() {
        log.info((Object)"init()");
        try {
            this.runningIndexStorage = (IndexStorage)this.currentStores.get(this.indexStorageName.trim());
            if (this.runningIndexStorage == null) {
                this.runningIndexStorage = this.defaultIndexStorage;
            }
        }
        catch (Exception ex) {
            log.warn((Object)"Failed to init SearchIndexStorage ", (Throwable)ex);
        }
        log.info((Object)"init() Ok");
    }

    public IndexReader getIndexReader() throws IOException {
        return this.runningIndexStorage.getIndexReader();
    }

    public IndexWriter getIndexWriter(boolean create) throws IOException {
        return this.runningIndexStorage.getIndexWriter(create);
    }

    public void doPostIndexUpdate() throws IOException {
        this.runningIndexStorage.doPostIndexUpdate();
    }

    public void doPreIndexUpdate() throws IOException {
        this.runningIndexStorage.doPreIndexUpdate();
    }

    public boolean indexExists() {
        return this.runningIndexStorage.indexExists();
    }

    public Analyzer getAnalyzer() {
        return this.runningIndexStorage.getAnalyzer();
    }

    public Map getCurrentStores() {
        return this.currentStores;
    }

    public void setCurrentStores(Map currentStores) {
        this.currentStores = currentStores;
    }

    public IndexStorage getDefaultIndexStorage() {
        return this.defaultIndexStorage;
    }

    public void setDefaultIndexStorage(IndexStorage defaultIndexStorage) {
        this.defaultIndexStorage = defaultIndexStorage;
    }

    public String getIndexStorageName() {
        return this.indexStorageName;
    }

    public void setIndexStorageName(String indexStorageName) {
        this.indexStorageName = indexStorageName;
    }

    public IndexStorage getRunningIndexStorage() {
        return this.runningIndexStorage;
    }

    public void setRunningIndexStorage(IndexStorage runningIndexStorage) {
        this.runningIndexStorage = runningIndexStorage;
    }

    public void setRecoverCorruptedIndex(boolean recover) {
        this.recover = recover;
    }

    public long getLastUpdate() {
        return this.runningIndexStorage.getLastUpdate();
    }

    public List getSegmentInfoList() {
        return this.runningIndexStorage.getSegmentInfoList();
    }

    public void closeIndexReader(IndexReader indexReader) throws IOException {
        this.runningIndexStorage.closeIndexReader(indexReader);
    }

    public void closeIndexWriter(IndexWriter indexWrite) throws IOException {
        this.runningIndexStorage.closeIndexWriter(indexWrite);
    }

    public boolean isMultipleIndexers() {
        return this.runningIndexStorage.isMultipleIndexers();
    }

    public void closeIndexSearcher(IndexSearcher indexSearcher) {
        this.runningIndexStorage.closeIndexSearcher(indexSearcher);
    }

    public void disableDiagnostics() {
        this.runningIndexStorage.disableDiagnostics();
    }

    public void enableDiagnostics() {
        this.runningIndexStorage.enableDiagnostics();
    }

    public boolean hasDiagnostics() {
        return this.runningIndexStorage.hasDiagnostics();
    }

    public boolean centralIndexExists() {
        return this.runningIndexStorage.centralIndexExists();
    }

    public void addReloadListener(IndexReloadListener indexReloadListener) {
        this.runningIndexStorage.addReloadListener(indexReloadListener);
    }

    public void forceNextReload() {
        this.runningIndexStorage.forceNextReload();
    }

    public IndexSearcher getIndexSearcher(boolean reload) throws IOException {
        return this.runningIndexStorage.getIndexSearcher(reload);
    }

    public long getLastLoad() {
        return this.runningIndexStorage.getLastLoad();
    }

    public long getLastLoadTime() {
        return this.runningIndexStorage.getLastLoadTime();
    }

    public void removeReloadListener(IndexReloadListener indexReloadListener) {
        this.runningIndexStorage.removeReloadListener(indexReloadListener);
    }

    public Directory getSpellDirectory() {
        return null;
    }
}

