/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.search.index.impl;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.channels.FileLock;
import java.util.Date;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sakaiproject.search.index.SegmentInfo;
import org.sakaiproject.search.index.impl.SegmentState;

public class SegmentInfoImpl
implements SegmentInfo {
    private static final Log log = LogFactory.getLog(SegmentInfoImpl.class);
    public static final String TIMESTAMP_FILE = "_sakaicluster";
    public static final String NEW_FILE = "_newsegment";
    public static final String DELETED_FILE = "_deletedsegment";
    private String name;
    private long version;
    private boolean indb;
    private String[] states = new String[]{"new", "created", "deleted"};
    private boolean localStructuredStorage;
    private String searchIndexDirectory;
    private File segmentLocation;
    private File timestampFile;
    private File newFile;
    private File deletedFile;
    private long segmentSize;
    public static final int STATE_NEW = 0;
    public static final int STATE_CREATED = 1;
    public static final int STATE_DELETED = 2;
    private SegmentState storedSegmentState = null;
    private SegmentState liveSegmentState = null;
    private static ConcurrentHashMap<String, String> lock = new ConcurrentHashMap();

    public String toString() {
        return this.name + ":" + this.version + ":" + this.indb + ": State:" + this.states[this.getState()] + ":Created:" + this.name + ": Update" + new Date(this.version);
    }

    public static SegmentInfo newSharedSegmentInfo(String name, long version, boolean localStructuredStorage, String searchIndexDirectory) {
        return new SegmentInfoImpl(name, version, true, localStructuredStorage, searchIndexDirectory);
    }

    public static SegmentInfo newLocalSegmentInfo(File file, boolean localStructuredStorage, String searchIndexDirectory) {
        return new SegmentInfoImpl(file, false, localStructuredStorage, searchIndexDirectory);
    }

    public static SegmentInfo newLocalSegmentInfo(SegmentInfo recoverSegInfo) {
        SegmentInfoImpl si = (SegmentInfoImpl)recoverSegInfo;
        File segmentLocation = SegmentInfoImpl.getSegmentLocation(si.getName(), si.localStructuredStorage, si.searchIndexDirectory);
        return new SegmentInfoImpl(segmentLocation, false, si.localStructuredStorage, si.searchIndexDirectory);
    }

    private SegmentInfoImpl(String name, long version, boolean indb, boolean localStructuredStorage, String searchIndexDirectory) {
        this.searchIndexDirectory = searchIndexDirectory;
        this.localStructuredStorage = localStructuredStorage;
        this.segmentLocation = SegmentInfoImpl.getSegmentLocation(name, localStructuredStorage, searchIndexDirectory);
        this.timestampFile = new File(this.segmentLocation, TIMESTAMP_FILE);
        this.newFile = new File(this.segmentLocation, NEW_FILE);
        this.deletedFile = new File(this.segmentLocation, DELETED_FILE);
        this.indb = indb;
        this.version = version;
        this.name = name;
        try {
            this.storedSegmentState = new SegmentState(this, this.timestampFile);
        }
        catch (IOException e) {
            log.debug((Object)"Cant Load Stored Segment State");
        }
        try {
            this.liveSegmentState = new SegmentState(this, null);
            this.liveSegmentState.setTimeStamp(version);
        }
        catch (IOException e) {
            log.debug((Object)"Cant Load Live Segment State");
        }
    }

    private SegmentInfoImpl(File file, boolean indb, boolean localStructuredStorage, String searchIndexDirectory) {
        this.searchIndexDirectory = searchIndexDirectory;
        this.localStructuredStorage = localStructuredStorage;
        this.segmentLocation = file;
        this.timestampFile = new File(this.segmentLocation, TIMESTAMP_FILE);
        this.newFile = new File(this.segmentLocation, NEW_FILE);
        this.deletedFile = new File(this.segmentLocation, DELETED_FILE);
        this.indb = indb;
        this.name = file.getName();
        this.version = -1L;
        if (this.segmentLocation.isDirectory()) {
            try {
                this.storedSegmentState = new SegmentState(this, this.timestampFile);
                this.version = this.storedSegmentState.getTimeStamp();
            }
            catch (IOException e) {
                log.info((Object)("Segment (" + this.name + "): Cant Load Stored Segment State"));
            }
            try {
                this.liveSegmentState = new SegmentState(this, null);
            }
            catch (IOException e) {
                log.info((Object)("Segment (" + this.name + "): Cant Load Live Segment State"));
            }
        }
    }

    public void setInDb(boolean b) {
        this.indb = b;
    }

    public String getName() {
        return this.name;
    }

    public boolean isInDb() {
        return this.indb;
    }

    public long getVersion() {
        return this.version;
    }

    public void setVersion(long l) {
        this.version = l;
    }

    public void setState(int state) {
        if (state == 0) {
            if (!this.newFile.exists()) {
                try {
                    this.newFile.getParentFile().mkdirs();
                    this.newFile.createNewFile();
                }
                catch (IOException e) {
                    log.error((Object)("Segment (" + this.name + "): Failed to create new segment marker at " + this.newFile));
                }
            }
            if (this.deletedFile.exists() && !this.deletedFile.delete()) {
                log.warn((Object)("Can't delete file " + this.deletedFile.getPath()));
            }
        }
        if (state == 1) {
            if (this.deletedFile.exists() && !this.deletedFile.delete()) {
                log.warn((Object)("can't delete file " + this.deletedFile.getPath()));
            }
            if (this.newFile.exists() && !this.newFile.delete()) {
                log.warn((Object)("Can't delte file " + this.newFile.getPath()));
            }
        }
        if (state == 2) {
            if (!this.deletedFile.exists()) {
                try {
                    if (!this.deletedFile.getParentFile().mkdirs()) {
                        log.warn((Object)("Unable to create directory" + this.deletedFile.getParentFile().getPath()));
                    }
                    if (!this.deletedFile.createNewFile()) {
                        log.warn((Object)("can't create file: " + this.deletedFile.getPath()));
                    }
                }
                catch (IOException e) {
                    log.error((Object)("Segment (" + this.name + "): Failed to create deleted segment marker at " + this.deletedFile));
                }
            }
            if (this.newFile.exists() && !this.newFile.delete()) {
                log.warn((Object)("can't delete file " + this.newFile.getPath()));
            }
        }
    }

    public int getState() {
        if (this.deletedFile.exists()) {
            return 2;
        }
        if (this.newFile.exists()) {
            return 0;
        }
        return 1;
    }

    public File getSegmentLocation() {
        return this.segmentLocation;
    }

    public static File getSegmentLocation(String name, boolean structured, String searchIndexDirectory) {
        if (structured) {
            String hashName = name.substring(name.length() - 4, name.length() - 2);
            File hash = new File(searchIndexDirectory, hashName);
            return new File(hash, name);
        }
        return new File(searchIndexDirectory, name);
    }

    public void setNew() {
        this.setState(0);
    }

    public void setCreated() {
        this.setState(1);
    }

    public void setDeleted() {
        this.setState(2);
    }

    public boolean isNew() {
        return this.getState() == 0;
    }

    public boolean isCreated() {
        return this.getState() == 1;
    }

    public boolean isDeleted() {
        return this.getState() == 2;
    }

    public void setTimeStamp(long l) throws IOException {
        this.liveSegmentState.analyze(this);
        this.liveSegmentState.setTimeStamp(l);
        this.liveSegmentState.save(this.timestampFile);
        if (!this.timestampFile.setLastModified(l)) {
            log.warn((Object)("Couldn't set file modification time on " + this.timestampFile.getPath()));
        }
    }

    public boolean isClusterSegment() {
        return this.timestampFile.exists();
    }

    public boolean checkSegmentValidity(boolean logging, String message) {
        if (this.isCreated()) {
            return this.liveSegmentState.checkValidity(logging, message, this.storedSegmentState);
        }
        return true;
    }

    public long getLocalSegmentLastModified() {
        long lm = this.segmentLocation.lastModified();
        if (this.segmentLocation.isDirectory()) {
            File[] l = this.segmentLocation.listFiles();
            for (int i = 0; i < l.length; ++i) {
                if (l[i].lastModified() <= lm) continue;
                lm = l[i].lastModified();
            }
        }
        return lm;
    }

    public long getLocalSegmentSize() {
        if (this.segmentLocation.isDirectory()) {
            long lm = 0L;
            File[] l = this.segmentLocation.listFiles();
            for (int i = 0; i < l.length; ++i) {
                lm += l[i].length();
            }
            return lm;
        }
        return this.segmentLocation.length();
    }

    public long getTotalSize() {
        return this.getTotalSize(this.segmentLocation);
    }

    private long getTotalSize(File currentSegment) {
        long totalSize = 0L;
        if (currentSegment.isDirectory()) {
            File[] files = currentSegment.listFiles();
            if (files != null) {
                for (int i = 0; i < files.length; ++i) {
                    if (files[i].isDirectory()) {
                        totalSize += this.getTotalSize(files[i]);
                    }
                    totalSize += files[i].length();
                }
            }
        } else {
            totalSize += currentSegment.length();
        }
        return totalSize;
    }

    public void touchSegment() throws IOException {
        this.setTimeStamp(System.currentTimeMillis());
    }

    public long getSize() {
        return this.segmentSize;
    }

    public void loadSize() {
        this.segmentSize = this.getTotalSize();
    }

    public void doFinalDelete() {
        if (this.isDeleted()) {
            File f = this.getSegmentLocation();
            SegmentInfoImpl.deleteAll(f);
            log.info((Object)("Segment (" + this.name + "): Deleted "));
        } else {
            log.error((Object)("Segment (" + this.name + "): Attempt to delete current Segment Data " + this));
        }
    }

    public static void deleteAll(File f) {
        File[] files;
        if (f.isDirectory() && (files = f.listFiles()) != null) {
            for (int i = 0; i < files.length; ++i) {
                if (files[i].isDirectory()) {
                    SegmentInfoImpl.deleteAll(files[i]);
                    continue;
                }
                if (files[i].delete() || !files[i].exists()) continue;
                log.warn((Object)("Failed to delete  " + files[i].getPath()));
            }
        }
        if (!f.delete() && f.exists()) {
            log.warn((Object)("Failed to delete  " + f.getPath()));
        }
    }

    public boolean isLocalLock() {
        String threadName = lock.get(this.name);
        return threadName == null || threadName.equals(Thread.currentThread().getName());
    }

    public void lockLocalSegment() {
        String threadName = lock.get(this.name);
        if (threadName == null) {
            lock.put(this.name, Thread.currentThread().getName());
        }
    }

    public void unlockLocalSegment() {
        if (this.isLocalLock()) {
            lock.remove(this.name);
        }
    }

    public void debugSegment(String message) {
        this.liveSegmentState.checkValidity(true, message, this.storedSegmentState);
        this.dumpAllFiles(this.getSegmentLocation(), message);
    }

    private void dumpAllFiles(File f, String message) {
        this.dumpFileInfo(f, message);
        File[] files = f.listFiles();
        if (files != null) {
            for (int i = 0; i < files.length; ++i) {
                if (files[i].isDirectory()) {
                    this.dumpAllFiles(files[i], message);
                    continue;
                }
                this.dumpFileInfo(files[i], message);
            }
        }
    }

    private void dumpFileInfo(File f, String message) {
        String fileInfo = message + "(" + f.getPath() + "):";
        if (!f.exists()) {
            log.error((Object)(fileInfo + " File No longer exists"));
        } else {
            log.info((Object)(fileInfo + " size=[" + f.length() + "] lastModified=[" + f.lastModified() + "] read=[" + f.canRead() + "] write=[" + f.canWrite() + "] hidden=[" + f.isHidden() + "]"));
            try {
                FileInputStream fin = new FileInputStream(f);
                fin.read(new byte[4096]);
                log.info((Object)(fileInfo + " readOk"));
                FileLock fl = fin.getChannel().tryLock();
                fl.release();
                fin.close();
                log.info((Object)(fileInfo + " lockOk"));
            }
            catch (Exception ex) {
                log.warn((Object)(fileInfo + " Lock or Read failed: "), (Throwable)ex);
            }
        }
    }

    public void compareTo(String message, SegmentInfo compare) {
        SegmentInfoImpl si = (SegmentInfoImpl)compare;
        this.liveSegmentState.checkValidity(true, message, si.liveSegmentState);
    }
}

