/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.search.journal.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.IndexSearcher;
import org.sakaiproject.search.journal.api.IndexCloser;
import org.sakaiproject.search.journal.api.IndexListener;

public class IndexListenerCloser
implements IndexListener {
    private static final Log log = LogFactory.getLog(IndexListenerCloser.class);
    private ConcurrentHashMap<IndexCloser, IndexCloser> closeMap = new ConcurrentHashMap();

    public void doIndexReaderClose(IndexReader oldMultiReader) throws IOException {
        if (oldMultiReader instanceof IndexCloser) {
            this.closeMap.put((IndexCloser)oldMultiReader, (IndexCloser)oldMultiReader);
        }
        this.purge();
    }

    public void doIndexReaderOpen(IndexReader newMultiReader) {
    }

    public void doIndexSearcherClose(IndexSearcher indexSearcher) throws IOException {
        if (indexSearcher instanceof IndexCloser) {
            this.closeMap.put((IndexCloser)indexSearcher, (IndexCloser)indexSearcher);
        }
        this.purge();
    }

    public void doIndexSearcherOpen(IndexSearcher indexSearcher) {
    }

    public void purge() {
        for (IndexCloser c : this.closeMap.values()) {
            try {
                if (!c.doFinalClose()) continue;
                this.closeMap.remove(c);
            }
            catch (Exception ex) {
                log.info((Object)("Auto Index Close Failed " + ex.getMessage()));
            }
        }
    }

    public int size() {
        return this.closeMap.size();
    }

    public String[] getOpenIndexNames() {
        ArrayList<String> names = new ArrayList<String>();
        for (IndexCloser ic : this.closeMap.values()) {
            names.add(ic.getName());
        }
        return names.toArray(new String[0]);
    }

    public void cleanup() {
        for (IndexCloser ic : this.closeMap.values()) {
            ic.forceClose();
        }
        this.closeMap.clear();
    }
}

