/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.search.journal.impl;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.IndexSearcher;
import org.sakaiproject.search.journal.api.IndexCloser;
import org.sakaiproject.search.journal.api.ManagementOperation;
import org.sakaiproject.search.journal.api.ThreadBinder;
import org.sakaiproject.search.journal.impl.ConcurrentIndexManager;
import org.sakaiproject.search.journal.impl.JournaledFSIndexStorage;
import org.sakaiproject.thread_local.api.ThreadBound;
import org.sakaiproject.thread_local.api.ThreadLocalManager;

public class RefCountIndexSearcher
extends IndexSearcher
implements ThreadBound,
ThreadBinder,
IndexCloser {
    private static final Log log = LogFactory.getLog(RefCountIndexSearcher.class);
    private int count = 0;
    private boolean doclose = false;
    private JournaledFSIndexStorage storage;
    private IndexReader indexReader;
    private boolean closing = false;
    private ThreadLocalManager threadLocalManager;
    private ThreadLocal<String> unbindingMonitor = new ThreadLocal();
    private Object closeMonitor = new Object();
    private ManagementOperation managementOperation;
    private static int opened = 0;

    public RefCountIndexSearcher(IndexReader indexReader, JournaledFSIndexStorage storage) {
        super(indexReader);
        ++opened;
        this.managementOperation = ConcurrentIndexManager.getCurrentManagementOperation();
        this.storage = storage;
        this.indexReader = indexReader;
        if (indexReader instanceof IndexCloser) {
            ((IndexCloser)indexReader).addParent(this);
        }
    }

    public void close() throws IOException {
        this.doclose = true;
        this.unbind();
        this.storage.fireIndexSearcherClose(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unbind() {
        String unbinding = this.unbindingMonitor.get();
        if (unbinding == null) {
            try {
                this.unbindingMonitor.set("unbinding");
                if (this.threadLocalManager != null) {
                    Object o = this.threadLocalManager.get(String.valueOf(this));
                    if (o != null) {
                        --this.count;
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Unbound " + this + " " + this.count));
                        }
                        this.threadLocalManager.set(String.valueOf(this), null);
                    }
                    if (this.indexReader instanceof ThreadBound) {
                        ((ThreadBound)this.indexReader).unbind();
                    }
                }
                if (this.canClose()) {
                    this.forceClose();
                }
                Object var4_3 = null;
                this.unbindingMonitor.set(null);
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                this.unbindingMonitor.set(null);
                throw throwable;
            }
        }
    }

    public void bind(ThreadLocalManager tlm) {
        this.threadLocalManager = tlm;
        Object o = tlm.get(String.valueOf(this));
        if (o == null) {
            ++this.count;
            tlm.set(String.valueOf(this), (Object)this);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Bind " + this + " " + this.indexReader + " " + this.count));
            }
        } else if (o != this) {
            log.warn((Object)" More than one object bound to the same key ");
        }
        if (this.indexReader instanceof ThreadBinder) {
            ((ThreadBinder)this.indexReader).bind(tlm);
        }
    }

    public boolean doFinalClose() {
        if (this.canClose()) {
            return this.forceClose();
        }
        return false;
    }

    public boolean canClose() {
        return this.count <= 0 && this.doclose;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean forceClose() {
        Object object = this.closeMonitor;
        synchronized (object) {
            if (this.closing) {
                return true;
            }
            this.closing = true;
        }
        --opened;
        if (this.indexReader instanceof IndexCloser) {
            ((IndexCloser)this.indexReader).removeParent(this);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Closing Index " + this));
        }
        try {
            super.close();
        }
        catch (IOException ioex) {
            log.debug((Object)ioex);
        }
        try {
            if (this.indexReader != null) {
                this.indexReader.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return true;
    }

    public void addParent(Object searcher) {
        log.debug((Object)"Index Searchers may not have parents, ignored");
    }

    public void removeParent(Object searcher) {
        log.debug((Object)"Index Searchers may not have parents, ignored");
    }

    public static int getOpened() {
        return opened;
    }

    public String getName() {
        return this.managementOperation + " " + this.toString() + " Refcount:" + this.count;
    }
}

