/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.search.journal.impl;

import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.sakaiproject.search.journal.impl.SegmentListStore;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SegmentListReader {
    private File in;

    public SegmentListReader(File in) {
        this.in = in;
    }

    public List<File> read() throws IOException {
        int version;
        ArrayList<File> segments = new ArrayList<File>();
        if (!this.in.exists()) {
            return segments;
        }
        FileInputStream fout = new FileInputStream(this.in);
        DataInputStream din = new DataInputStream(fout);
        byte[] sig = new byte[SegmentListStore.SEGMENT_LIST_SIGNATURE.length];
        if (din.read(sig) > -1) {
            for (int i = 0; i < sig.length; ++i) {
                if (sig[i] == SegmentListStore.SEGMENT_LIST_SIGNATURE[i]) continue;
                throw new IOException("Segment List file is corrupt, please remove segments and recover from journal");
            }
        }
        if ((version = din.readInt()) == 1) {
            int n = din.readInt();
            for (int i = 0; i < n; ++i) {
                segments.add(new File(din.readUTF()));
            }
        } else {
            throw new IOException("Segment List savePoint not recognised, please remove segments and recover from journal ");
        }
        din.close();
        din.close();
        return segments;
    }
}

