/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.search.optimize.impl;

import java.io.File;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.sakaiproject.search.journal.impl.JournalSettings;
import org.sakaiproject.search.optimize.api.IndexOptimizeTransaction;
import org.sakaiproject.search.optimize.api.NoOptimizationRequiredException;
import org.sakaiproject.search.optimize.api.OptimizableIndex;
import org.sakaiproject.search.optimize.api.OptimizeTransactionListener;
import org.sakaiproject.search.optimize.api.OptimizedFailedIndexTransactionException;
import org.sakaiproject.search.transaction.api.IndexTransaction;
import org.sakaiproject.search.transaction.api.IndexTransactionException;
import org.sakaiproject.search.util.FileUtils;

public class OptimizeTransactionListenerImpl
implements OptimizeTransactionListener {
    private static final Log log = LogFactory.getLog(OptimizeTransactionListenerImpl.class);
    private OptimizableIndex optimizableIndex;
    private JournalSettings journalSettings;

    public void init() {
    }

    public void destroy() {
    }

    public void close(IndexTransaction transaction) throws IndexTransactionException {
    }

    public void commit(IndexTransaction transaction) throws IndexTransactionException {
        try {
            IndexWriter iw = ((IndexOptimizeTransaction)transaction).getTemporaryIndexWriter();
            Directory d = iw.getDirectory();
            IndexWriter pw = ((IndexOptimizeTransaction)transaction).getPermanentIndexWriter();
            pw.addIndexes(new Directory[]{d});
            pw.optimize();
            pw.close();
            iw.close();
            File[] optimzableSegments = ((IndexOptimizeTransaction)transaction).getOptimizableSegments();
            log.info((Object)("Optimized Compressed " + optimzableSegments.length + " segments "));
            this.optimizableIndex.removeOptimizableSegments(optimzableSegments);
        }
        catch (IOException ioex) {
            throw new OptimizedFailedIndexTransactionException("Failed to commit index merge operation ", ioex);
        }
    }

    public void open(IndexTransaction transaction) throws IndexTransactionException {
        File[] optimzableSegments = this.optimizableIndex.getOptimizableSegments();
        if (optimzableSegments.length < this.journalSettings.getOptimizeMergeSize()) {
            log.debug((Object)("LocalOptimze: Not enough segments to optimize " + optimzableSegments.length + " < " + this.journalSettings.getOptimizeMergeSize()));
            throw new NoOptimizationRequiredException("LocalOptimze: Not enough segments to optimize " + optimzableSegments.length + " < " + this.journalSettings.getOptimizeMergeSize());
        }
        ((IndexOptimizeTransaction)transaction).setOptimizableSegments(optimzableSegments);
    }

    public void prepare(IndexTransaction transaction) throws IndexTransactionException {
        try {
            IndexWriter pw = this.optimizableIndex.getPermanentIndexWriter();
            ((IndexOptimizeTransaction)transaction).setPermanentIndexWriter(pw);
            IndexWriter iw = ((IndexOptimizeTransaction)transaction).getTemporaryIndexWriter();
            File[] optimzableSegments = ((IndexOptimizeTransaction)transaction).getOptimizableSegments();
            FSDirectory[] directories = new FSDirectory[optimzableSegments.length];
            int i = 0;
            for (File file : optimzableSegments) {
                directories[i++] = FSDirectory.getDirectory((File)file, (boolean)false);
            }
            iw.addIndexesNoOptimize((Directory[])directories);
            iw.optimize();
            log.info((Object)("LocalOptimize: Optimized " + optimzableSegments.length + " segments in to local master "));
            for (File file : directories) {
                FSDirectory fsd = (FSDirectory)file;
                File f = fsd.getFile();
                File deleteMarker = new File(f, "deleteOnClose");
                FileUtils.createMarkerFile((File)deleteMarker);
            }
        }
        catch (IOException e) {
            throw new OptimizedFailedIndexTransactionException("Failed to Optimize indexes ", e);
        }
    }

    public void rollback(IndexTransaction transaction) throws IndexTransactionException {
    }

    public OptimizableIndex getOptimizableIndex() {
        return this.optimizableIndex;
    }

    public void setOptimizableIndex(OptimizableIndex optimizableIndex) {
        this.optimizableIndex = optimizableIndex;
    }

    public JournalSettings getJournalSettings() {
        return this.journalSettings;
    }

    public void setJournalSettings(JournalSettings journalSettings) {
        this.journalSettings = journalSettings;
    }
}

