/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.search.optimize.shared.impl;

import org.sakaiproject.search.indexer.api.IndexJournalException;
import org.sakaiproject.search.indexer.api.IndexUpdateTransactionListener;
import org.sakaiproject.search.journal.api.JournalStorageState;
import org.sakaiproject.search.journal.impl.SharedFilesystemJournalStorage;
import org.sakaiproject.search.optimize.shared.api.JournalOptimizationTransaction;
import org.sakaiproject.search.transaction.api.IndexTransaction;
import org.sakaiproject.search.transaction.api.IndexTransactionException;

public class SharedFilesystemSaveTransactionListener
implements IndexUpdateTransactionListener {
    private SharedFilesystemJournalStorage sharedFilesystemJournalStorage;
    private long sharedSleep = 90000L;

    public void init() {
    }

    public void destroy() {
    }

    public void prepare(IndexTransaction transaction) throws IndexJournalException {
        try {
            JournalOptimizationTransaction jtransaction = (JournalOptimizationTransaction)transaction;
            String indexSpace = jtransaction.getWorkingSegment().getAbsolutePath();
            long targetSavePoint = jtransaction.getTargetSavePoint();
            JournalStorageState jss = this.sharedFilesystemJournalStorage.prepareSave(indexSpace, targetSavePoint);
            transaction.put(SharedFilesystemSaveTransactionListener.class.getName() + ".state", jss);
        }
        catch (Exception ex) {
            throw new IndexJournalException("Failed to save optimized Journaled Segments ", ex);
        }
    }

    public void commit(IndexTransaction transaction) throws IndexTransactionException {
        try {
            JournalOptimizationTransaction jtransaction = (JournalOptimizationTransaction)transaction;
            JournalStorageState jss = (JournalStorageState)transaction.get(SharedFilesystemSaveTransactionListener.class.getName() + ".state");
            this.sharedFilesystemJournalStorage.commitSave(jss);
            try {
                System.err.println("============Sleeping for 90");
                Thread.sleep(this.sharedSleep);
            }
            catch (Exception ex) {
                boolean x = true;
            }
        }
        catch (Exception ex) {
            throw new IndexJournalException("Failed to retrieve Journaled Segments for processing ", ex);
        }
    }

    public void open(IndexTransaction transaction) {
    }

    public void close(IndexTransaction transaction) throws IndexTransactionException {
        transaction.clear(SharedFilesystemSaveTransactionListener.class.getName() + ".state");
    }

    public void rollback(IndexTransaction transaction) throws IndexJournalException {
        try {
            JournalOptimizationTransaction jtransaction = (JournalOptimizationTransaction)transaction;
            JournalStorageState jss = (JournalStorageState)transaction.get(SharedFilesystemSaveTransactionListener.class.getName() + ".state");
            this.sharedFilesystemJournalStorage.rollbackSave(jss);
            try {
                Thread.sleep(this.sharedSleep);
            }
            catch (Exception ex) {
                boolean x = true;
            }
        }
        catch (Exception ex) {
            throw new IndexJournalException("Failed to rollback Journaled Segments ", ex);
        }
    }

    public SharedFilesystemJournalStorage getSharedFilesystemJournalStorage() {
        return this.sharedFilesystemJournalStorage;
    }

    public void setSharedFilesystemJournalStorage(SharedFilesystemJournalStorage sharedFilesystemJournalStorage) {
        this.sharedFilesystemJournalStorage = sharedFilesystemJournalStorage;
    }

    public long getSharedSleep() {
        return this.sharedSleep;
    }

    public void setSharedSleep(long sharedSleep) {
        this.sharedSleep = sharedSleep;
    }
}

