/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.search.transaction.impl;

import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sakaiproject.search.transaction.api.IndexTransaction;
import org.sakaiproject.search.transaction.api.IndexTransactionException;
import org.sakaiproject.search.transaction.api.TransactionListener;
import org.sakaiproject.search.transaction.impl.TransactionManagerImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class IndexTransactionImpl
implements IndexTransaction {
    private static final Log log = LogFactory.getLog(IndexTransactionImpl.class);
    protected long transactionId = -2L;
    protected TransactionManagerImpl manager;
    protected int transactionState = 5;
    private Map<String, Object> attributes;

    public IndexTransactionImpl(TransactionManagerImpl manager, Map<String, Object> m) {
        this.manager = manager;
        this.attributes = m;
    }

    @Override
    public void open() throws IndexTransactionException {
        this.transactionState = 6;
        this.transactionId = this.manager.getSequence().getLocalId();
        this.transactionState = 0;
        this.doBeforeOpen();
        this.fireOpen(this);
        this.doAfterOpen();
    }

    protected void doAfterOpen() {
    }

    protected void doBeforeOpen() {
    }

    @Override
    public final void close() throws IndexTransactionException {
        if (this.transactionState != 6 && this.transactionState != 3 && this.transactionState != 5) {
            try {
                this.rollback();
            }
            catch (IndexTransactionException e) {
                log.debug((Object)e);
            }
            this.doBeforeClose();
            this.fireClose(this);
            this.doAfterClose();
        }
        this.transactionState = 5;
    }

    protected void doAfterClose() throws IndexTransactionException {
    }

    protected void doBeforeClose() throws IndexTransactionException {
    }

    @Override
    public final void prepare() throws IndexTransactionException {
        if (this.transactionState != 0) {
            throw new IndexTransactionException("Transaction is not active ");
        }
        try {
            this.transactionState = 7;
            this.doBeforePrepare();
            this.firePrepare(this);
            this.doAfterPrepare();
            this.transactionState = 2;
        }
        catch (IndexTransactionException itex) {
            throw itex;
        }
        catch (Exception e) {
            throw new IndexTransactionException("Failed to prepare ", e);
        }
    }

    protected void doAfterPrepare() throws IndexTransactionException {
    }

    protected void doBeforePrepare() throws IndexTransactionException {
    }

    @Override
    public final void commit() throws IndexTransactionException {
        if (this.transactionState != 2) {
            throw new IndexTransactionException("Transaction is not prepared ");
        }
        try {
            this.transactionState = 8;
            this.doBeforeCommit();
            this.fireCommit(this);
            this.doAfterCommit();
            this.transactionId = -1L;
            this.transactionState = 3;
        }
        catch (Exception e) {
            throw new IndexTransactionException("Failed to commit ", e);
        }
    }

    protected void doAfterCommit() throws IndexTransactionException {
    }

    protected void doBeforeCommit() throws IndexTransactionException {
    }

    @Override
    public long getTransactionId() {
        return this.transactionId;
    }

    @Override
    public final void rollback() throws IndexTransactionException {
        if (this.transactionState != 0 && this.transactionState != 8 && this.transactionState != 1 && this.transactionState != 2 && this.transactionState != 7 && this.transactionState != 9) {
            throw new IndexTransactionException("Transaction cannot be rolled back, state not active, commtting, marked rolled bac, prepared, preparing or rollingback ");
        }
        try {
            this.transactionState = 9;
            this.doBeforeRollback();
            this.fireRollback(this);
            this.doAfterRollback();
            this.transactionId = -1L;
            this.transactionState = 4;
        }
        catch (Exception e) {
            log.warn((Object)"Failed to roll back transaction ", (Throwable)e);
        }
        log.debug((Object)("Transaction Rollback Completed on " + this));
    }

    protected void doAfterRollback() throws IndexTransactionException {
    }

    protected void doBeforeRollback() throws IndexTransactionException {
    }

    @Override
    public final int getStatus() {
        return this.transactionState;
    }

    @Override
    public void clear(String key) {
        this.attributes.remove(key);
    }

    @Override
    public Object get(String key) {
        return this.attributes.get(key);
    }

    @Override
    public void put(String key, Object obj) {
        this.attributes.put(key, obj);
    }

    private void firePrepare(IndexTransaction transaction) throws IndexTransactionException {
        for (TransactionListener tl : this.manager.getTransactionListeners()) {
            tl.prepare(transaction);
        }
    }

    private void fireCommit(IndexTransaction transaction) throws IndexTransactionException {
        for (TransactionListener tl : this.manager.getTransactionListeners()) {
            tl.commit(transaction);
        }
    }

    private void fireClose(IndexTransaction transaction) throws IndexTransactionException {
        for (TransactionListener tl : this.manager.getTransactionListeners()) {
            tl.close(transaction);
        }
    }

    private void fireRollback(IndexTransaction transaction) throws IndexTransactionException {
        for (TransactionListener tl : this.manager.getTransactionListeners()) {
            tl.rollback(transaction);
        }
    }

    private void fireOpen(IndexTransaction transaction) throws IndexTransactionException {
        for (TransactionListener tl : this.manager.getTransactionListeners()) {
            tl.open(transaction);
        }
    }
}

