/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.search.index.impl;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.MultiReader;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.sakaiproject.search.index.ClusterFilesystem;
import org.sakaiproject.search.index.SegmentInfo;
import org.sakaiproject.search.index.impl.BaseIndexStorage;

public class ClusterFSIndexStorage
extends BaseIndexStorage {
    private static final Log log = LogFactory.getLog(ClusterFSIndexStorage.class);
    private long segmentThreshold = 0x1400000L;
    private ClusterFilesystem clusterFS = null;
    private long maxSegmentSize = 1572864000L;
    private long maxMegeSegmentSize = 0x4B000000L;

    public void init() {
    }

    @Override
    public IndexReader getIndexReader() throws IOException {
        return this.getIndexReader(true);
    }

    private IndexReader getIndexReader(boolean withLock) throws IOException {
        if (withLock) {
            this.clusterFS.getLock();
        }
        List<SegmentInfo> segments = this.clusterFS.updateSegments();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Found " + segments.size() + " segments "));
        }
        IndexReader[] readers = new IndexReader[segments.size()];
        int j = 0;
        for (SegmentInfo segment : segments) {
            try {
                if (!segment.checkSegmentValidity(this.diagnostics, "getIndexReader ")) {
                    log.warn((Object)("Checksum Failed on  " + segment));
                    segment.checkSegmentValidity(true, "getIndexReader Failed");
                }
                readers[j] = IndexReader.open((File)segment.getSegmentLocation());
            }
            catch (Exception ex) {
                try {
                    if (readers[j] != null) {
                        try {
                            readers[j].close();
                            readers[j] = null;
                        }
                        catch (Exception e) {
                            log.debug((Object)e);
                        }
                    }
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"Invalid segment  ", (Throwable)ex);
                    }
                    log.warn((Object)("Found corrupted segment (" + segment.getName() + ") in Local store, attempting to recover from DB.  Reason: " + ex.getClass().getName() + ":" + ex.getMessage()), (Throwable)ex);
                    this.clusterFS.recoverSegment(segment);
                    readers[j] = IndexReader.open((File)segment.getSegmentLocation());
                    log.warn((Object)("Recovery complete, resuming normal operations having restored, ignore previous problems with this segment " + segment.getName()));
                }
                catch (Exception e) {
                    if (readers[j] != null) {
                        try {
                            readers[j].close();
                            readers[j] = null;
                        }
                        catch (Exception ex2) {
                            log.debug((Object)e);
                        }
                    }
                    log.error((Object)("---Problem recovering corrupted segment from the DB,\n--- it is probably that there has been a local hardware\n--- failure on this node or that the backup in the DB is missing\n--- or corrupt. To recover, remove the segment from the db, and rebuild the index \n--- eg delete from search_segments where name_ = '" + segment.getName() + "'; \n"), (Throwable)ex);
                }
            }
            ++j;
        }
        ArrayList<IndexReader> l = new ArrayList<IndexReader>();
        for (int i = 0; i < readers.length; ++i) {
            if (readers[i] == null) continue;
            l.add(readers[i]);
        }
        if (l.size() != readers.length) {
            log.warn((Object)" Opening index reader with a partial index set, this may result in a smallere search set than otherwise expected");
        }
        if ((readers = l.toArray(new IndexReader[0])).length > 0) {
            MultiReader indexReader = new MultiReader(readers);
            return indexReader;
        }
        throw new IOException("No Index available to open ");
    }

    @Override
    public IndexWriter getIndexWriter(boolean create) throws IOException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"+++++++++++++++++Start Index Writer Cycle   ");
        }
        Object currentSegment = null;
        IndexWriter indexWriter = null;
        File tempIndex = this.clusterFS.getTemporarySegment(true);
        indexWriter = new IndexWriter(tempIndex, this.getAnalyzer(), true);
        indexWriter.setUseCompoundFile(true);
        indexWriter.setMaxMergeDocs(50);
        indexWriter.setMergeFactor(50);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Using Temp Index Writer " + tempIndex.getPath()));
        }
        return indexWriter;
    }

    @Override
    protected IndexSearcher getIndexSearcher() throws IOException {
        IndexSearcher indexSearcher = null;
        try {
            long reloadStart = System.currentTimeMillis();
            log.debug((Object)"Open Search");
            indexSearcher = new IndexSearcher(this.getIndexReader(false));
            if (indexSearcher == null) {
                log.warn((Object)"No search Index exists at this time");
            }
            long reloadEnd = System.currentTimeMillis();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Reload Complete " + indexSearcher.maxDoc() + " in " + (reloadEnd - reloadStart)));
            }
        }
        catch (FileNotFoundException e) {
            try {
                indexSearcher.close();
            }
            catch (Exception ex) {
                log.debug((Object)e);
            }
            indexSearcher = null;
            log.error((Object)"There has been a major poblem with the Search Index which has become corrupted ", (Throwable)e);
        }
        catch (IOException e) {
            try {
                indexSearcher.close();
            }
            catch (Exception ex) {
                log.debug((Object)e);
            }
            indexSearcher = null;
            log.error((Object)"There has been a major poblem with the Search Index which has become corrupted", (Throwable)e);
        }
        return indexSearcher;
    }

    @Override
    public boolean indexExists() {
        List<SegmentInfo> segments = this.clusterFS.updateSegments();
        return segments.size() > 0;
    }

    @Override
    public void doPreIndexUpdate() throws IOException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Start Index Cycle");
        }
        FSDirectory.setDisableLocks((boolean)true);
    }

    @Override
    public void doPostIndexUpdate() throws IOException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void mergeAndUpdate(boolean merge) throws IOException {
        if (merge) {
            FSDirectory.setDisableLocks((boolean)true);
            File tmpSegment = this.clusterFS.getTemporarySegment(false);
            Directory[] tmpDirectory = new Directory[]{FSDirectory.getDirectory((File)tmpSegment, (boolean)false)};
            List<SegmentInfo> segments = this.clusterFS.updateSegments();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Merge Phase 1: Starting on " + segments.size() + " segments "));
            }
            SegmentInfo currentSegment = null;
            if (log.isDebugEnabled()) {
                log.debug((Object)("Found " + segments.size() + " segments "));
            }
            if (segments.size() > 0 && (currentSegment = segments.get(segments.size() - 1)) != null && (!currentSegment.isClusterSegment() || currentSegment.getTotalSize() > this.segmentThreshold || currentSegment.isDeleted())) {
                if (this.diagnostics) {
                    log.info((Object)("Current Segment not suitable, generating new segment " + (currentSegment.isDeleted() ? "deleted," : "") + (!currentSegment.isClusterSegment() ? "non-cluster," : "") + (currentSegment.getTotalSize() > this.segmentThreshold ? "toobig," : "")));
                }
                currentSegment = null;
            }
            if (currentSegment == null) {
                if (tmpDirectory[0].fileExists("segments.gen")) {
                    currentSegment = this.clusterFS.saveTemporarySegment();
                    segments.add(currentSegment);
                    currentSegment.touchSegment();
                } else {
                    log.warn((Object)"No Segment Created during indexing process, this should not happen, although it is possible tha the indexing operation did not find any files to index.");
                }
            } else {
                IndexWriter indexWriter = null;
                try {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Using Existing Segment " + currentSegment.getName()));
                    }
                    currentSegment.touchSegment();
                    indexWriter = new IndexWriter((Directory)FSDirectory.getDirectory((File)currentSegment.getSegmentLocation(), (boolean)false), this.getAnalyzer(), false);
                    indexWriter.setUseCompoundFile(true);
                    indexWriter.setMaxMergeDocs(50);
                    indexWriter.setMergeFactor(50);
                    if (tmpDirectory[0].fileExists("segments.gen")) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Merging Temp segment " + tmpSegment.getPath() + " with current segment " + currentSegment.getSegmentLocation().getPath()));
                        }
                        indexWriter.addIndexes(tmpDirectory);
                        indexWriter.optimize();
                    } else {
                        log.warn((Object)"No Merge performed, no tmp segment");
                    }
                }
                finally {
                    try {
                        indexWriter.close();
                        currentSegment.touchSegment();
                    }
                    catch (Exception ex) {
                        log.debug((Object)ex);
                    }
                }
            }
            if (segments.size() > 10) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Merge Phase 0 : Stating");
                }
                Iterator<SegmentInfo> i = segments.iterator();
                while (i.hasNext()) {
                    i.next().loadSize();
                }
                Collections.sort(segments, new Comparator<SegmentInfo>(){

                    @Override
                    public int compare(SegmentInfo o1, SegmentInfo o2) {
                        long l = o1.getSize() - o2.getSize();
                        if (l == 0L) {
                            return 0;
                        }
                        if (l < 0L) {
                            return -1;
                        }
                        return 1;
                    }
                });
                long sizeBlock = 0L;
                int ninblock = 0;
                int mergegroupno = 1;
                int[] mergegroup = new int[segments.size()];
                int[] groupstomerge = new int[segments.size()];
                mergegroup[0] = mergegroupno;
                int j = 0;
                for (int i2 = 0; i2 < mergegroup.length; ++i2) {
                    if (segments.get(i2).getSize() >= this.maxMegeSegmentSize) continue;
                    groupstomerge[i2] = 0;
                    if (ninblock == 0) {
                        sizeBlock = segments.get(0).getSize();
                        ninblock = 1;
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Order Size = " + sizeBlock));
                        }
                    }
                    if (segments.get(i2).getSize() > sizeBlock / 10L) {
                        ++ninblock;
                    } else {
                        if (ninblock >= 2) {
                            groupstomerge[j++] = mergegroupno;
                        }
                        ninblock = 1;
                        sizeBlock = segments.get(i2).getSize();
                    }
                    mergegroup[i2] = ++mergegroupno;
                }
                if (ninblock >= 2) {
                    groupstomerge[j++] = mergegroupno;
                }
                if (j > 0) {
                    int i3;
                    StringBuilder status = new StringBuilder();
                    for (i3 = 0; i3 < segments.size(); ++i3) {
                        SegmentInfo si = segments.get(i3);
                        status.append("Segment ").append(i3).append(" n").append(si.getName()).append(" s").append(si.getSize()).append(" g").append(mergegroup[i3]).append("\n");
                    }
                    for (i3 = 0; i3 < groupstomerge.length; ++i3) {
                        status.append("Merge group ").append(i3).append(" m").append(groupstomerge[i3]).append("\n");
                    }
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Search Merge \n" + status));
                    }
                }
                for (int i4 = 0; i4 < groupstomerge.length; ++i4) {
                    if (groupstomerge[i4] == 0) continue;
                    StringBuilder status = new StringBuilder();
                    status.append("Group ").append(i4).append(" Merge ").append(groupstomerge[i4]).append("\n");
                    SegmentInfo mergeSegment = this.clusterFS.newSegment();
                    IndexWriter mergeIndexWriter = null;
                    boolean mergeOk = false;
                    try {
                        mergeIndexWriter = new IndexWriter((Directory)FSDirectory.getDirectory((File)mergeSegment.getSegmentLocation(), (boolean)false), this.getAnalyzer(), true);
                        mergeIndexWriter.setUseCompoundFile(true);
                        mergeIndexWriter.setMaxMergeDocs(50);
                        mergeIndexWriter.setMergeFactor(50);
                        ArrayList<FSDirectory> indexes = new ArrayList<FSDirectory>();
                        long currentSize = 0L;
                        for (int j2 = 0; j2 < mergegroup.length; ++j2) {
                            SegmentInfo si = segments.get(j2);
                            if (mergegroup[j2] != groupstomerge[i4]) continue;
                            if (si.isDeleted()) {
                                status.append("   Skipped, Segment is already deleted  ").append(" ").append(si.getName()).append(" || ").append(mergeSegment.getName()).append("\n");
                                continue;
                            }
                            if (currentSize + si.getSize() < this.maxSegmentSize) {
                                currentSize += si.getSize();
                                FSDirectory d = FSDirectory.getDirectory((File)si.getSegmentLocation(), (boolean)false);
                                if (d.fileExists("segments.gen")) {
                                    status.append("   Merge ").append(si.getName()).append(" >> ").append(mergeSegment.getName()).append("\n");
                                    indexes.add(d);
                                    continue;
                                }
                                status.append("   Ignored segment as it does not exist ").append(mergeSegment.getName()).append("\n");
                                continue;
                            }
                            status.append("   Skipped, size >  ").append(this.maxSegmentSize).append(" ").append(si.getName()).append(" || ").append(mergeSegment.getName()).append("\n");
                            mergegroup[j2] = -10;
                        }
                        if (this.diagnostics) {
                            log.info((Object)("Merging \n" + status));
                        }
                        mergeIndexWriter.addIndexes(indexes.toArray(new Directory[indexes.size()]));
                        mergeIndexWriter.optimize();
                        if (this.diagnostics) {
                            log.info((Object)("Merged Segment contians " + mergeIndexWriter.docCount() + " documents "));
                        }
                        mergeSegment.setCreated();
                        mergeSegment.touchSegment();
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Done " + groupstomerge[i4]));
                        }
                        mergeOk = true;
                    }
                    catch (IOException ex) {
                        log.error((Object)("Failed to merge search segments " + ex.getMessage()));
                        try {
                            this.clusterFS.removeLocalSegment(mergeSegment);
                        }
                        catch (Exception ex2) {
                            log.error((Object)("Failed to remove merge segment " + mergeSegment.getName() + " " + ex2.getMessage()));
                        }
                    }
                    finally {
                        try {
                            mergeIndexWriter.close();
                        }
                        catch (Exception ex) {}
                    }
                    if (!mergeOk) continue;
                    for (int j3 = 0; j3 < mergegroup.length; ++j3) {
                        if (mergegroup[j3] != groupstomerge[i4]) continue;
                        this.clusterFS.removeLocalSegment(segments.get(j3));
                    }
                }
            }
        } else {
            log.debug((Object)"Merge Not requested ");
        }
        this.clusterFS.removeTemporarySegment();
        this.clusterFS.saveSegments();
        if (log.isDebugEnabled()) {
            log.debug((Object)"+++++++++++++++++++++++++++++++++++++End Index Cycle");
        }
    }

    @Override
    public void setRecoverCorruptedIndex(boolean recover) {
    }

    public ClusterFilesystem getClusterFS() {
        return this.clusterFS;
    }

    public void setClusterFS(ClusterFilesystem clusterFS) {
        this.clusterFS = clusterFS;
    }

    @Override
    public long getLastUpdate() {
        return this.clusterFS.getLastUpdate();
    }

    @Override
    public List getSegmentInfoList() {
        return this.clusterFS.getSegmentInfoList();
    }

    @Override
    public void closeIndexReader(IndexReader indexReader) throws IOException {
        if (indexReader != null) {
            indexReader.close();
        }
        this.clusterFS.getLock();
        this.mergeAndUpdate(false);
        this.clusterFS.releaseLock();
    }

    @Override
    public void closeIndexWriter(IndexWriter indexWrite) throws IOException {
        if (indexWrite != null) {
            indexWrite.close();
        }
        this.clusterFS.getLock();
        this.mergeAndUpdate(true);
        this.clusterFS.releaseLock();
    }

    @Override
    public boolean isMultipleIndexers() {
        return this.clusterFS.isMultipleIndexers();
    }

    @Override
    public void closeIndexSearcher(IndexSearcher indexSearcher) {
        IndexReader indexReader = indexSearcher.getIndexReader();
        boolean closedAlready = false;
        try {
            if (indexReader != null) {
                indexReader.close();
                closedAlready = true;
            }
        }
        catch (Exception ex) {
            log.error((Object)("Failed to close Index Reader " + ex.getMessage()));
        }
        try {
            indexSearcher.close();
        }
        catch (Exception ex) {
            if (closedAlready) {
                log.debug((Object)("Failed to close Index Searcher " + ex.getMessage()));
            }
            log.error((Object)("Failed to close Index Searcher " + ex.getMessage()));
        }
    }

    public long getMaxMegeSegmentSize() {
        return this.maxMegeSegmentSize;
    }

    public void setMaxMegeSegmentSize(long maxMegeSegmentSize) {
        log.info((Object)("Max Segment Merge Size set to " + maxMegeSegmentSize));
        this.maxMegeSegmentSize = maxMegeSegmentSize;
    }

    public long getMaxSegmentSize() {
        return this.maxSegmentSize;
    }

    public void setMaxSegmentSize(long maxSegmentSize) {
        log.info((Object)("Max Segment Size set to " + maxSegmentSize));
        this.maxSegmentSize = maxSegmentSize;
    }

    public long getSegmentThreshold() {
        return this.segmentThreshold;
    }

    public void setSegmentThreshold(long segmentThreshold) {
        log.info((Object)("New Segment Size threshold set to " + segmentThreshold));
        this.segmentThreshold = segmentThreshold;
    }

    @Override
    public boolean centralIndexExists() {
        return this.clusterFS.centralIndexExists();
    }

    @Override
    public Directory getSpellDirectory() {
        return null;
    }
}

