/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.search.indexer.impl;

import java.util.Observable;
import java.util.Observer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sakaiproject.authz.api.SecurityAdvisor;
import org.sakaiproject.authz.api.SecurityService;
import org.sakaiproject.component.api.ComponentManager;
import org.sakaiproject.component.api.ServerConfigurationService;
import org.sakaiproject.db.api.SqlService;
import org.sakaiproject.event.api.EventTrackingService;
import org.sakaiproject.search.api.SearchService;
import org.sakaiproject.search.indexer.api.IndexWorker;
import org.sakaiproject.search.indexer.api.IndexWorkerDocumentListener;
import org.sakaiproject.search.journal.api.ManagementOperation;
import org.sakaiproject.search.journal.impl.JournalSettings;
import org.sakaiproject.user.api.UserDirectoryService;

public class ConcurrentSearchIndexBuilderWorkerImpl
implements ManagementOperation,
IndexWorkerDocumentListener {
    private static final Log log = LogFactory.getLog(ConcurrentSearchIndexBuilderWorkerImpl.class);
    private boolean enabled = false;
    private UserDirectoryService userDirectoryService;
    private SearchService searchService;
    private IndexWorker indexWorker;
    private ComponentManager componentManager;
    private ServerConfigurationService serverConfigurationService;
    private EventTrackingService eventTrackingService;
    private long loadFactor = 1000L;
    private boolean started = false;
    private boolean runThreads = false;
    private long lastIndexRun = System.currentTimeMillis();
    private long lastEvent;
    private ThreadLocal<String> nowIndexing = new ThreadLocal();
    private JournalSettings journalSettings;
    private SqlService sqlService;
    private SecurityService securityService;

    public void destroy() {
    }

    public void init() {
        if (this.started && !this.runThreads) {
            log.warn((Object)"JVM Shutdown in progress, will not startup");
            return;
        }
        if (this.componentManager.hasBeenClosed()) {
            log.warn((Object)"Component manager Shutdown in progress, will not startup");
            return;
        }
        this.enabled = this.searchService.isEnabled() && "true".equals(this.serverConfigurationService.getString("search.indexqueue", "true"));
        this.started = true;
        this.runThreads = true;
        if (!this.enabled) {
            return;
        }
        this.eventTrackingService.addLocalObserver(new Observer(){

            @Override
            public void update(Observable arg0, Object arg1) {
                ConcurrentSearchIndexBuilderWorkerImpl.this.lastEvent = System.currentTimeMillis();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void runOnce() {
        if (!this.enabled) {
            return;
        }
        if (this.componentManager.hasBeenClosed()) {
            log.info((Object)"Component Manager has been closed");
            return;
        }
        this.nowIndexing.set("-");
        if (this.journalSettings.getSoakTest() && this.searchService.getPendingDocs() == 0) {
            log.error((Object)"SOAK TEST---SOAK TEST---SOAK TEST. Index Rebuild Started");
            this.searchService.rebuildInstance();
        }
        log.debug((Object)"Run Processing Thread");
        int totalDocs = this.searchService.getPendingDocs();
        long now = System.currentTimeMillis();
        long interval = now - this.lastEvent;
        boolean process = false;
        boolean createIndex = false;
        this.loadFactor = totalDocs > 200 ? 10L : 1000L;
        if (totalDocs == 0) {
            process = false;
        } else if (totalDocs < 20 && interval > 20L * this.loadFactor) {
            process = true;
        } else if (totalDocs >= 20 && totalDocs < 50 && interval > 10L * this.loadFactor) {
            process = true;
        } else if (totalDocs >= 50 && totalDocs < 90 && interval > 5L * this.loadFactor) {
            process = true;
        } else if ((long)totalDocs > 90L * this.loadFactor / 1000L) {
            process = true;
        }
        long lastIndexInterval = System.currentTimeMillis() - this.lastIndexRun;
        long lastIndexMetric = lastIndexInterval * (long)totalDocs;
        log.debug((Object)("Activity " + (lastIndexMetric > 10000L * this.loadFactor) + " " + (lastIndexInterval > 60L * this.loadFactor) + " " + createIndex));
        log.debug((Object)("===" + process + "=============PROCESSING "));
        if (process) {
            this.lastIndexRun = System.currentTimeMillis();
            int batchSize = 100;
            if (totalDocs > 100000) {
                batchSize = 2000;
            } else if (totalDocs > 10000) {
                batchSize = 1000;
            } else if (totalDocs > 1000) {
                batchSize = 500;
            } else if (totalDocs > 500) {
                batchSize = 200;
            }
            this.securityService.pushAdvisor(new SecurityAdvisor(){

                public SecurityAdvisor.SecurityAdvice isAllowed(String userId, String function, String reference) {
                    return SecurityAdvisor.SecurityAdvice.ALLOWED;
                }
            });
            try {
                this.indexWorker.process(batchSize);
            }
            finally {
                this.securityService.popAdvisor();
            }
            this.lastIndexRun = System.currentTimeMillis();
        }
    }

    @Override
    public void indexDocumentEnd(IndexWorker worker, String ref) {
        this.nowIndexing.set("-");
    }

    @Override
    public void indexDocumentStart(IndexWorker worker, String ref) {
        this.nowIndexing.set(ref);
    }

    public ComponentManager getComponentManager() {
        return this.componentManager;
    }

    public void setComponentManager(ComponentManager componentManager) {
        this.componentManager = componentManager;
    }

    public EventTrackingService getEventTrackingService() {
        return this.eventTrackingService;
    }

    public void setEventTrackingService(EventTrackingService eventTrackingService) {
        this.eventTrackingService = eventTrackingService;
    }

    public IndexWorker getIndexWorker() {
        return this.indexWorker;
    }

    public void setIndexWorker(IndexWorker indexWorker) {
        this.indexWorker = indexWorker;
    }

    public long getLoadFactor() {
        return this.loadFactor;
    }

    public void setLoadFactor(long loadFactor) {
        this.loadFactor = loadFactor;
    }

    public SearchService getSearchService() {
        return this.searchService;
    }

    public void setSearchService(SearchService searchService) {
        this.searchService = searchService;
    }

    public UserDirectoryService getUserDirectoryService() {
        return this.userDirectoryService;
    }

    public void setUserDirectoryService(UserDirectoryService userDirectoryService) {
        this.userDirectoryService = userDirectoryService;
    }

    public void setServerConfigurationService(ServerConfigurationService serverConfigurationService) {
        this.serverConfigurationService = serverConfigurationService;
    }

    public JournalSettings getJournalSettings() {
        return this.journalSettings;
    }

    public void setJournalSettings(JournalSettings journalSettings) {
        this.journalSettings = journalSettings;
    }

    public SqlService getSqlService() {
        return this.sqlService;
    }

    public void setSqlService(SqlService sqlService) {
        this.sqlService = sqlService;
    }

    public SecurityService getSecurityService() {
        return this.securityService;
    }

    public void setSecurityService(SecurityService securityService) {
        this.securityService = securityService;
    }
}

