/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.search.indexer.impl;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.sakaiproject.search.indexer.api.IndexUpdateTransaction;
import org.sakaiproject.search.indexer.api.NoItemsToIndexException;
import org.sakaiproject.search.indexer.impl.SearchBuilderItemSerializer;
import org.sakaiproject.search.indexer.impl.TransactionIndexManagerImpl;
import org.sakaiproject.search.journal.impl.JournalSettings;
import org.sakaiproject.search.model.SearchBuilderItem;
import org.sakaiproject.search.transaction.api.IndexTransactionException;
import org.sakaiproject.search.transaction.impl.IndexItemsTransactionImpl;
import org.sakaiproject.search.transaction.impl.TransactionManagerImpl;
import org.sakaiproject.search.util.FileUtils;

public class IndexUpdateTransactionImpl
extends IndexItemsTransactionImpl
implements IndexUpdateTransaction {
    private static final Log log = LogFactory.getLog(IndexUpdateTransactionImpl.class);
    private IndexWriter indexWriter;
    private IndexReader indexReader;
    private File tempIndex;
    private List<SearchBuilderItem> txList;
    private SearchBuilderItemSerializer searchBuilderItemSerializer = new SearchBuilderItemSerializer();
    private JournalSettings journalSettings;

    public IndexUpdateTransactionImpl(TransactionManagerImpl manager, JournalSettings journalSettings, Map<String, Object> m) throws IndexTransactionException {
        super(manager, m);
        this.journalSettings = journalSettings;
    }

    @Override
    public Iterator<SearchBuilderItem> lockedItemIterator() throws IndexTransactionException {
        if (this.transactionState != 0) {
            throw new IndexTransactionException("Transaction is not active ");
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Tx list on " + this + " is now " + this.txList));
        }
        return this.txList.iterator();
    }

    @Override
    protected void doBeforePrepare() throws IndexTransactionException {
        try {
            this.transactionId = this.manager.getSequence().getNextId();
            Document savepointMarker = new Document();
            savepointMarker.add((Fieldable)new Field("_txid", String.valueOf(this.transactionId), Field.Store.YES, Field.Index.NOT_ANALYZED));
            savepointMarker.add((Fieldable)new Field("_txts", String.valueOf(System.currentTimeMillis()), Field.Store.YES, Field.Index.NOT_ANALYZED));
            savepointMarker.add((Fieldable)new Field("_worker", String.valueOf(Thread.currentThread().getName()), Field.Store.YES, Field.Index.NOT_ANALYZED));
            this.getInternalIndexWriter();
            this.indexWriter.addDocument(savepointMarker);
            this.indexWriter.close();
            this.indexWriter = null;
            this.searchBuilderItemSerializer.saveTransactionList(this.tempIndex, this.getItems());
        }
        catch (Exception ex) {
            throw new IndexTransactionException("Failed to prepare transaction", ex);
        }
        super.doBeforePrepare();
    }

    @Override
    protected void doAfterCommit() throws IndexTransactionException {
        try {
            FileUtils.deleteAll((File)this.tempIndex);
        }
        catch (Exception e) {
            throw new IndexTransactionException("Failed to commit ", e);
        }
        super.doAfterCommit();
    }

    @Override
    public IndexWriter getIndexWriter() throws IndexTransactionException {
        if (this.transactionState != 0) {
            throw new IndexTransactionException("Transaction is not active ");
        }
        return this.getInternalIndexWriter();
    }

    private IndexWriter getInternalIndexWriter() throws IndexTransactionException {
        if (this.indexWriter == null) {
            try {
                if (this.tempIndex == null) {
                    this.tempIndex = ((TransactionIndexManagerImpl)this.manager).getTemporarySegment(this.transactionId);
                }
                if (this.indexReader != null) {
                    this.indexReader.close();
                    this.indexReader = null;
                }
                this.indexWriter = new File(this.tempIndex, "segments.gen").exists() ? new IndexWriter((Directory)FSDirectory.open((File)this.tempIndex), ((TransactionIndexManagerImpl)this.manager).getAnalyzer(), false, IndexWriter.MaxFieldLength.UNLIMITED) : new IndexWriter((Directory)FSDirectory.open((File)this.tempIndex), ((TransactionIndexManagerImpl)this.manager).getAnalyzer(), true, IndexWriter.MaxFieldLength.UNLIMITED);
                this.indexWriter.setUseCompoundFile(true);
                this.indexWriter.setMaxMergeDocs(this.journalSettings.getCreateMaxMergeDocs());
                this.indexWriter.setMaxBufferedDocs(this.journalSettings.getCreateMaxBufferedDocs());
                this.indexWriter.setMergeFactor(this.journalSettings.getCreateMaxMergeFactor());
            }
            catch (IOException ex) {
                throw new IndexTransactionException("Cant Create Transaction Index working space ", ex);
            }
        }
        return this.indexWriter;
    }

    @Override
    public String getTempIndex() {
        return this.tempIndex.getAbsolutePath();
    }

    @Override
    public long getTransactionId() {
        return this.transactionId;
    }

    @Override
    protected void doBeforeRollback() throws IndexTransactionException {
        try {
            if (this.indexWriter != null) {
                this.indexWriter.close();
            }
            this.indexWriter = null;
        }
        catch (Exception ex) {
            throw new IndexTransactionException("Failed to start rollback ", ex);
        }
        super.doBeforeRollback();
    }

    @Override
    protected void doAfterRollback() throws IndexTransactionException {
        super.doAfterRollback();
        try {
            FileUtils.deleteAll((File)this.tempIndex);
        }
        catch (Exception ex) {
            throw new IndexTransactionException("Failed to complete rollback ", ex);
        }
        this.tempIndex = null;
    }

    @Override
    public void setItems(List<SearchBuilderItem> items) throws IndexTransactionException {
        super.setItems(items);
        this.txList = new ArrayList<SearchBuilderItem>();
        for (SearchBuilderItem sbi : items) {
            if (sbi == null || !sbi.isLocked()) continue;
            String ref = sbi.getName();
            if (ref != null) {
                this.txList.add(sbi);
                continue;
            }
            log.warn((Object)"Null Reference presented to Index Queue, ignoring ");
        }
        if (this.txList.size() == 0) {
            log.warn((Object)"No Items found to index");
            this.txList = null;
            items = null;
            throw new NoItemsToIndexException("No Items were found to add to the index");
        }
    }

    @Override
    public IndexReader getIndexReader() throws IndexTransactionException {
        if (this.transactionState != 0) {
            throw new IndexTransactionException("Transaction is not active ");
        }
        if (this.indexReader == null) {
            try {
                if (this.tempIndex == null) {
                    this.tempIndex = ((TransactionIndexManagerImpl)this.manager).getTemporarySegment(this.transactionId);
                }
                if (!new File(this.tempIndex, "segments.gen").exists()) {
                    this.getIndexWriter();
                }
                if (this.indexWriter != null) {
                    this.indexWriter.close();
                    this.indexWriter = null;
                }
                this.indexReader = IndexReader.open((Directory)FSDirectory.open((File)this.tempIndex), (boolean)false);
            }
            catch (IOException ex) {
                throw new IndexTransactionException("Cant Create Transaction Index working space ", ex);
            }
        }
        return this.indexReader;
    }
}

