/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.search.indexer.impl;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sakaiproject.search.indexer.api.IndexJournalException;
import org.sakaiproject.search.indexer.api.IndexUpdateTransaction;
import org.sakaiproject.search.indexer.api.IndexUpdateTransactionListener;
import org.sakaiproject.search.journal.api.JournalStorage;
import org.sakaiproject.search.journal.api.JournalStorageState;
import org.sakaiproject.search.transaction.api.IndexTransaction;
import org.sakaiproject.search.transaction.api.IndexTransactionException;

public class JournalStorageUpdateTransactionListener
implements IndexUpdateTransactionListener {
    private static final Log log = LogFactory.getLog(JournalStorageUpdateTransactionListener.class);
    private JournalStorage journalStorage;

    public void init() {
    }

    public void destroy() {
    }

    @Override
    public void prepare(IndexTransaction transaction) throws IndexJournalException {
        try {
            String location = ((IndexUpdateTransaction)transaction).getTempIndex();
            long transactionId = transaction.getTransactionId();
            JournalStorageState jss = this.journalStorage.prepareSave(location, transactionId);
            transaction.put(JournalStorageUpdateTransactionListener.class.getName(), jss);
        }
        catch (Exception ex) {
            throw new IndexJournalException("Failed to transfer index ", ex);
        }
    }

    @Override
    public void commit(IndexTransaction transaction) throws IndexTransactionException {
        try {
            JournalStorageState jss = (JournalStorageState)transaction.get(JournalStorageUpdateTransactionListener.class.getName());
            this.journalStorage.commitSave(jss);
            transaction.clear(JournalStorageUpdateTransactionListener.class.getName());
        }
        catch (Exception ex) {
            throw new IndexJournalException("Failed to commit index ", ex);
        }
    }

    @Override
    public void open(IndexTransaction transaction) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rollback(IndexTransaction transaction) {
        try {
            JournalStorageState jss = (JournalStorageState)transaction.get(JournalStorageUpdateTransactionListener.class.getName());
            this.journalStorage.rollbackSave(jss);
            transaction.clear(JournalStorageUpdateTransactionListener.class.getName());
        }
        catch (Exception ex) {
            log.warn((Object)"Exception during rollback", (Throwable)ex);
        }
    }

    @Override
    public void close(IndexTransaction transaction) throws IndexTransactionException {
    }

    public JournalStorage getJournalStorage() {
        return this.journalStorage;
    }

    public void setJournalStorage(JournalStorage journalStorage) {
        this.journalStorage = journalStorage;
    }
}

