/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.search.indexer.impl;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sakaiproject.search.model.SearchBuilderItem;
import org.sakaiproject.search.model.impl.SearchBuilderItemImpl;

public class SearchBuilderItemSerializer {
    private static final Log log = LogFactory.getLog(SearchBuilderItemSerializer.class);
    protected static final String TRANSACTION_LIST = "sakai_tx";

    public void init() {
    }

    public void destroy() {
    }

    public void saveTransactionList(File indexDirectoy, List<SearchBuilderItem> txList) throws IOException {
        File transactionList = new File(indexDirectoy, TRANSACTION_LIST);
        DataOutputStream dataOutputStream = new DataOutputStream(new FileOutputStream(transactionList));
        for (SearchBuilderItem sbi : txList) {
            sbi.output(dataOutputStream);
        }
        dataOutputStream.close();
    }

    public List<SearchBuilderItem> loadTransactionList(File indexDirectoy) throws IOException {
        File transactionList = new File(indexDirectoy, TRANSACTION_LIST);
        ArrayList<SearchBuilderItem> itemList = new ArrayList<SearchBuilderItem>();
        if (transactionList.exists()) {
            DataInputStream dataInputStream = new DataInputStream(new FileInputStream(transactionList));
            try {
                while (true) {
                    SearchBuilderItemImpl sbi = new SearchBuilderItemImpl();
                    sbi.input(dataInputStream);
                    itemList.add((SearchBuilderItem)sbi);
                }
            }
            catch (IOException ioex) {
                log.debug((Object)"Exception reading from input stream, normal behaviour at the end of a list, readInt 210");
                dataInputStream.close();
            }
        }
        return itemList;
    }

    public void removeTransactionList(File indexDirectory) {
        File transactionList = new File(indexDirectory, TRANSACTION_LIST);
        if (transactionList.exists() && !transactionList.delete()) {
            log.warn((Object)("couldn't delete transaction list " + transactionList.getPath()));
        }
    }
}

