/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.search.journal.impl;

import java.io.IOException;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.IndexSearcher;
import org.sakaiproject.search.api.SearchService;
import org.sakaiproject.search.journal.api.IndexListener;
import org.sakaiproject.search.journal.api.ManagementOperation;
import org.sakaiproject.search.journal.impl.IndexListenerCloser;
import org.sakaiproject.search.journal.impl.IndexManagementTimerTask;

public class ConcurrentIndexManager
implements IndexListener {
    protected static final Log log = LogFactory.getLog(ConcurrentIndexManager.class);
    private Timer timer = new Timer("IndexManager", true);
    private List<IndexManagementTimerTask> tasks;
    private int nsopen = 0;
    private int nropen = 0;
    private SearchService searchService;
    private IndexListenerCloser indexListenerCloser;
    private static ThreadLocal<ManagementOperation> runningOperation = new ThreadLocal();

    public void init() {
        if (!this.searchService.isEnabled()) {
            return;
        }
        for (IndexManagementTimerTask task : this.tasks) {
            if (task.isFixedRate()) {
                this.timer.scheduleAtFixedRate((TimerTask)task, task.getDelay(), task.getPeriod());
                continue;
            }
            this.timer.schedule((TimerTask)task, task.getDelay(), task.getPeriod());
        }
        if (this.indexListenerCloser == null) {
            this.indexListenerCloser = new IndexListenerCloser();
        }
        this.timer.schedule(new TimerTask(){

            @Override
            public void run() {
                log.debug((Object)("Start Purge ------------------------- " + ConcurrentIndexManager.this.indexListenerCloser.size()));
                ConcurrentIndexManager.this.indexListenerCloser.purge();
                log.debug((Object)("Purge complete ----------------------" + ConcurrentIndexManager.this.indexListenerCloser.size()));
            }
        }, 5000L, 15000L);
    }

    public void destroy() {
        this.close();
        this.cleanup();
    }

    public void close() {
        this.timer.cancel();
        for (IndexManagementTimerTask itt : this.tasks) {
            itt.setClosed(true);
        }
    }

    public void cleanup() {
        this.indexListenerCloser.cleanup();
        log.debug((Object)("N Searchers is " + this.nsopen));
        log.debug((Object)("N Readers is " + this.nropen));
    }

    public List<IndexManagementTimerTask> getTasks() {
        return this.tasks;
    }

    public void setTasks(List<IndexManagementTimerTask> tasks) {
        this.tasks = tasks;
    }

    @Override
    public void doIndexReaderClose(IndexReader oldMultiReader) throws IOException {
        --this.nropen;
        log.debug((Object)("Closed Reader " + this.nropen + " " + oldMultiReader));
        this.indexListenerCloser.doIndexReaderClose(oldMultiReader);
    }

    @Override
    public void doIndexSearcherClose(IndexSearcher indexSearcher) throws IOException {
        --this.nsopen;
        log.debug((Object)("Closed Searcher " + this.nsopen + " " + indexSearcher));
        this.indexListenerCloser.doIndexSearcherClose(indexSearcher);
    }

    @Override
    public void doIndexSearcherOpen(IndexSearcher indexSearcher) {
        ++this.nsopen;
        log.debug((Object)(this + "Opened New Searcher " + this.nsopen + " " + indexSearcher));
        this.indexListenerCloser.doIndexSearcherOpen(indexSearcher);
    }

    @Override
    public void doIndexReaderOpen(IndexReader newMultiReader) {
        ++this.nropen;
        log.debug((Object)("Opened New Reader " + this.nropen + " " + newMultiReader));
        this.indexListenerCloser.doIndexReaderOpen(newMultiReader);
    }

    public SearchService getSearchService() {
        return this.searchService;
    }

    public void setSearchService(SearchService searchService) {
        this.searchService = searchService;
    }

    public IndexListenerCloser getIndexListenerCloser() {
        return this.indexListenerCloser;
    }

    public void setIndexListenerCloser(IndexListenerCloser indexListenerCloser) {
        this.indexListenerCloser = indexListenerCloser;
    }

    public static void setRunning(ManagementOperation managementOperation) {
        runningOperation.set(managementOperation);
    }

    public static ManagementOperation getCurrentManagementOperation() {
        return runningOperation.get();
    }
}

