/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.search.journal.impl;

import java.util.TimerTask;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sakaiproject.search.journal.api.ManagementOperation;
import org.sakaiproject.search.journal.impl.ConcurrentIndexManager;
import org.sakaiproject.thread_local.api.ThreadLocalManager;

public class IndexManagementTimerTask
extends TimerTask {
    private static final Log log = LogFactory.getLog(IndexManagementTimerTask.class);
    private long delay = 60000L;
    private long period = 60000L;
    private boolean fixedRate = false;
    private ManagementOperation managementOperation;
    private boolean closed = false;
    private ThreadLocalManager threadLocalManager;

    public void init() {
    }

    public void destroy() {
        this.closed = true;
    }

    public long getDelay() {
        return this.delay;
    }

    public long getPeriod() {
        return this.period;
    }

    public void setDelay(long delay) {
        this.delay = delay;
    }

    public void setPeriod(long period) {
        this.period = period;
    }

    public boolean isFixedRate() {
        return this.fixedRate;
    }

    public void setFixedRate(boolean fixedRate) {
        this.fixedRate = fixedRate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (this.closed) {
            return;
        }
        try {
            ConcurrentIndexManager.setRunning(this.managementOperation);
            this.threadLocalManager.clear();
            this.managementOperation.runOnce();
            this.threadLocalManager.clear();
        }
        catch (Throwable t) {
            log.error((Object)"Management Operation failed ", t);
        }
        finally {
            ConcurrentIndexManager.setRunning(null);
        }
    }

    public ManagementOperation getManagementOperation() {
        return this.managementOperation;
    }

    public void setManagementOperation(ManagementOperation managementOperation) {
        this.managementOperation = managementOperation;
    }

    public boolean isClosed() {
        return this.closed;
    }

    public void setClosed(boolean closed) {
        this.closed = closed;
    }

    public ThreadLocalManager getThreadLocalManager() {
        return this.threadLocalManager;
    }

    public void setThreadLocalManager(ThreadLocalManager threadLocalManager) {
        this.threadLocalManager = threadLocalManager;
    }
}

