/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.search.optimize.impl;

import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.lucene.analysis.Analyzer;
import org.sakaiproject.search.index.AnalyzerFactory;
import org.sakaiproject.search.journal.impl.JournalSettings;
import org.sakaiproject.search.optimize.api.OptimizeTransactionListener;
import org.sakaiproject.search.optimize.impl.IndexOptimizeTransactionImpl;
import org.sakaiproject.search.transaction.api.IndexTransaction;
import org.sakaiproject.search.transaction.api.IndexTransactionException;
import org.sakaiproject.search.transaction.api.TransactionListener;
import org.sakaiproject.search.transaction.impl.TransactionManagerImpl;

public class OptimizeIndexManager
extends TransactionManagerImpl {
    private static final String TEMP_INDEX_NAME = "optimizetx-";
    private AnalyzerFactory analyzerFactory = null;
    private JournalSettings journalSettings;

    @Override
    public void init() {
    }

    @Override
    public void destroy() {
    }

    @Override
    public IndexTransaction openTransaction(Map<String, Object> m) throws IndexTransactionException {
        IndexOptimizeTransactionImpl it = new IndexOptimizeTransactionImpl(this, this.journalSettings, m);
        it.open();
        return it;
    }

    @Override
    public void addTransactionListener(TransactionListener transactionListener) {
        if (!(transactionListener instanceof OptimizeTransactionListener)) {
            throw new RuntimeException("transactionListener must implement OptimizeTransactionListener " + transactionListener);
        }
        super.addTransactionListener(transactionListener);
    }

    @Override
    public void setTransactionListeners(List<TransactionListener> transactionListeners) {
        for (TransactionListener tl : transactionListeners) {
            if (tl instanceof OptimizeTransactionListener) continue;
            throw new RuntimeException("transactionListener must implement OptimizeTransactionListener " + tl);
        }
        super.setTransactionListeners(transactionListeners);
    }

    protected File getTemporarySegment(long txid) throws IOException {
        File f = null;
        f = new File(this.journalSettings.getOptimizerWorkingDirectory(), TEMP_INDEX_NAME + txid);
        if (f.exists()) {
            throw new IOException("Failed to create index transaction working space ");
        }
        if (!f.mkdirs()) {
            throw new IOException("Failed to create index transaction working space ");
        }
        return f;
    }

    public AnalyzerFactory getAnalyzerFactory() {
        return this.analyzerFactory;
    }

    public void setAnalyzerFactory(AnalyzerFactory analyzerFactory) {
        this.analyzerFactory = analyzerFactory;
    }

    public Analyzer getAnalyzer() {
        return this.analyzerFactory.newAnalyzer();
    }

    public JournalSettings getJournalSettings() {
        return this.journalSettings;
    }

    public void setJournalSettings(JournalSettings journalSettings) {
        this.journalSettings = journalSettings;
    }
}

