/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.search.optimize.shared.impl;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sakaiproject.cluster.api.ClusterService;
import org.sakaiproject.component.api.ServerConfigurationService;
import org.sakaiproject.search.indexer.api.IndexJournalException;
import org.sakaiproject.search.indexer.api.LockTimeoutException;
import org.sakaiproject.search.journal.api.JournalErrorException;
import org.sakaiproject.search.journal.api.JournalManager;
import org.sakaiproject.search.journal.api.JournalManagerState;
import org.sakaiproject.search.journal.impl.JournalSettings;
import org.sakaiproject.search.optimize.api.NoOptimizationRequiredException;
import org.sakaiproject.search.optimize.shared.impl.OptimizeJournalManagerStateImpl;
import org.sakaiproject.search.transaction.api.IndexTransaction;

public class DbJournalOptimizationManager
implements JournalManager {
    private static final Log log = LogFactory.getLog(DbJournalOptimizationManager.class);
    private DataSource datasource;
    private ClusterService clusterService;
    private String serverId;
    private JournalSettings journalSettings;
    private ServerConfigurationService serverConfigurationService;

    public void destroy() {
    }

    public void init() {
        this.serverId = this.serverConfigurationService.getServerId();
    }

    @Override
    public void commitSave(JournalManagerState jms) throws IndexJournalException {
        OptimizeJournalManagerStateImpl ojms = (OptimizeJournalManagerStateImpl)jms;
        Statement success = null;
        Statement updateTarget = null;
        Connection connection = null;
        try {
            System.err.println("+++++++++++++++++++++COMMIT+++++++++++++++");
            connection = this.datasource.getConnection();
            updateTarget = connection.prepareStatement("update search_journal set status = 'committed', txts = ? where txid = ?  ");
            updateTarget.clearParameters();
            updateTarget.setLong(1, System.currentTimeMillis());
            updateTarget.setLong(2, ojms.oldestSavePoint);
            int i = updateTarget.executeUpdate();
            success = connection.prepareStatement("delete from search_journal where indexwriter = ? and status = 'merging-prepare'  ");
            success.clearParameters();
            success.setString(1, ojms.indexWriter);
            success.executeUpdate();
            connection.commit();
            log.info((Object)("Shared Journal Mege Committed into SavePoint " + ojms.oldestSavePoint));
        }
        catch (Exception ex) {
            try {
                connection.rollback();
            }
            catch (Exception ex2) {
                log.debug((Object)ex2);
            }
            throw new IndexJournalException("Failed to commit index ", ex);
        }
        finally {
            try {
                updateTarget.close();
            }
            catch (Exception ex) {
                log.debug((Object)ex);
            }
            try {
                success.close();
            }
            catch (Exception ex) {
                log.debug((Object)ex);
            }
            try {
                connection.close();
            }
            catch (Exception ex) {
                log.debug((Object)ex);
            }
        }
    }

    @Override
    public long getNextSavePoint(long savePoint) throws JournalErrorException {
        return 0L;
    }

    @Override
    public JournalManagerState prepareSave(long transactionId) throws IndexJournalException {
        PreparedStatement getJournalSavePointPst = null;
        PreparedStatement getEarlierSavePoint = null;
        Statement getEarlierSavePoint2 = null;
        Statement lockEarlierSavePoints = null;
        Statement listMergeSet = null;
        Statement listJournal = null;
        OptimizeJournalManagerStateImpl jms = new OptimizeJournalManagerStateImpl();
        ResultSet rs = null;
        Connection connection = null;
        try {
            connection = this.datasource.getConnection();
            getJournalSavePointPst = connection.prepareStatement("select serverid, jid from search_node_status order by jid asc ");
            getEarlierSavePoint = connection.prepareStatement("select serverid, jid from search_node_status order by jid asc ");
            jms.indexWriter = this.serverId + ":" + transactionId;
            jms.transactionId = transactionId;
            jms.oldestSavePoint = 0L;
            List servers = this.clusterService.getServers();
            getJournalSavePointPst.clearParameters();
            rs = getJournalSavePointPst.executeQuery();
            long oldestActiveSavepoint = 0L;
            block44: while (oldestActiveSavepoint == 0L && rs.next()) {
                String server = rs.getString(1);
                log.debug((Object)("Got Server " + server + " with savePoint " + rs.getLong(2)));
                for (String s : servers) {
                    int dash = s.lastIndexOf(45);
                    if (dash > 0) {
                        s = s.substring(0, dash);
                    }
                    if (server.equals(s)) {
                        oldestActiveSavepoint = rs.getLong(2);
                        log.debug((Object)("\tMatch against " + s));
                        continue block44;
                    }
                    log.debug((Object)("No Match against " + s));
                }
            }
            rs.close();
            getEarlierSavePoint2 = connection.prepareStatement("select min(txid),max(txid) from search_journal where txid < ? and  (status = 'commited' or status = 'committed') ");
            getEarlierSavePoint2.clearParameters();
            getEarlierSavePoint2.setLong(1, oldestActiveSavepoint);
            rs = getEarlierSavePoint2.executeQuery();
            jms.oldestSavePoint = 0L;
            long earliestSavePoint = 0L;
            if (rs.next()) {
                earliestSavePoint = rs.getLong(1);
                jms.oldestSavePoint = rs.getLong(2);
            }
            if (jms.oldestSavePoint <= 0L) {
                throw new NoOptimizationRequiredException("Oldest savePoint is 0");
            }
            rs.close();
            long nshared = jms.oldestSavePoint - earliestSavePoint;
            if (nshared < (long)this.journalSettings.getMinimumOptimizeSavePoints()) {
                throw new NoOptimizationRequiredException("Insuficient Journal Entries prior to savepoint " + jms.oldestSavePoint + " to optimize, found " + nshared);
            }
            if (nshared > (long)(2 * this.journalSettings.getMinimumOptimizeSavePoints())) {
                jms.oldestSavePoint = earliestSavePoint + (long)(2 * this.journalSettings.getMinimumOptimizeSavePoints());
                getEarlierSavePoint2.setLong(1, jms.oldestSavePoint);
                rs = getEarlierSavePoint2.executeQuery();
                jms.oldestSavePoint = 0L;
                earliestSavePoint = 0L;
                if (rs.next()) {
                    earliestSavePoint = rs.getLong(1);
                    jms.oldestSavePoint = rs.getLong(2);
                }
                if (jms.oldestSavePoint <= 0L) {
                    throw new NoOptimizationRequiredException("Oldest savePoint is 0");
                }
                rs.close();
            }
            log.debug((Object)("Optimizing shared Journal Storage to savepoint " + jms.oldestSavePoint));
            lockEarlierSavePoints = connection.prepareStatement("update search_journal set indexwriter = ?, status = 'merging-prepare', txts = ? where txid <= ? and  (status = 'commited' or status = 'committed' ) ");
            lockEarlierSavePoints.clearParameters();
            lockEarlierSavePoints.setString(1, jms.indexWriter);
            lockEarlierSavePoints.setLong(2, System.currentTimeMillis());
            lockEarlierSavePoints.setLong(3, jms.oldestSavePoint);
            int i = 0;
            try {
                i = lockEarlierSavePoints.executeUpdate();
            }
            catch (SQLException lockTimepout) {
                throw new LockTimeoutException(lockTimepout.getMessage(), lockTimepout);
            }
            listJournal = connection.prepareStatement("select txid, indexwriter, status, txts  from search_journal");
            if (log.isDebugEnabled()) {
                listJournal.clearParameters();
                rs = listJournal.executeQuery();
                while (rs.next()) {
                    log.debug((Object)("TX[" + rs.getLong(1) + "];indexwriter[" + rs.getString(2) + "];status[" + rs.getString(3) + "];timestamp[" + rs.getLong(4) + "]"));
                }
                rs.close();
            }
            if (i < this.journalSettings.getMinimumOptimizeSavePoints()) {
                throw new NoOptimizationRequiredException("Insuficient Journal Entries prior to savepoint " + jms.oldestSavePoint + " to optimize, found " + i);
            }
            log.info((Object)("Locked " + i + " savePoints "));
            listJournal.clearParameters();
            rs = listJournal.executeQuery();
            while (rs.next()) {
                log.info((Object)("TX[" + rs.getLong(1) + "];indexwriter[" + rs.getString(2) + "];status[" + rs.getString(3) + "];timestamp[" + rs.getLong(4) + "]"));
            }
            rs.close();
            jms.mergeList = new ArrayList();
            listMergeSet = connection.prepareStatement("select txid from search_journal where indexwriter = ?  order by txid asc ");
            listMergeSet.clearParameters();
            listMergeSet.setString(1, jms.indexWriter);
            rs = listMergeSet.executeQuery();
            while (rs.next()) {
                jms.mergeList.add(rs.getLong(1));
            }
            log.info((Object)("Retrieved " + jms.mergeList.size() + " locked savePoints "));
            connection.commit();
        }
        catch (IndexJournalException ijex) {
            try {
                connection.rollback();
            }
            catch (Exception ex2) {
                log.debug((Object)ex2);
            }
            throw ijex;
        }
        catch (Exception ex) {
            try {
                connection.rollback();
            }
            catch (Exception ex2) {
                log.debug((Object)ex);
            }
            if (ex instanceof LockTimeoutException) {
                throw (LockTimeoutException)ex;
            }
            throw new IndexJournalException("Failed to lock savePoints to this node ", ex);
        }
        finally {
            try {
                rs.close();
            }
            catch (Exception ex) {
                log.debug((Object)ex);
            }
            try {
                getJournalSavePointPst.close();
            }
            catch (Exception ex) {
                log.debug((Object)ex);
            }
            try {
                getEarlierSavePoint.close();
            }
            catch (Exception ex) {
                log.debug((Object)ex);
            }
            try {
                getEarlierSavePoint2.close();
            }
            catch (Exception ex) {
                log.debug((Object)ex);
            }
            try {
                if (lockEarlierSavePoints != null) {
                    lockEarlierSavePoints.close();
                }
            }
            catch (Exception ex) {
                log.debug((Object)ex);
            }
            try {
                if (listJournal != null) {
                    listJournal.close();
                }
            }
            catch (Exception ex) {
                log.debug((Object)ex);
            }
            try {
                if (listMergeSet != null) {
                    listMergeSet.close();
                }
            }
            catch (Exception ex) {
                log.debug((Object)ex);
            }
            try {
                connection.close();
            }
            catch (Exception ex2) {
                log.debug((Object)ex2);
            }
        }
        return jms;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rollbackSave(JournalManagerState jms) {
        OptimizeJournalManagerStateImpl ojms = (OptimizeJournalManagerStateImpl)jms;
        Statement updateTarget = null;
        Connection connection = null;
        try {
            connection = this.datasource.getConnection();
            updateTarget = connection.prepareStatement("update search_journal set status = 'committed', txts = ? where indexwriter = ? and status = 'merging-prepare'  ");
            updateTarget.clearParameters();
            updateTarget.setLong(1, System.currentTimeMillis());
            updateTarget.setString(2, ojms.indexWriter);
            int i = updateTarget.executeUpdate();
            connection.commit();
            log.info((Object)"Rolled Back Failed Shared Index operation a retry will happen on annother node soon ");
        }
        catch (Exception ex) {
            try {
                connection.rollback();
            }
            catch (Exception ex2) {
                log.error((Object)"Rollback Of shared Journal Merge Failed ", (Throwable)ex);
            }
        }
        finally {
            try {
                updateTarget.close();
            }
            catch (Exception ex) {
                log.debug((Object)ex);
            }
            try {
                connection.close();
            }
            catch (Exception ex) {
                log.debug((Object)ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doOpenTransaction(IndexTransaction transaction) throws IndexJournalException {
        Statement countJournals = null;
        Connection connection = null;
        ResultSet rs = null;
        try {
            connection = this.datasource.getConnection();
            countJournals = connection.createStatement();
            long nSavePoints = 0L;
            HashMap<String, String> mergingMap = new HashMap<String, String>();
            long transactionId = transaction.getTransactionId();
            String thisWriter = this.serverId + ":" + transactionId;
            try {
                rs = countJournals.executeQuery("select txid, indexwriter, status, txts  from search_journal");
                while (rs.next()) {
                    long txid = rs.getLong(1);
                    String indexwriter = rs.getString(2);
                    String status = rs.getString(3);
                    long ts = rs.getLong(4);
                    if ("merging-prepare".equals(status)) {
                        mergingMap.put(indexwriter, indexwriter);
                        continue;
                    }
                    if (!"commited".equals(status) && !"committed".equals(status)) continue;
                    ++nSavePoints;
                }
                rs.close();
            }
            catch (Exception ex) {
                log.info((Object)"Optimzation of central journal is in progress on annother node, no optimization possible on this node ");
            }
            if (mergingMap.size() > 1) {
                StringBuilder sb = new StringBuilder();
                sb.append("\tMore than One shares segments merge appears to be active in the \n");
                sb.append("\tcluster, you Must investigate the search_journal table\n");
                sb.append("\tA list of index Writers Follows\n\t===================\n");
                for (String iw : mergingMap.values()) {
                    sb.append("\t").append(iw);
                    if (iw.equals(thisWriter)) {
                        sb.append("\tThis node is currently optimizing the shared segments,");
                        sb.append("\tThis is an error as only one copy of this node should be ");
                        sb.append("\tActive in the cluster");
                        sb.append("see http://jira.sakaiproject.org/browse/SRCH-38");
                        continue;
                    }
                    if (!iw.startsWith(this.serverId)) continue;
                    sb.append("\tThis node is currently optimizing the shared segments,");
                    sb.append("\tThis is an error as only one copy of this node should be ");
                    sb.append("\tActive in the cluster");
                    sb.append("see http://jira.sakaiproject.org/browse/SRCH-38");
                }
                sb.append("\t==========================\n");
                log.error((Object)sb.toString());
                throw new NoOptimizationRequiredException("Merge already in progress, possible error");
            }
            if (mergingMap.size() == 1) {
                StringBuilder sb = new StringBuilder();
                for (String iw : mergingMap.values()) {
                    if (iw.equals(thisWriter)) {
                        sb.append("This node already merging shared segments, index writer " + iw);
                        sb.append("\tThis node is currently optimizing the shared segments,");
                        sb.append("\tThis is an error as only one copy of this node should be ");
                        sb.append("\tActive in the cluster");
                        sb.append("see http://jira.sakaiproject.org/browse/SRCH-38");
                        continue;
                    }
                    if (!iw.startsWith(this.serverId)) continue;
                    sb.append("This node already merging shared segments, index writer " + iw);
                    sb.append("\tThis node is currently optimizing the shared segments,");
                    sb.append("\tThis is an error as only one copy of this node should be ");
                    sb.append("\tActive in the cluster");
                    sb.append("see http://jira.sakaiproject.org/browse/SRCH-38");
                }
                if (sb.length() == 0) {
                    log.info((Object)"There is annother node performing shared index merge, this node will continue with other operations ");
                    throw new NoOptimizationRequiredException("Merge already in progress, normal");
                }
                log.error((Object)sb.toString());
                throw new NoOptimizationRequiredException("Merge already in progress, possible error");
            }
            if (nSavePoints < (long)this.journalSettings.getMinimumOptimizeSavePoints()) {
                throw new NoOptimizationRequiredException("Insufficient items to optimze");
            }
        }
        catch (NoOptimizationRequiredException nop) {
            throw nop;
        }
        catch (Exception ex) {
            log.warn((Object)"Failed to count available journals for optimization ", (Throwable)ex);
        }
        finally {
            try {
                rs.close();
            }
            catch (Exception ex) {
                log.debug((Object)ex);
            }
            try {
                countJournals.close();
            }
            catch (Exception ex) {
                log.debug((Object)ex);
            }
            try {
                connection.close();
            }
            catch (Exception ex) {
                log.debug((Object)ex);
            }
        }
    }

    public ClusterService getClusterService() {
        return this.clusterService;
    }

    public void setClusterService(ClusterService clusterService) {
        this.clusterService = clusterService;
    }

    public DataSource getDatasource() {
        return this.datasource;
    }

    public void setDatasource(DataSource datasource) {
        this.datasource = datasource;
    }

    public ServerConfigurationService getServerConfigurationService() {
        return this.serverConfigurationService;
    }

    public void setServerConfigurationService(ServerConfigurationService serverConfigurationService) {
        this.serverConfigurationService = serverConfigurationService;
    }

    public JournalSettings getJournalSettings() {
        return this.journalSettings;
    }

    public void setJournalSettings(JournalSettings journalSettings) {
        this.journalSettings = journalSettings;
    }
}

