/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.search.index.impl;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.sakaiproject.search.api.SearchService;
import org.sakaiproject.search.index.ClusterFilesystem;
import org.sakaiproject.search.index.SegmentInfo;
import org.sakaiproject.search.index.impl.ClusterSegmentsStorage;
import org.sakaiproject.search.index.impl.SegmentInfoImpl;

public class JDBCClusterIndexStore
implements ClusterFilesystem {
    private static final Log log = LogFactory.getLog(JDBCClusterIndexStore.class);
    private DataSource dataSource = null;
    private String searchIndexDirectory = null;
    private static final String TEMP_INDEX_NAME = "tempindex";
    private static final String INDEX_PATCHNAME = "indexpatch";
    private static final long MAX_BLOCK_SIZE = 0xA00000L;
    private boolean autoDdl = false;
    private boolean parallelIndex = false;
    private boolean validate = false;
    private String sharedSegments = null;
    private boolean debug = false;
    private boolean localStructuredStorage = false;
    private boolean sharedStructuredStorage = false;
    private ClusterSegmentsStorage clusterStorage = null;
    private boolean localSegmentsOnly = false;
    private SearchService searchService;

    public void init() {
        try {
            log.info((Object)(this + ":init() "));
            this.clusterStorage = new ClusterSegmentsStorage(this.searchService, this.searchIndexDirectory, this, this.localStructuredStorage, this.debug);
            try {
                this.migrateLocalSegments();
                this.migrateSharedSegments();
            }
            catch (IOException ex) {
                log.error((Object)"Failed to migrate search content to new format, the instance should not continue to run ", (Throwable)ex);
                System.exit(-1);
            }
            log.info((Object)(this + ":init() Ok "));
        }
        catch (Exception ex) {
            log.error((Object)"Failed to start Cluster Index store", (Throwable)ex);
            System.exit(-1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<SegmentInfo> updateSegments() {
        Connection connection = null;
        ArrayList<SegmentInfo> segmentList = new ArrayList<SegmentInfo>();
        try {
            String name;
            boolean found;
            connection = this.dataSource.getConnection();
            List<SegmentInfo> dbSegments = this.getDBSegments(connection);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Update: DB Segments = " + dbSegments.size()));
            }
            List<SegmentInfo> localSegments = this.getLocalSegments();
            List<SegmentInfo> badLocalSegments = this.getBadLocalSegments();
            this.deleteAllSegments(badLocalSegments);
            List<SegmentInfo> deletedSegments = this.getDeletedLocalSegments();
            this.deleteAllSegments(deletedSegments);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Update: Local Segments = " + localSegments.size()));
            }
            ArrayList<SegmentInfo> updateLocalSegments = new ArrayList<SegmentInfo>();
            for (SegmentInfo db_si : dbSegments) {
                found = false;
                name = db_si.getName();
                for (SegmentInfo local_si : localSegments) {
                    if (!name.equals(local_si.getName())) continue;
                    found = true;
                    break;
                }
                if (!found) {
                    updateLocalSegments.add(db_si);
                    if (!log.isDebugEnabled()) continue;
                    log.debug((Object)("Missing Will update " + db_si));
                    continue;
                }
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("Present Will Not update " + db_si));
            }
            for (SegmentInfo current_si : localSegments) {
                found = false;
                name = current_si.getName();
                long version = current_si.getVersion();
                for (SegmentInfo db_si : dbSegments) {
                    if (!name.equals(db_si.getName()) || db_si.getVersion() <= version) continue;
                    updateLocalSegments.add(db_si);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Newer will Update " + db_si));
                    }
                    found = true;
                    break;
                }
                if (found || !log.isDebugEnabled()) continue;
                log.debug((Object)("Ok will not update " + current_si));
            }
            ArrayList<SegmentInfo> removeLocalSegments = new ArrayList<SegmentInfo>();
            for (SegmentInfo local_si : localSegments) {
                if (!local_si.isCreated()) continue;
                boolean found2 = false;
                String name2 = local_si.getName();
                for (SegmentInfo db_si : dbSegments) {
                    if (!name2.equals(db_si.getName())) continue;
                    found2 = true;
                    break;
                }
                if (!found2) {
                    removeLocalSegments.add(local_si);
                    if (!log.isDebugEnabled()) continue;
                    log.debug((Object)("Will remove " + local_si));
                    continue;
                }
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("Ok Will not remove " + local_si));
            }
            for (SegmentInfo rmsi : removeLocalSegments) {
                this.removeLocalSegment(rmsi);
            }
            try {
                for (SegmentInfo addsi : updateLocalSegments) {
                    addsi.lockLocalSegment();
                }
                for (SegmentInfo addsi : updateLocalSegments) {
                    try {
                        if (addsi.isLocalLock()) {
                            this.updateLocalSegment(connection, addsi);
                            continue;
                        }
                        log.warn((Object)("Not Updating Segment, since lock is not on this thread " + addsi.getName()));
                    }
                    catch (Exception ex) {
                        log.info((Object)("Segment was not unpacked " + ex.getClass().getName() + ":" + ex.getMessage()));
                    }
                }
            }
            catch (Throwable throwable) {
                for (SegmentInfo addsi : updateLocalSegments) {
                    addsi.unlockLocalSegment();
                }
                throw throwable;
            }
            for (SegmentInfo addsi : updateLocalSegments) {
                addsi.unlockLocalSegment();
            }
            if (updateLocalSegments.size() > 0) {
                this.updateLocalPatch(connection);
            }
            for (SegmentInfo si : dbSegments) {
                File f = si.getSegmentLocation();
                if (f.exists()) {
                    segmentList.add(si);
                }
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("Segment Present at " + f.getName()));
            }
            connection.commit();
        }
        catch (Exception sqle) {
            log.error((Object)"Failed to update segments ", (Throwable)sqle);
            try {
                connection.rollback();
            }
            catch (Exception ex) {
                log.debug((Object)ex);
            }
        }
        finally {
            try {
                connection.close();
            }
            catch (Exception e) {
                log.debug((Object)e);
            }
        }
        return segmentList;
    }

    private void deleteAllSegments(List<SegmentInfo> badLocalSegments) {
        for (SegmentInfo s : badLocalSegments) {
            s.doFinalDelete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<SegmentInfo> saveSegments() {
        Connection connection = null;
        ArrayList<SegmentInfo> segmentList = new ArrayList<SegmentInfo>();
        try {
            String name;
            connection = this.dataSource.getConnection();
            List<SegmentInfo> dbSegments = this.getDBSegments(connection);
            List<SegmentInfo> localSegments = this.getLocalSegments();
            List<SegmentInfo> badLocalSegments = this.getBadLocalSegments();
            ArrayList<SegmentInfo> removeDBSegments = new ArrayList<SegmentInfo>();
            ArrayList<SegmentInfo> currentDBSegments = new ArrayList<SegmentInfo>();
            for (SegmentInfo db_si : dbSegments) {
                boolean found = false;
                String name2 = db_si.getName();
                for (SegmentInfo local_si : localSegments) {
                    if (!name2.equals(local_si.getName())) continue;
                    found = true;
                    break;
                }
                if (!found) {
                    for (SegmentInfo local_file : badLocalSegments) {
                        if (!name2.equals(local_file.getName())) continue;
                        found = true;
                        break;
                    }
                }
                if (!found) {
                    removeDBSegments.add(db_si);
                    if (!log.isDebugEnabled()) continue;
                    log.debug((Object)("Will remove from the DB " + db_si));
                    continue;
                }
                currentDBSegments.add(db_si);
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("In the DB will not remove " + db_si));
            }
            ArrayList<SegmentInfo> updateDBSegments = new ArrayList<SegmentInfo>();
            for (SegmentInfo local_si : localSegments) {
                boolean found = false;
                name = local_si.getName();
                for (SegmentInfo db_si : dbSegments) {
                    if (!name.equals(db_si.getName())) continue;
                    found = true;
                    break;
                }
                if (!found) {
                    updateDBSegments.add(local_si);
                    if (!log.isDebugEnabled()) continue;
                    log.debug((Object)(" Will update to the DB " + local_si));
                    continue;
                }
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)(" Will NOT update to the DB " + local_si));
            }
            for (SegmentInfo local_si : localSegments) {
                boolean found = false;
                name = local_si.getName();
                long version = local_si.getVersion();
                for (SegmentInfo db_si : dbSegments) {
                    if (!name.equals(db_si.getName()) || version <= db_si.getVersion()) continue;
                    updateDBSegments.add(db_si);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Will update modified to the DB " + db_si));
                    }
                    found = true;
                    break;
                }
                if (found || !log.isDebugEnabled()) continue;
                log.debug((Object)("Will not update the DB, matches " + local_si));
            }
            for (SegmentInfo addsi : updateDBSegments) {
                this.updateDBSegment(connection, addsi);
            }
            this.updateDBPatch(connection);
            for (SegmentInfo si : updateDBSegments) {
                File f = si.getSegmentLocation();
                segmentList.add(si);
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("Segments saved " + f.getName()));
            }
            for (SegmentInfo rmsi : removeDBSegments) {
                this.removeDBSegment(connection, rmsi);
            }
            connection.commit();
            this.deleteAllSegments(badLocalSegments);
        }
        catch (Exception ex) {
            log.error((Object)"Failed to Save Segments back to Central Storage", (Throwable)ex);
            try {
                connection.rollback();
            }
            catch (Exception e) {
                log.debug((Object)e);
            }
            this.recoverFromFailure();
        }
        finally {
            try {
                connection.close();
            }
            catch (Exception e) {
                log.debug((Object)e);
            }
        }
        return segmentList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<SegmentInfo> saveAllSegments() {
        Connection connection = null;
        ArrayList<SegmentInfo> segmentList = new ArrayList<SegmentInfo>();
        try {
            connection = this.dataSource.getConnection();
            List<SegmentInfo> dbSegments = this.getDBSegments(connection);
            List<SegmentInfo> localSegments = this.getLocalSegments();
            List<SegmentInfo> badLocalSegments = this.getBadLocalSegments();
            ArrayList<SegmentInfo> updateDBSegments = new ArrayList<SegmentInfo>();
            for (SegmentInfo local_si : localSegments) {
                boolean found = false;
                String name = local_si.getName();
                for (SegmentInfo db_si : dbSegments) {
                    if (!name.equals(db_si.getName())) continue;
                    found = true;
                    break;
                }
                if (!found) {
                    for (SegmentInfo local_file : badLocalSegments) {
                        if (!name.equals(local_file.getName())) continue;
                        found = true;
                        break;
                    }
                }
                if (found) continue;
                updateDBSegments.add(local_si);
            }
            block16: for (SegmentInfo local_si : localSegments) {
                String name = local_si.getName();
                for (SegmentInfo db_si : dbSegments) {
                    if (!name.equals(db_si.getName())) continue;
                    updateDBSegments.add(db_si);
                    continue block16;
                }
            }
            for (SegmentInfo addsi : updateDBSegments) {
                this.updateDBSegment(connection, addsi);
            }
            for (SegmentInfo si : updateDBSegments) {
                segmentList.add(si);
            }
            connection.commit();
            this.deleteAllSegments(badLocalSegments);
        }
        catch (Exception ex) {
            log.error((Object)"Failed to Save Segments back to Central Storage", (Throwable)ex);
            try {
                connection.rollback();
            }
            catch (Exception e) {
                log.debug((Object)e);
            }
            this.recoverFromFailure();
        }
        finally {
            try {
                connection.close();
            }
            catch (Exception e) {
                log.debug((Object)e);
            }
        }
        return segmentList;
    }

    protected void updateLocalSegment(Connection connection, SegmentInfo addsi) throws SQLException, IOException {
        if (this.searchService.hasDiagnostics()) {
            log.info((Object)("\tUpdate Local Segment from Database " + addsi));
        }
        if (this.localSegmentsOnly) {
            log.warn((Object)("Update Local Segment Requested with inactive Shared Storage " + addsi));
        } else if (this.sharedSegments == null || this.sharedSegments.length() == 0) {
            this.updateLocalSegmentBLOB(connection, addsi);
        } else {
            this.updateLocalSegmentFilesystem(connection, addsi);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateLocalSegmentBLOB(Connection connection, SegmentInfo addsi) throws SQLException, IOException {
        block21: {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Updating local segment from databse " + addsi));
            }
            PreparedStatement segmentSelect = null;
            ResultSet resultSet = null;
            try {
                segmentSelect = connection.prepareStatement("select version_, packet_ from search_segments where name_ = ?");
                segmentSelect.clearParameters();
                segmentSelect.setString(1, addsi.getName());
                resultSet = segmentSelect.executeQuery();
                if (resultSet.next()) {
                    InputStream packetStream = null;
                    try {
                        long version = resultSet.getLong(1);
                        packetStream = resultSet.getBinaryStream(2);
                        this.clusterStorage.unpackSegment(addsi, packetStream, version);
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Updated Packet from DB to versiob " + version));
                        }
                        break block21;
                    }
                    finally {
                        try {
                            packetStream.close();
                        }
                        catch (Exception ex) {
                            log.debug((Object)ex);
                        }
                    }
                }
                log.error((Object)"Didnt find segment in database");
            }
            finally {
                try {
                    resultSet.close();
                }
                catch (Exception ex) {
                    log.debug((Object)ex);
                }
                try {
                    segmentSelect.close();
                }
                catch (Exception ex) {
                    log.debug((Object)ex);
                }
            }
        }
    }

    @Override
    public void removeLocalSegment(SegmentInfo rmsi) {
        rmsi.setDeleted();
        if (this.searchService.hasDiagnostics()) {
            log.info((Object)("\tMarked Local Segment for deletion " + rmsi));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<SegmentInfo> getDBSegments(Connection connection) throws SQLException {
        PreparedStatement segmentAllSelect = null;
        ResultSet resultSet = null;
        ArrayList<SegmentInfo> dbsegments = new ArrayList<SegmentInfo>();
        try {
            segmentAllSelect = connection.prepareStatement("select version_, name_ from search_segments where name_ <> ? ");
            segmentAllSelect.clearParameters();
            segmentAllSelect.setString(1, INDEX_PATCHNAME);
            resultSet = segmentAllSelect.executeQuery();
            while (resultSet.next()) {
                long version = resultSet.getLong(1);
                String name = resultSet.getString(2);
                SegmentInfo si = SegmentInfoImpl.newSharedSegmentInfo(name, version, this.localStructuredStorage, this.searchIndexDirectory);
                dbsegments.add(si);
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("DB Segment " + si));
            }
        }
        finally {
            try {
                resultSet.close();
            }
            catch (Exception ex) {
                log.debug((Object)ex);
            }
            try {
                segmentAllSelect.close();
            }
            catch (Exception ex) {
                log.debug((Object)ex);
            }
        }
        return dbsegments;
    }

    protected void updateDBPatch(Connection connection) throws SQLException, IOException {
        if (this.localSegmentsOnly) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Update Patch Requested with inactive Shared Storage ");
            }
        } else if (this.sharedSegments == null || this.sharedSegments.length() == 0) {
            this.updateDBPatchBLOB(connection);
        } else {
            this.updateDBPatchFilesystem(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateDBPatchBLOB(Connection connection) throws SQLException, IOException {
        PreparedStatement segmentUpdate = null;
        PreparedStatement segmentInsert = null;
        InputStream packetStream = null;
        File packetFile = null;
        long newVersion = System.currentTimeMillis();
        try {
            segmentUpdate = connection.prepareStatement("update search_segments set packet_ = ?, version_ = ?, size_ = ? where name_ = ?");
            segmentInsert = connection.prepareStatement("insert into search_segments (packet_, name_, version_, size_ ) values ( ?,?,?,?)");
            packetFile = this.clusterStorage.packPatch();
            if (packetFile.exists()) {
                packetStream = new FileInputStream(packetFile);
                segmentUpdate.clearParameters();
                segmentUpdate.setBinaryStream(1, packetStream, (int)packetFile.length());
                segmentUpdate.setLong(2, newVersion);
                segmentUpdate.setLong(3, packetFile.length());
                segmentUpdate.setString(4, INDEX_PATCHNAME);
                if (segmentUpdate.executeUpdate() != 1) {
                    segmentInsert.clearParameters();
                    segmentInsert.setBinaryStream(1, packetStream, (int)packetFile.length());
                    segmentInsert.setString(2, INDEX_PATCHNAME);
                    segmentInsert.setLong(3, newVersion);
                    segmentInsert.setLong(4, packetFile.length());
                    if (segmentInsert.executeUpdate() != 1) {
                        throw new SQLException(" Failed to insert patch  ");
                    }
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)"DB Updated Patch ");
                }
            } else {
                log.warn((Object)(" Packed Patch does not exist " + packetFile.getPath()));
            }
        }
        finally {
            try {
                if (packetStream != null) {
                    packetStream.close();
                }
            }
            catch (Exception ex) {
                log.debug((Object)ex);
            }
            try {
                packetFile.delete();
            }
            catch (Exception ex) {
                log.debug((Object)ex);
            }
            try {
                segmentUpdate.close();
            }
            catch (Exception ex) {
                log.debug((Object)ex);
            }
            try {
                segmentInsert.close();
            }
            catch (Exception ex) {
                log.debug((Object)ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateDBPatchFilesystem(Connection connection) throws SQLException, IOException {
        Statement segmentUpdate = null;
        Statement segmentInsert = null;
        AbstractInterruptibleChannel packetStream = null;
        AbstractInterruptibleChannel sharedStream = null;
        File packetFile = null;
        File sharedFinalFile = null;
        File sharedTempFile = null;
        long newVersion = System.currentTimeMillis();
        try {
            sharedTempFile = new File(this.getSharedTempFileName(INDEX_PATCHNAME));
            sharedFinalFile = new File(this.getSharedFileName(INDEX_PATCHNAME, this.sharedStructuredStorage));
            packetFile = this.clusterStorage.packPatch();
            if (packetFile.exists()) {
                packetStream = new FileInputStream(packetFile).getChannel();
                File sharedTempFileParent = sharedTempFile.getParentFile();
                if (!sharedTempFileParent.exists() && !sharedTempFileParent.mkdirs()) {
                    log.warn((Object)("couldn't create " + sharedTempFileParent.getPath()));
                }
                sharedStream = new FileOutputStream(sharedTempFile).getChannel();
                this.doBlockedStream((FileChannel)packetStream, (FileChannel)sharedStream);
                packetStream.close();
                sharedStream.close();
                segmentUpdate = connection.prepareStatement("update search_segments set  version_ = ?, size_ = ? where name_ = ? ");
                segmentInsert = connection.prepareStatement("insert into search_segments ( name_, version_, size_ ) values ( ?,?,?)");
                segmentUpdate.clearParameters();
                segmentUpdate.setLong(1, newVersion);
                segmentUpdate.setLong(2, packetFile.length());
                segmentUpdate.setString(3, INDEX_PATCHNAME);
                if (segmentUpdate.executeUpdate() != 1) {
                    segmentInsert.clearParameters();
                    segmentInsert.setString(1, INDEX_PATCHNAME);
                    segmentInsert.setLong(2, newVersion);
                    segmentInsert.setLong(3, packetFile.length());
                    if (segmentInsert.executeUpdate() != 1) {
                        throw new SQLException(" Failed to add patch packet  ");
                    }
                }
                long st = System.currentTimeMillis();
                if (!sharedTempFile.renameTo(sharedFinalFile)) {
                    log.warn((Object)("Couldn't rename file " + sharedTempFile.getPath() + " to " + sharedFinalFile.getPath()));
                }
                if (this.searchService.hasDiagnostics()) {
                    log.info((Object)("Renamed " + sharedTempFile.getPath() + " to " + sharedFinalFile.getPath() + " in " + (System.currentTimeMillis() - st) + "ms"));
                }
            } else {
                log.warn((Object)("Packet file does not exist " + packetFile.getPath()));
            }
        }
        finally {
            try {
                if (packetStream != null) {
                    packetStream.close();
                }
            }
            catch (Exception ex) {
                log.debug((Object)ex);
            }
            try {
                packetFile.delete();
            }
            catch (Exception ex) {
                log.debug((Object)ex);
            }
            try {
                if (sharedStream != null) {
                    sharedStream.close();
                }
            }
            catch (Exception ex) {
                log.debug((Object)ex);
            }
            try {
                sharedTempFile.delete();
            }
            catch (Exception ex) {
                log.debug((Object)ex);
            }
            try {
                segmentUpdate.close();
            }
            catch (Exception ex) {
                log.debug((Object)ex);
            }
            try {
                segmentInsert.close();
            }
            catch (Exception ex) {
                log.debug((Object)ex);
            }
        }
    }

    protected void updateDBSegment(Connection connection, SegmentInfo addsi) throws SQLException, IOException {
        if (this.searchService.hasDiagnostics()) {
            log.info((Object)("\tUpdate Database Segment from Local " + addsi));
        }
        if (this.localSegmentsOnly) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Not Saving Segment to DB as no Shared Storage " + addsi));
            }
        } else if (this.sharedSegments == null || this.sharedSegments.length() == 0) {
            this.updateDBSegmentBLOB(connection, addsi);
        } else {
            this.updateDBSegmentFilesystem(connection, addsi);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateDBSegmentBLOB(Connection connection, SegmentInfo addsi) throws SQLException, IOException {
        block29: {
            PreparedStatement segmentUpdate = null;
            PreparedStatement segmentInsert = null;
            InputStream packetStream = null;
            File packetFile = null;
            long newVersion = System.currentTimeMillis();
            try {
                segmentUpdate = connection.prepareStatement("update search_segments set packet_ = ?, version_ = ?, size_ = ? where name_ = ? and version_ = ?");
                segmentInsert = connection.prepareStatement("insert into search_segments (packet_, name_, version_, size_ ) values ( ?,?,?,?)");
                packetFile = this.clusterStorage.packSegment(addsi, newVersion);
                if (packetFile.exists()) {
                    packetStream = new FileInputStream(packetFile);
                    if (addsi.isInDb()) {
                        segmentUpdate.clearParameters();
                        segmentUpdate.setBinaryStream(1, packetStream, (int)packetFile.length());
                        segmentUpdate.setLong(2, newVersion);
                        segmentUpdate.setLong(3, packetFile.length());
                        segmentUpdate.setString(4, addsi.getName());
                        segmentUpdate.setLong(5, addsi.getVersion());
                        if (segmentUpdate.executeUpdate() != 1) {
                            throw new SQLException(" ant Find packet to update " + addsi);
                        }
                    } else {
                        segmentInsert.clearParameters();
                        segmentInsert.setBinaryStream(1, packetStream, (int)packetFile.length());
                        segmentInsert.setString(2, addsi.getName());
                        segmentInsert.setLong(3, newVersion);
                        segmentInsert.setLong(4, packetFile.length());
                        if (segmentInsert.executeUpdate() != 1) {
                            throw new SQLException(" Failed to insert packet  " + addsi);
                        }
                    }
                    addsi.setVersion(newVersion);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("DB Updated " + addsi));
                    }
                    try {
                        packetStream.close();
                    }
                    catch (Exception ex) {
                        log.debug((Object)ex);
                    }
                    try {
                        packetFile.delete();
                    }
                    catch (Exception ex) {
                        log.debug((Object)ex);
                    }
                    break block29;
                }
                log.warn((Object)("Packet file does not exist " + packetFile.getPath()));
            }
            finally {
                try {
                    packetStream.close();
                }
                catch (Exception ex) {
                    log.debug((Object)ex);
                }
                try {
                    packetFile.delete();
                }
                catch (Exception ex) {
                    log.debug((Object)ex);
                }
                try {
                    segmentUpdate.close();
                }
                catch (Exception ex) {
                    log.debug((Object)ex);
                }
                try {
                    segmentInsert.close();
                }
                catch (Exception ex) {
                    log.debug((Object)ex);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeDBSegment(Connection connection, SegmentInfo rmsi) throws SQLException {
        PreparedStatement segmentDelete = null;
        try {
            if (rmsi.isInDb()) {
                File f;
                segmentDelete = connection.prepareStatement("delete from search_segments where name_ = ? and version_ = ?");
                segmentDelete.clearParameters();
                segmentDelete.setString(1, rmsi.getName());
                segmentDelete.setLong(2, rmsi.getVersion());
                segmentDelete.execute();
                String sharedSegment = this.getSharedFileName(rmsi.getName(), this.sharedStructuredStorage);
                if (sharedSegment != null && (f = new File(sharedSegment)).exists() && !f.delete()) {
                    log.warn((Object)("unable to delete " + f.getPath()));
                }
                if (this.searchService.hasDiagnostics()) {
                    log.info((Object)("\tRemoved Segment From Database [" + rmsi + "]"));
                }
            }
        }
        finally {
            try {
                if (segmentDelete != null) {
                    segmentDelete.close();
                }
            }
            catch (Exception ex) {
                log.debug((Object)ex);
            }
        }
    }

    @Override
    public SegmentInfo newSegment() throws IOException {
        File f = null;
        while ((f = SegmentInfoImpl.getSegmentLocation(String.valueOf(System.currentTimeMillis()), this.localStructuredStorage, this.searchIndexDirectory)).exists()) {
        }
        if (!f.mkdirs()) {
            log.warn((Object)("unable to create directory: " + f.getPath()));
        }
        SegmentInfo si = SegmentInfoImpl.newLocalSegmentInfo(f, this.localStructuredStorage, this.searchIndexDirectory);
        si.setNew();
        si.setTimeStamp(System.currentTimeMillis());
        return si;
    }

    public List<SegmentInfo> getLocalSegments() throws IOException {
        ArrayList<SegmentInfo> l = new ArrayList<SegmentInfo>();
        File searchDir = new File(this.searchIndexDirectory);
        return this.getLocalSegments(searchDir, l);
    }

    public List<SegmentInfo> getLocalSegments(File searchDir, List<SegmentInfo> l) throws IOException {
        File[] files = searchDir.listFiles();
        if (files != null) {
            for (int i = 0; i < files.length; ++i) {
                if (!files[i].isDirectory()) continue;
                SegmentInfo sgi = SegmentInfoImpl.newLocalSegmentInfo(files[i], this.localStructuredStorage, this.searchIndexDirectory);
                if (sgi.isClusterSegment()) {
                    if (IndexReader.indexExists((Directory)FSDirectory.open((File)files[i]))) {
                        if (sgi.isCreated()) {
                            l.add(sgi);
                            if (!log.isDebugEnabled()) continue;
                            log.debug((Object)("LO Segment " + sgi));
                            continue;
                        }
                        if (!log.isDebugEnabled()) continue;
                        log.debug((Object)("LO Segment not created " + sgi.toString()));
                        continue;
                    }
                    log.warn((Object)("Found Orphaned directory with no segment information present " + files[i]));
                    continue;
                }
                l = this.getLocalSegments(files[i], l);
            }
        }
        return l;
    }

    private List<SegmentInfo> getBadLocalSegments() throws IOException {
        ArrayList<SegmentInfo> l = new ArrayList<SegmentInfo>();
        File searchDir = new File(this.searchIndexDirectory);
        return this.getBadLocalSegments(searchDir, l);
    }

    private List<SegmentInfo> getDeletedLocalSegments() throws IOException {
        ArrayList<SegmentInfo> l = new ArrayList<SegmentInfo>();
        File searchDir = new File(this.searchIndexDirectory);
        return this.getDeletedLocalSegments(searchDir, l);
    }

    private List<SegmentInfo> getBadLocalSegments(File searchDir, List<SegmentInfo> l) throws IOException {
        File[] files;
        if (searchDir.isDirectory() && (files = searchDir.listFiles()) != null) {
            for (int i = 0; i < files.length; ++i) {
                SegmentInfo sgi = SegmentInfoImpl.newLocalSegmentInfo(files[i], this.localStructuredStorage, this.searchIndexDirectory);
                if (sgi.isClusterSegment()) {
                    if (!sgi.isCreated() || IndexReader.indexExists((Directory)FSDirectory.open((File)files[i]))) continue;
                    l.add(sgi);
                    continue;
                }
                l = this.getBadLocalSegments(files[i], l);
            }
        }
        return l;
    }

    private List<SegmentInfo> getDeletedLocalSegments(File searchDir, List<SegmentInfo> l) throws IOException {
        File[] files;
        if (searchDir.isDirectory() && (files = searchDir.listFiles()) != null) {
            for (int i = 0; i < files.length; ++i) {
                SegmentInfo sgi = SegmentInfoImpl.newLocalSegmentInfo(files[i], this.localStructuredStorage, this.searchIndexDirectory);
                if (sgi.isClusterSegment()) {
                    if (!sgi.isDeleted()) continue;
                    l.add(sgi);
                    continue;
                }
                l = this.getDeletedLocalSegments(files[i], l);
            }
        }
        return l;
    }

    private void recoverFromFailure() {
        log.error((Object)"Recover from Failiure is not implementated at the moment, the local index is corrupt, please delete it and it will reload from the database");
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    @Override
    public void setLocation(String location) {
        this.searchIndexDirectory = location;
        log.info((Object)("Search Index Location is " + location));
    }

    public void setAutoDdl(boolean autoDdl) {
        this.autoDdl = autoDdl;
    }

    @Override
    public File getTemporarySegment(boolean delete) {
        File f = new File(this.searchIndexDirectory, TEMP_INDEX_NAME);
        if (delete && f.exists()) {
            SegmentInfoImpl.deleteAll(f);
        }
        if (!f.exists() && !f.mkdirs()) {
            log.warn((Object)("couldn't create directory " + f.getPath()));
        }
        return f;
    }

    @Override
    public void removeTemporarySegment() {
        File f = new File(this.searchIndexDirectory, TEMP_INDEX_NAME);
        if (f.exists()) {
            SegmentInfoImpl.deleteAll(f);
        }
    }

    @Override
    public SegmentInfo saveTemporarySegment() throws IOException {
        SegmentInfo segInfo = this.newSegment();
        File s = new File(this.searchIndexDirectory, TEMP_INDEX_NAME);
        File d = segInfo.getSegmentLocation();
        this.copyAll(s, d);
        segInfo.setCreated();
        segInfo.touchSegment();
        return segInfo;
    }

    private void copyAll(File s, File d) throws IOException {
        if (s.isDirectory()) {
            File[] fl = s.listFiles();
            for (int i = 0; i < fl.length; ++i) {
                if (fl[i].isFile()) {
                    this.copyFile(fl[i], d);
                    continue;
                }
                File nd = new File(d, fl[i].getName());
                if (!nd.mkdirs()) {
                    log.warn((Object)("couldn't create directories " + nd.getPath()));
                }
                this.copyAll(fl[i], nd);
            }
        } else {
            this.copyFile(s, d);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyFile(File s, File d) throws IOException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Copying " + s.getAbsolutePath() + " to " + d.getAbsolutePath()));
        }
        if (s.exists() && s.isFile()) {
            File t = d;
            if (d.isDirectory()) {
                if (!d.exists() && !d.mkdirs()) {
                    log.warn((Object)("Unable to create directory " + d.getPath()));
                }
                t = new File(d, s.getName());
            } else {
                File p = d.getParentFile();
                if (!p.exists() && !p.mkdirs()) {
                    log.warn((Object)("couldn't create:  " + p.getPath()));
                }
            }
            AbstractInterruptibleChannel srcChannel = null;
            AbstractInterruptibleChannel dstChannel = null;
            try {
                srcChannel = new FileInputStream(s).getChannel();
                dstChannel = new FileOutputStream(t).getChannel();
                this.doBlockedStream((FileChannel)srcChannel, (FileChannel)dstChannel);
            }
            finally {
                try {
                    srcChannel.close();
                }
                catch (Exception ex) {
                    log.debug((Object)ex);
                }
                try {
                    dstChannel.close();
                }
                catch (Exception ex) {
                    log.debug((Object)ex);
                }
            }
        }
    }

    @Override
    public void recoverSegment(SegmentInfo recoverSegInfo) {
        SegmentInfo segInfo = SegmentInfoImpl.newLocalSegmentInfo(recoverSegInfo);
        segInfo.debugSegment("Pre Recovery Check :");
        segInfo.compareTo("Comparing Disk Segment to Recovered Segment", recoverSegInfo);
        recoverSegInfo.setDeleted();
        recoverSegInfo.doFinalDelete();
        recoverSegInfo.setNew();
        Connection connection = null;
        try {
            connection = this.dataSource.getConnection();
            this.updateLocalSegment(connection, recoverSegInfo);
            this.updateLocalPatch(connection);
            connection.commit();
        }
        catch (Exception ex) {
            try {
                connection.rollback();
            }
            catch (Exception e) {
                log.debug((Object)ex);
            }
            throw new RuntimeException("Failed to recover dammaged segment ", ex);
        }
        finally {
            try {
                connection.close();
            }
            catch (Exception e) {
                log.debug((Object)e);
            }
        }
        SegmentInfo newSegInfo = SegmentInfoImpl.newLocalSegmentInfo(recoverSegInfo);
        newSegInfo.debugSegment("Recovered Segment");
        newSegInfo.compareTo("Comparing Recoverd Segment to Previous Disk Segment", segInfo);
    }

    protected void updateLocalPatch(Connection connection) throws SQLException, IOException {
        if (this.localSegmentsOnly) {
            log.warn((Object)"Update Patch Requested with inactive Shared Storage ");
        } else if (this.sharedSegments == null || this.sharedSegments.length() == 0) {
            this.updateLocalPatchBLOB(connection);
        } else {
            this.updateLocalPatchFilesystem(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateLocalPatchFilesystem(Connection connection) throws SQLException, IOException {
        block25: {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Updating local patch ");
            }
            PreparedStatement segmentSelect = null;
            ResultSet resultSet = null;
            try {
                segmentSelect = connection.prepareStatement("select version_ from search_segments where name_ = ?");
                segmentSelect.clearParameters();
                segmentSelect.setString(1, INDEX_PATCHNAME);
                resultSet = segmentSelect.executeQuery();
                if (resultSet.next()) {
                    InputStream packetStream = null;
                    try {
                        File f = new File(this.getSharedFileName(INDEX_PATCHNAME, this.sharedStructuredStorage));
                        if (f.exists()) {
                            packetStream = new FileInputStream(f);
                            this.clusterStorage.unpackPatch(packetStream);
                            if (log.isDebugEnabled()) {
                                log.debug((Object)"Updated Patch ");
                            }
                        } else {
                            log.warn((Object)("Shared Segment File does not exist " + f.getPath()));
                        }
                        break block25;
                    }
                    finally {
                        try {
                            if (packetStream != null) {
                                packetStream.close();
                            }
                        }
                        catch (Exception ex) {
                            log.debug((Object)ex);
                        }
                    }
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Didnt find patch in database, this is Ok");
                }
            }
            finally {
                try {
                    resultSet.close();
                }
                catch (Exception ex) {
                    log.debug((Object)ex);
                }
                try {
                    segmentSelect.close();
                }
                catch (Exception ex) {
                    log.debug((Object)ex);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateLocalPatchBLOB(Connection connection) throws SQLException, IOException {
        block22: {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Updating local patch ");
            }
            PreparedStatement segmentSelect = null;
            ResultSet resultSet = null;
            try {
                segmentSelect = connection.prepareStatement("select version_, packet_ from search_segments where name_ = ?");
                segmentSelect.clearParameters();
                segmentSelect.setString(1, INDEX_PATCHNAME);
                resultSet = segmentSelect.executeQuery();
                if (resultSet.next()) {
                    InputStream packetStream = null;
                    try {
                        long version = resultSet.getLong(1);
                        packetStream = resultSet.getBinaryStream(2);
                        this.clusterStorage.unpackPatch(packetStream);
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Updated Patch from DB " + version));
                        }
                        break block22;
                    }
                    finally {
                        try {
                            packetStream.close();
                        }
                        catch (Exception ex) {
                            log.debug((Object)ex);
                        }
                    }
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Didnt find patch in database, this is Ok ");
                }
            }
            finally {
                try {
                    resultSet.close();
                }
                catch (Exception ex) {
                    log.debug((Object)ex);
                }
                try {
                    segmentSelect.close();
                }
                catch (Exception ex) {
                    log.debug((Object)ex);
                }
            }
        }
    }

    public String getSegmentName(String segmentPath) {
        File f = new File(segmentPath);
        return f.getName();
    }

    public boolean isValidate() {
        return this.validate;
    }

    public void setValidate(boolean validate) {
        this.validate = validate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateDBSegmentFilesystem(Connection connection, SegmentInfo addsi) throws SQLException, IOException {
        Statement segmentUpdate = null;
        Statement segmentInsert = null;
        AbstractInterruptibleChannel packetStream = null;
        AbstractInterruptibleChannel sharedStream = null;
        File packetFile = null;
        File sharedFinalFile = null;
        File sharedTempFile = null;
        long newVersion = System.currentTimeMillis();
        try {
            sharedTempFile = new File(this.getSharedTempFileName(addsi.getName()));
            sharedFinalFile = new File(this.getSharedFileName(addsi.getName(), this.sharedStructuredStorage));
            packetFile = this.clusterStorage.packSegment(addsi, newVersion);
            if (packetFile.exists()) {
                packetStream = new FileInputStream(packetFile).getChannel();
                File parentFile = sharedTempFile.getParentFile();
                if (!parentFile.exists() && !parentFile.mkdirs()) {
                    log.warn((Object)("Unable to create directory " + sharedTempFile.getParentFile().getPath()));
                }
                sharedStream = new FileOutputStream(sharedTempFile).getChannel();
                this.doBlockedStream((FileChannel)packetStream, (FileChannel)sharedStream);
                packetStream.close();
                sharedStream.close();
                segmentUpdate = connection.prepareStatement("update search_segments set  version_ = ?, size_ = ? where name_ = ? and version_ = ?");
                segmentInsert = connection.prepareStatement("insert into search_segments ( name_, version_, size_ ) values ( ?,?,?)");
                if (addsi.isInDb()) {
                    segmentUpdate.clearParameters();
                    segmentUpdate.setLong(1, newVersion);
                    segmentUpdate.setLong(2, packetFile.length());
                    segmentUpdate.setString(3, addsi.getName());
                    segmentUpdate.setLong(4, addsi.getVersion());
                    if (segmentUpdate.executeUpdate() != 1) {
                        throw new SQLException(" ant Find packet to update " + addsi);
                    }
                } else {
                    segmentInsert.clearParameters();
                    segmentInsert.setString(1, addsi.getName());
                    segmentInsert.setLong(2, newVersion);
                    segmentInsert.setLong(3, packetFile.length());
                    if (segmentInsert.executeUpdate() != 1) {
                        throw new SQLException(" Failed to insert packet  " + addsi);
                    }
                }
                addsi.setVersion(newVersion);
                File sharedParentFile = sharedFinalFile.getParentFile();
                if (!sharedParentFile.exists() && !sharedParentFile.mkdirs()) {
                    log.warn((Object)("Couln't create directory " + sharedParentFile.getPath()));
                }
                long st = System.currentTimeMillis();
                if (!sharedTempFile.renameTo(sharedFinalFile)) {
                    log.warn((Object)("Couldn't rename " + sharedTempFile.getPath() + " to " + sharedFinalFile.getPath()));
                }
                if (this.searchService.hasDiagnostics()) {
                    log.info((Object)("Renamed " + sharedTempFile.getPath() + " to " + sharedFinalFile.getPath() + " in " + (System.currentTimeMillis() - st) + "ms"));
                }
                log.info((Object)("DB Updated " + addsi));
            } else {
                log.warn((Object)("Packet file does not exist " + packetFile.getPath()));
            }
        }
        finally {
            try {
                packetStream.close();
            }
            catch (Exception ex) {
                log.debug((Object)ex);
            }
            try {
                packetFile.delete();
            }
            catch (Exception ex) {
                log.debug((Object)ex);
            }
            try {
                sharedStream.close();
            }
            catch (Exception ex) {
                log.debug((Object)ex);
            }
            try {
                sharedTempFile.delete();
            }
            catch (Exception ex) {
                log.debug((Object)ex);
            }
            try {
                segmentUpdate.close();
            }
            catch (Exception ex) {
                log.debug((Object)ex);
            }
            try {
                segmentInsert.close();
            }
            catch (Exception ex) {
                log.debug((Object)ex);
            }
        }
    }

    private void doBlockedStream(FileChannel from, FileChannel to) throws IOException {
        long t;
        to.position(0L);
        long size = from.size();
        for (long pos = 0L; pos < size; pos += t) {
            long count = size - pos;
            if (count > 0xA00000L) {
                count = 0xA00000L;
            }
            to.position(pos);
            long cpos = to.position();
            log.debug((Object)("NIOTransfering |" + count + "| bytes from |" + pos + "| to |" + cpos + "|"));
            t = to.transferFrom(from, pos, count);
        }
        log.debug((Object)("  Final Size Source        " + from.size()));
        log.debug((Object)("  Final Size Destination   " + to.size()));
    }

    private String getSharedFileName(String name, boolean structured) {
        if (this.localSegmentsOnly) {
            return null;
        }
        if (this.sharedSegments != null && this.sharedSegments.length() > 0) {
            if (!this.sharedSegments.endsWith("/")) {
                this.sharedSegments = this.sharedSegments + "/";
            }
            if (structured && !INDEX_PATCHNAME.equals(name)) {
                String hashName = name.substring(name.length() - 4, name.length() - 2);
                return this.sharedSegments + hashName + "/" + name + ".zip";
            }
            return this.sharedSegments + name + ".zip";
        }
        return null;
    }

    private String getSharedTempFileName(String name) {
        if (this.sharedSegments != null && this.sharedSegments.length() > 0) {
            if (!this.sharedSegments.endsWith("/")) {
                this.sharedSegments = this.sharedSegments + "/";
            }
            return this.sharedSegments + name + ".zip." + System.currentTimeMillis();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateLocalSegmentFilesystem(Connection connection, SegmentInfo addsi) throws SQLException, IOException {
        block23: {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Updating local segment from databse " + addsi));
            }
            PreparedStatement segmentSelect = null;
            ResultSet resultSet = null;
            try {
                segmentSelect = connection.prepareStatement("select version_ from search_segments where name_ = ?");
                segmentSelect.clearParameters();
                segmentSelect.setString(1, addsi.getName());
                resultSet = segmentSelect.executeQuery();
                if (resultSet.next()) {
                    InputStream packetStream = null;
                    try {
                        long version = resultSet.getLong(1);
                        File f = new File(this.getSharedFileName(addsi.getName(), this.sharedStructuredStorage));
                        if (f.exists()) {
                            packetStream = new FileInputStream(f);
                            this.clusterStorage.unpackSegment(addsi, packetStream, version);
                            if (log.isDebugEnabled()) {
                                log.debug((Object)("Updated Local " + addsi));
                            }
                        } else {
                            log.warn((Object)("Shared Segment file is missing " + f.getPath()));
                        }
                        break block23;
                    }
                    finally {
                        try {
                            packetStream.close();
                        }
                        catch (Exception ex) {
                            log.debug((Object)ex);
                        }
                    }
                }
                log.error((Object)"Didnt find segment in database");
            }
            finally {
                try {
                    resultSet.close();
                }
                catch (Exception ex) {
                    log.debug((Object)ex);
                }
                try {
                    segmentSelect.close();
                }
                catch (Exception ex) {
                    log.debug((Object)ex);
                }
            }
        }
    }

    public String getSharedSegments() {
        return this.sharedSegments;
    }

    public void setSharedSegments(String sharedSegments) {
        this.sharedSegments = sharedSegments;
    }

    public void dolog(String message) {
        if (this.debug) {
            log.info((Object)("JDBCClusterDebug :" + message));
        } else if (log.isDebugEnabled()) {
            log.debug((Object)("JDBCClusterDebug :" + message));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getLastUpdate() {
        PreparedStatement segmentSelect = null;
        ResultSet resultSet = null;
        Connection connection = null;
        try {
            connection = this.dataSource.getConnection();
            segmentSelect = connection.prepareStatement("select version_ from search_segments order by version_ desc");
            segmentSelect.clearParameters();
            resultSet = segmentSelect.executeQuery();
            if (resultSet.next()) {
                long l = resultSet.getLong(1);
                return l;
            }
            long l = 0L;
            return l;
        }
        catch (Exception ex) {
            log.warn((Object)(" Cant find last update time " + ex.getClass().getName() + ":" + ex.getMessage()));
            long l = 0L;
            return l;
        }
        finally {
            try {
                resultSet.close();
            }
            catch (Exception ex) {
                log.debug((Object)ex);
            }
            try {
                segmentSelect.close();
            }
            catch (Exception ex) {
                log.debug((Object)ex);
            }
            try {
                connection.close();
            }
            catch (Exception ex) {
                log.debug((Object)ex);
            }
        }
    }

    @Override
    public List<Object[]> getSegmentInfoList() {
        ArrayList<Object[]> seginfo = new ArrayList<Object[]>();
        try {
            File searchDir = new File(this.searchIndexDirectory);
            long tsize = this.getSegmentInfoList(searchDir, seginfo);
            String size = null;
            size = tsize > 0xA00000L ? String.valueOf(tsize / 0x100000L) + "MB" : (tsize >= 0x100000L ? String.valueOf(tsize / 0x100000L) + "." + String.valueOf(tsize / 104448L + "MB") : String.valueOf(tsize / 1024L) + "KB");
            seginfo.add(new Object[]{"Total", size, ""});
        }
        catch (Exception ex) {
            seginfo.add(new Object[]{"Failed to get Segment Info list " + ex.getClass().getName() + " " + ex.getMessage()});
        }
        return seginfo;
    }

    public long getSegmentInfoList(File searchDir, List<Object[]> seginfo) {
        File[] files = searchDir.listFiles();
        long tsize = 0L;
        if (files != null) {
            for (int i = 0; i < files.length; ++i) {
                if (!files[i].isDirectory()) continue;
                SegmentInfo sgi = SegmentInfoImpl.newLocalSegmentInfo(files[i], this.localStructuredStorage, this.searchIndexDirectory);
                if (sgi != null && sgi.isClusterSegment()) {
                    String name = files[i].getName();
                    long lsize = sgi.getLocalSegmentSize();
                    tsize += lsize;
                    long ts = sgi.getLocalSegmentLastModified();
                    String lastup = new Date(ts).toString();
                    String size = null;
                    size = lsize > 0xA00000L ? String.valueOf(lsize / 0x100000L) + "MB" : (lsize >= 0x100000L ? String.valueOf(lsize / 0x100000L) + "." + String.valueOf(lsize / 104448L + "MB") : String.valueOf(lsize / 1024L) + "KB");
                    seginfo.add(new Object[]{name, size, lastup});
                    continue;
                }
                tsize += this.getSegmentInfoList(files[i], seginfo);
            }
        }
        return tsize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void migrateSharedSegments() {
        if (this.localSegmentsOnly) {
            return;
        }
        if (this.sharedSegments != null && this.sharedSegments.length() > 0) {
            Connection connection = null;
            try {
                connection = this.dataSource.getConnection();
                List<SegmentInfo> l = this.getDBSegments(connection);
                for (SegmentInfo si : l) {
                    String shared = this.getSharedFileName(si.getName(), !this.sharedStructuredStorage);
                    File f = new File(shared);
                    if (!f.exists()) continue;
                    File fnew = new File(this.getSharedFileName(si.getName(), this.sharedStructuredStorage));
                    if (!fnew.getParentFile().mkdirs()) {
                        log.warn((Object)("couldn't create directory: " + fnew.getParentFile().getPath()));
                    }
                    log.info((Object)("Moving " + f.getPath() + " to " + fnew.getPath()));
                    if (f.renameTo(fnew)) continue;
                    log.warn((Object)("Failed rename " + f.getPath() + " to " + fnew.getPath()));
                }
                connection.commit();
            }
            catch (Exception ex) {
                try {
                    connection.rollback();
                }
                catch (Exception ex1) {
                    log.debug((Object)ex);
                }
            }
            finally {
                try {
                    connection.close();
                }
                catch (Exception ex) {
                    log.debug((Object)ex);
                }
            }
        }
    }

    private void migrateLocalSegments() throws IOException {
        List<SegmentInfo> l = this.getLocalSegments();
        for (SegmentInfo si : l) {
            File f = SegmentInfoImpl.getSegmentLocation(si.getName(), !this.localStructuredStorage, this.searchIndexDirectory);
            if (!f.exists()) continue;
            File fnew = SegmentInfoImpl.getSegmentLocation(si.getName(), this.localStructuredStorage, this.searchIndexDirectory);
            if (!fnew.getParentFile().mkdirs()) {
                log.warn((Object)("couldn't create directory " + fnew.getParentFile().getPath()));
            }
            log.info((Object)("Moving " + f.getPath() + " to " + fnew.getPath()));
            if (f.renameTo(fnew)) continue;
            log.warn((Object)("Failed to rename " + f.getPath() + " to " + fnew.getPath()));
        }
    }

    @Override
    public void getLock() throws IOException {
        if (this.parallelIndex) {
            throw new RuntimeException("Parallel index is not implemented yet");
        }
    }

    @Override
    public void releaseLock() {
        if (this.parallelIndex) {
            throw new RuntimeException("Parallel index is not implemented yet");
        }
    }

    @Override
    public boolean isMultipleIndexers() {
        return this.parallelIndex;
    }

    public boolean isParallelIndex() {
        return this.parallelIndex;
    }

    public void setParallelIndex(boolean parallelIndex) {
        this.parallelIndex = parallelIndex;
    }

    public boolean isLocalStructuredStorage() {
        return this.localStructuredStorage;
    }

    public void setLocalStructuredStorage(boolean localStructuredStorage) {
        this.localStructuredStorage = localStructuredStorage;
    }

    public boolean isSharedStructuredStorage() {
        return this.sharedStructuredStorage;
    }

    public void setSharedStructuredStorage(boolean sharedStructuredStorage) {
        this.sharedStructuredStorage = sharedStructuredStorage;
    }

    public boolean isLocalSegmentsOnly() {
        return this.localSegmentsOnly;
    }

    public void setLocalSegmentsOnly(boolean localSegmentsOnly) {
        this.localSegmentsOnly = localSegmentsOnly;
    }

    public SearchService getSearchService() {
        return this.searchService;
    }

    public void setSearchService(SearchService searchService) {
        this.searchService = searchService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean centralIndexExists() {
        Connection connection = null;
        try {
            connection = this.dataSource.getConnection();
            List<SegmentInfo> l = this.getDBSegments(connection);
            if (l != null && l.size() > 0) {
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        catch (SQLException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                connection.close();
            }
            catch (Exception ex) {
                log.debug((Object)ex);
            }
        }
    }
}

