/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.search.component.adapter.contenthosting;

import java.io.BufferedInputStream;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pdfbox.pdfparser.PDFParser;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.util.PDFTextStripper;
import org.sakaiproject.content.api.ContentResource;
import org.sakaiproject.exception.ServerOverloadException;
import org.sakaiproject.search.api.SearchUtils;
import org.sakaiproject.search.component.adapter.contenthosting.BaseContentDigester;

public class PDFContentDigester
extends BaseContentDigester {
    private static Log log = LogFactory.getLog(PDFContentDigester.class);

    @Override
    public String getContent(ContentResource contentResource) {
        if (contentResource == null) {
            throw new RuntimeException("Null contentResource passed to getContent");
        }
        InputStream contentStream = null;
        PDFParser parser = null;
        PDDocument pddoc = null;
        try {
            contentStream = contentResource.streamContent();
            parser = new PDFParser((InputStream)new BufferedInputStream(contentStream));
            parser.parse();
            pddoc = parser.getPDDocument();
            if (pddoc != null) {
                PDFTextStripper stripper = new PDFTextStripper();
                stripper.setLineSeparator("\n");
                CharArrayWriter cw = new CharArrayWriter();
                stripper.writeText(pddoc, (Writer)cw);
                String string = SearchUtils.appendCleanString((char[])cw.toCharArray(), null).toString();
                return string;
            }
        }
        catch (ServerOverloadException e) {
            String eMessage = e.getMessage();
            if (eMessage == null) {
                eMessage = e.toString();
            }
            throw new RuntimeException("Failed to get content for indexing: cause: ServerOverloadException: " + eMessage, e);
        }
        catch (IOException e) {
            String eMessage = e.getMessage();
            if (eMessage == null) {
                eMessage = e.toString();
            }
            throw new RuntimeException("Failed to get content for indexing: cause: IOException:  " + eMessage, e);
        }
        finally {
            if (pddoc != null) {
                try {
                    pddoc.close();
                }
                catch (IOException e) {
                    log.debug((Object)e);
                }
            }
            if (contentStream != null) {
                try {
                    contentStream.close();
                }
                catch (IOException e) {
                    log.debug((Object)e);
                }
            }
        }
        return null;
    }

    @Override
    public Reader getContentReader(ContentResource contentResource) {
        return new StringReader(this.getContent(contentResource));
    }
}

