/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.search.component.service.impl;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sakaiproject.authz.cover.SecurityService;
import org.sakaiproject.db.cover.SqlService;
import org.sakaiproject.search.api.SearchStatus;
import org.sakaiproject.search.component.Messages;
import org.sakaiproject.search.component.service.impl.BaseSearchServiceImpl;

public class ConcurrentSearchServiceImpl
extends BaseSearchServiceImpl {
    private static Log log = LogFactory.getLog(ConcurrentSearchServiceImpl.class);

    @Override
    public void init() {
        super.init();
        try {
            try {
                if (this.autoDdl) {
                    SqlService.getInstance().ddl(this.getClass().getClassLoader(), "sakai_search_parallel");
                }
            }
            catch (Exception ex) {
                log.error((Object)"Perform additional SQL setup", (Throwable)ex);
            }
            this.initComplete = true;
        }
        catch (Throwable t) {
            log.error((Object)"Failed to start ", t);
        }
    }

    @Override
    public String getStatus() {
        String lastLoad = new Date(this.indexStorage.getLastLoad()).toString();
        String loadTime = String.valueOf(0.001 * (double)this.indexStorage.getLastLoadTime());
        return Messages.getString("SearchServiceImpl.40") + lastLoad + Messages.getString("SearchServiceImpl.38") + loadTime + Messages.getString("SearchServiceImpl.37");
    }

    @Override
    public SearchStatus getSearchStatus() {
        String ll = Messages.getString("SearchServiceImpl.36");
        String lt = "";
        long reloadEnd = this.indexStorage.getLastLoad();
        if (reloadEnd != 0L) {
            ll = new Date(reloadEnd).toString();
            lt = String.valueOf(0.001 * (double)this.indexStorage.getLastLoadTime());
        }
        final String lastLoad = ll;
        final String loadTime = lt;
        final String pdocs = String.valueOf(this.getPendingDocs());
        final String ndocs = String.valueOf(this.getNDocs());
        return new SearchStatus(){

            public String getLastLoad() {
                return lastLoad;
            }

            public String getLoadTime() {
                return loadTime;
            }

            public String getCurrentWorker() {
                return "concurrent indexing, no locks ";
            }

            public String getCurrentWorkerETC() {
                if (SecurityService.isSuperUser()) {
                    return "List of current activity, superuser";
                }
                return "List of current activity, normal user ";
            }

            public List<Object[]> getWorkerNodes() {
                ArrayList<Object[]> l = new ArrayList<Object[]>();
                l.add(new Object[]{"NodeName", new Date(), "running status "});
                return l;
            }

            public String getNDocuments() {
                return ndocs;
            }

            public String getPDocuments() {
                return pdocs;
            }
        };
    }

    @Override
    public boolean removeWorkerLock() {
        return true;
    }

    @Override
    public boolean isEnabled() {
        String resource = SqlService.getVendor() + "/sakai_search_parallel.sql";
        if (this.getClass().getClassLoader().getResourceAsStream(resource) == null) {
            return false;
        }
        return super.isEnabled();
    }
}

