/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.search.filter.impl;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sakaiproject.component.api.ComponentManager;
import org.sakaiproject.entity.api.EntityManager;
import org.sakaiproject.search.api.EntityContentProducer;
import org.sakaiproject.search.api.SearchIndexBuilder;
import org.sakaiproject.search.api.SearchResult;
import org.sakaiproject.search.api.TermFrequency;
import org.sakaiproject.search.component.Messages;
import org.sakaiproject.search.filter.SearchItemFilter;

public class SearchSecurityFilter
implements SearchItemFilter {
    private static final Log log = LogFactory.getLog(SearchSecurityFilter.class);
    private SearchIndexBuilder searchIndexBuilder = null;
    private EntityManager entityManager = null;
    private SearchItemFilter nextFilter = null;

    public void init() {
    }

    private Object load(ComponentManager cm, String name) {
        Object o = cm.get(name);
        if (o == null) {
            log.error((Object)("Cant find Spring component named " + name));
        }
        return o;
    }

    public SearchItemFilter getNextFilter() {
        return this.nextFilter;
    }

    public void setNextFilter(SearchItemFilter nextFilter) {
        this.nextFilter = nextFilter;
    }

    public SearchIndexBuilder getSearchIndexBuilder() {
        return this.searchIndexBuilder;
    }

    public void setSearchIndexBuilder(SearchIndexBuilder searchIndexBuilder) {
        this.searchIndexBuilder = searchIndexBuilder;
    }

    @Override
    public SearchResult filter(SearchResult result) {
        String reference = result.getReference();
        EntityContentProducer ecp = this.searchIndexBuilder.newEntityContentProducer(reference);
        if (ecp == null || !ecp.canRead(reference)) {
            result = new CensoredSearchResult();
        }
        if (this.nextFilter == null) {
            return result;
        }
        return this.nextFilter.filter(result);
    }

    public EntityManager getEntityManager() {
        return this.entityManager;
    }

    public void setEntityManager(EntityManager entityManager) {
        this.entityManager = entityManager;
    }

    public class CensoredSearchResult
    implements SearchResult {
        public float getScore() {
            return 0.0f;
        }

        public String getId() {
            return "";
        }

        public String[] getFieldNames() {
            return new String[0];
        }

        public String[] getValues(String string) {
            return new String[0];
        }

        public Map<String, String[]> getValueMap() {
            return new HashMap<String, String[]>();
        }

        public String getUrl() {
            return "";
        }

        public String getTitle() {
            return Messages.getString("SearchSecurityFilter.5");
        }

        public int getIndex() {
            return 0;
        }

        public String getSearchResult() {
            return "";
        }

        public String getReference() {
            return "";
        }

        public TermFrequency getTerms() throws IOException {
            return new TermFrequency(){
                int[] freq = new int[0];
                String[] terms = new String[0];

                public int[] getFrequencies() {
                    return this.freq;
                }

                public String[] getTerms() {
                    return this.terms;
                }
            };
        }

        public String getTool() {
            return "";
        }

        public void toXMLString(StringBuilder sb) {
            sb.append("<result");
            sb.append(" index=\"0\" ");
            sb.append(" score=\"0\" ");
            sb.append(" sid=\"\" ");
            sb.append(" reference=\"\" ");
            sb.append(" title=\"\" ");
            sb.append(" tool=\"\" ");
            sb.append(" url=\"\" />");
        }

        public String getSiteId() {
            return "";
        }

        public boolean isCensored() {
            return true;
        }

        public void setUrl(String newUrl) {
        }

        public boolean hasPortalUrl() {
            log.debug((Object)("hasPortalUrl(" + this.getReference()));
            return false;
        }
    }
}

