/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.search.index.impl;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.store.Directory;
import org.sakaiproject.search.index.IndexReloadListener;
import org.sakaiproject.search.index.IndexStorage;

public class SearchIndexStorage
implements IndexStorage {
    private static final Log log = LogFactory.getLog(SearchIndexStorage.class);
    private IndexStorage runningIndexStorage = null;
    private Map currentStores = null;
    private IndexStorage defaultIndexStorage;
    private String indexStorageName;
    private boolean recover;
    private String location;

    public void init() {
        log.info((Object)"init()");
        try {
            this.runningIndexStorage = (IndexStorage)this.currentStores.get(this.indexStorageName.trim());
            if (this.runningIndexStorage == null) {
                this.runningIndexStorage = this.defaultIndexStorage;
            }
        }
        catch (Exception ex) {
            log.warn((Object)"Failed to init SearchIndexStorage ", (Throwable)ex);
        }
        log.info((Object)"init() Ok");
    }

    @Override
    public IndexReader getIndexReader() throws IOException {
        return this.runningIndexStorage.getIndexReader();
    }

    @Override
    public IndexWriter getIndexWriter(boolean create) throws IOException {
        return this.runningIndexStorage.getIndexWriter(create);
    }

    @Override
    public void doPostIndexUpdate() throws IOException {
        this.runningIndexStorage.doPostIndexUpdate();
    }

    @Override
    public void doPreIndexUpdate() throws IOException {
        this.runningIndexStorage.doPreIndexUpdate();
    }

    @Override
    public boolean indexExists() {
        return this.runningIndexStorage.indexExists();
    }

    @Override
    public Analyzer getAnalyzer() {
        return this.runningIndexStorage.getAnalyzer();
    }

    public Map getCurrentStores() {
        return this.currentStores;
    }

    public void setCurrentStores(Map currentStores) {
        this.currentStores = currentStores;
    }

    public IndexStorage getDefaultIndexStorage() {
        return this.defaultIndexStorage;
    }

    public void setDefaultIndexStorage(IndexStorage defaultIndexStorage) {
        this.defaultIndexStorage = defaultIndexStorage;
    }

    public String getIndexStorageName() {
        return this.indexStorageName;
    }

    public void setIndexStorageName(String indexStorageName) {
        this.indexStorageName = indexStorageName;
    }

    public IndexStorage getRunningIndexStorage() {
        return this.runningIndexStorage;
    }

    public void setRunningIndexStorage(IndexStorage runningIndexStorage) {
        this.runningIndexStorage = runningIndexStorage;
    }

    @Override
    public void setRecoverCorruptedIndex(boolean recover) {
        this.recover = recover;
    }

    @Override
    public long getLastUpdate() {
        return this.runningIndexStorage.getLastUpdate();
    }

    @Override
    public List getSegmentInfoList() {
        return this.runningIndexStorage.getSegmentInfoList();
    }

    @Override
    public void closeIndexReader(IndexReader indexReader) throws IOException {
        this.runningIndexStorage.closeIndexReader(indexReader);
    }

    @Override
    public void closeIndexWriter(IndexWriter indexWrite) throws IOException {
        this.runningIndexStorage.closeIndexWriter(indexWrite);
    }

    @Override
    public boolean isMultipleIndexers() {
        return this.runningIndexStorage.isMultipleIndexers();
    }

    @Override
    public void closeIndexSearcher(IndexSearcher indexSearcher) {
        this.runningIndexStorage.closeIndexSearcher(indexSearcher);
    }

    public void disableDiagnostics() {
        this.runningIndexStorage.disableDiagnostics();
    }

    public void enableDiagnostics() {
        this.runningIndexStorage.enableDiagnostics();
    }

    public boolean hasDiagnostics() {
        return this.runningIndexStorage.hasDiagnostics();
    }

    @Override
    public boolean centralIndexExists() {
        return this.runningIndexStorage.centralIndexExists();
    }

    @Override
    public void addReloadListener(IndexReloadListener indexReloadListener) {
        this.runningIndexStorage.addReloadListener(indexReloadListener);
    }

    @Override
    public void forceNextReload() {
        this.runningIndexStorage.forceNextReload();
    }

    @Override
    public IndexSearcher getIndexSearcher(boolean reload) throws IOException {
        return this.runningIndexStorage.getIndexSearcher(reload);
    }

    @Override
    public long getLastLoad() {
        return this.runningIndexStorage.getLastLoad();
    }

    @Override
    public long getLastLoadTime() {
        return this.runningIndexStorage.getLastLoadTime();
    }

    @Override
    public void removeReloadListener(IndexReloadListener indexReloadListener) {
        this.runningIndexStorage.removeReloadListener(indexReloadListener);
    }

    @Override
    public Directory getSpellDirectory() {
        return null;
    }
}

