/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.search.index.impl;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sakaiproject.search.index.SegmentInfo;

public class SegmentState {
    private static final String VERSION = "1.0";
    private static final Log log = LogFactory.getLog(SegmentState.class);
    private Map<String, FileRecord> fileRecords;
    private long timeStamp = System.currentTimeMillis();
    private String name;

    public SegmentState(SegmentInfo segInfo, File timestampFile) throws IOException {
        this.name = segInfo.getName();
        if (timestampFile == null) {
            this.analyze(segInfo);
        } else {
            this.load(timestampFile);
        }
    }

    public void save(File checksumFile) throws IOException {
        File tmpFile = new File(checksumFile.getAbsolutePath() + ".tmp");
        FileWriter fw = null;
        try {
            fw = new FileWriter(tmpFile);
            fw.append(VERSION).append("\n");
            fw.append(String.valueOf(this.timeStamp)).append("\n");
            for (FileRecord fr : this.fileRecords.values()) {
                fw.append(fr.path).append(";");
                fw.append(fr.checksum).append(";");
                fw.append(String.valueOf(fr.length)).append(";");
                fw.append(String.valueOf(fr.lastMod)).append(";\n");
            }
        }
        catch (IOException e) {
            throw new IOException();
        }
        finally {
            if (fw != null) {
                fw.close();
            }
        }
        if (!tmpFile.renameTo(checksumFile)) {
            log.warn((Object)("unable to rename " + tmpFile.getPath() + " to " + checksumFile.getPath()));
        }
    }

    private void load(File checksumFile) throws IOException {
        this.fileRecords = new HashMap<String, FileRecord>();
        BufferedReader fr = new BufferedReader(new FileReader(checksumFile));
        String version = fr.readLine();
        if (VERSION.equals(version)) {
            String ts = fr.readLine();
            this.timeStamp = Long.parseLong(ts);
            String line = fr.readLine();
            while (line != null) {
                String[] elements = line.split(";");
                FileRecord infr = new FileRecord();
                infr.path = elements[0];
                infr.checksum = elements[1];
                infr.length = Long.parseLong(elements[2]);
                infr.lastMod = Long.parseLong(elements[3]);
                this.fileRecords.put(infr.path, infr);
                line = fr.readLine();
            }
        } else {
            log.warn((Object)("Segment (" + this.name + "): Unrecognized version number " + version));
        }
        fr.close();
    }

    public void analyze(SegmentInfo segInfo) {
        File[] files = segInfo.getSegmentLocation().listFiles();
        String basePath = segInfo.getSegmentLocation().getAbsolutePath();
        this.fileRecords = new HashMap<String, FileRecord>();
        MessageDigest md5 = null;
        try {
            md5 = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            log.error((Object)("Segment (" + this.name + "): MD5 not available "), (Throwable)e);
        }
        byte[] buffer = new byte[4096];
        if (files != null) {
            for (int i = 0; i < files.length; ++i) {
                try {
                    String echecksum = "none";
                    if (md5 != null) {
                        FileInputStream fin = new FileInputStream(files[i]);
                        int len = 0;
                        md5.reset();
                        while ((len = ((InputStream)fin).read(buffer)) > 0) {
                            md5.update(buffer, 0, len);
                        }
                        ((InputStream)fin).close();
                        char[] encoding = "0123456789ABCDEF".toCharArray();
                        byte[] checksum = md5.digest();
                        char[] hexchecksum = new char[checksum.length * 2];
                        for (int j = 0; j < checksum.length; ++j) {
                            int lo = checksum[j] & 0xF;
                            int hi = checksum[j] >> 4 & 0xF;
                            hexchecksum[j * 2] = encoding[lo];
                            hexchecksum[j * 2 + 1] = encoding[hi];
                        }
                        echecksum = new String(hexchecksum);
                    }
                    FileRecord fr = new FileRecord();
                    fr.checksum = echecksum;
                    fr.path = files[i].getAbsolutePath().substring(basePath.length());
                    fr.lastMod = files[i].lastModified();
                    fr.length = files[i].length();
                    this.fileRecords.put(fr.path, fr);
                    continue;
                }
                catch (Exception ex) {
                    log.error((Object)("Segment (" + this.name + "): Failed to generate checksum of " + files[i].getAbsolutePath()), (Throwable)ex);
                }
            }
        }
    }

    public long getTimeStamp() {
        return this.timeStamp;
    }

    public void setTimeStamp(long timeStamp) {
        this.timeStamp = timeStamp;
    }

    public boolean checkValidity(boolean logging, String message, SegmentState storedSegmentState) {
        if (storedSegmentState == null) {
            if (logging) {
                log.info((Object)("Segment (" + this.name + "): The segment has no stored state, it may be new or it could be dammaged "));
            }
            return true;
        }
        StringBuilder sb = new StringBuilder();
        if (this.timeStamp > storedSegmentState.getTimeStamp()) {
            sb.append(" This Segment has been modified ").append(this.name).append("\n");
        }
        for (FileRecord fr : this.fileRecords.values()) {
            FileRecord sfr = storedSegmentState.getFileRecord(fr.path);
            String differences = fr.diff(sfr);
            sb.append("   Checking [").append(fr).append("]==[").append(sfr).append("] ").append(differences).append("\n");
        }
        Iterator<FileRecord> i = storedSegmentState.iterator();
        while (i.hasNext()) {
            FileRecord sfr = i.next();
            FileRecord fr = this.fileRecords.get(sfr.path);
            if (fr != null) continue;
            sb.append("   Dropped ").append("").append("\n");
        }
        if (logging) {
            log.info((Object)("Segment (" + this.name + "): Checked " + this.name + "\n" + sb.toString()));
        }
        return true;
    }

    private Iterator<FileRecord> iterator() {
        return this.fileRecords.values().iterator();
    }

    private FileRecord getFileRecord(String path) {
        return this.fileRecords.get(path);
    }

    public class FileRecord {
        public long length;
        public long lastMod;
        public String path;
        public String checksum = "none";

        public String diff(FileRecord sfr) {
            StringBuilder sb = new StringBuilder();
            if (sfr == null) {
                return "new file";
            }
            if (!this.path.equals(sfr.path)) {
                return "[not the same file]";
            }
            int mod = 0;
            if (!this.checksum.equals(sfr.checksum)) {
                sb.append("content changed,");
                ++mod;
            }
            if (this.lastMod > sfr.lastMod) {
                sb.append("newer;");
                ++mod;
            } else if (this.lastMod < sfr.lastMod) {
                sb.append("older;");
                ++mod;
            } else {
                sb.append("same age;");
            }
            if (this.length > sfr.length) {
                sb.append("larger;");
                ++mod;
            } else if (this.length < sfr.length) {
                sb.append("smaller;");
                ++mod;
            } else {
                sb.append("same size;");
            }
            if (mod != 0) {
                return sb.toString();
            }
            return "identical";
        }

        public String toString() {
            return this.path + ";" + new Date(this.lastMod) + ";" + this.length + ";";
        }
    }
}

