/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.search.journal.impl;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sakaiproject.component.api.ServerConfigurationService;
import org.sakaiproject.search.indexer.api.IndexJournalException;
import org.sakaiproject.search.journal.api.JournalErrorException;
import org.sakaiproject.search.journal.api.JournalExhausetedException;
import org.sakaiproject.search.journal.api.JournalManager;
import org.sakaiproject.search.journal.api.JournalManagerState;
import org.sakaiproject.search.transaction.api.IndexTransaction;

public class DbJournalManager
implements JournalManager {
    private static final Log log = LogFactory.getLog(DbJournalManager.class);
    private DataSource datasource;
    private String serverId;
    private ServerConfigurationService serverConfigurationService;

    public void init() {
        this.serverId = this.serverConfigurationService.getServerId();
    }

    public void destroy() {
    }

    public DataSource getDatasource() {
        return this.datasource;
    }

    public void setDatasource(DataSource datasource) {
        this.datasource = datasource;
    }

    /*
     * Loose catch block
     */
    @Override
    public long getNextSavePoint(long savePoint) throws JournalErrorException {
        Connection connection = null;
        PreparedStatement listLaterSavePoints = null;
        ResultSet rs = null;
        try {
            block20: {
                connection = this.datasource.getConnection();
                listLaterSavePoints = connection.prepareStatement("select txid from search_journal where txid > ? and (status = 'commited' or status = 'committed') order by txid asc ");
                listLaterSavePoints.clearParameters();
                listLaterSavePoints.setLong(1, savePoint);
                rs = listLaterSavePoints.executeQuery();
                if (!rs.next()) break block20;
                long l = rs.getLong(1);
                return l;
            }
            try {
                block21: {
                    break block21;
                    catch (Exception ex) {
                        log.warn((Object)("Shared Index Optimization in progress, pausing updates to this index :" + ex));
                    }
                }
                throw new JournalExhausetedException("No More savePoints available");
            }
            catch (SQLException ex) {
                log.error((Object)"Failed to retrieve list of journal items ", (Throwable)ex);
                throw new JournalErrorException("Journal Error ", ex);
            }
        }
        finally {
            try {
                rs.close();
            }
            catch (Exception ex) {
                log.debug((Object)ex);
            }
            try {
                listLaterSavePoints.close();
            }
            catch (Exception ex) {
                log.debug((Object)ex);
            }
            try {
                connection.close();
            }
            catch (Exception ex) {
                log.debug((Object)ex);
            }
        }
    }

    @Override
    public JournalManagerState prepareSave(long transactionId) throws IndexJournalException {
        Statement insertPst = null;
        JournalManagerStateImpl jms = new JournalManagerStateImpl(transactionId);
        try {
            Connection connection;
            jms.connection = connection = this.datasource.getConnection();
            insertPst = connection.prepareStatement("insert into search_journal (txid, txts, indexwriter, status) values ( ?,?,?,?)");
            insertPst.clearParameters();
            insertPst.setLong(1, transactionId);
            insertPst.setLong(2, System.currentTimeMillis());
            insertPst.setString(3, this.serverId);
            insertPst.setString(4, "prepare");
            if (insertPst.executeUpdate() != 1) {
                throw new IndexJournalException("Failed to update index journal");
            }
        }
        catch (IndexJournalException ijex) {
            throw ijex;
        }
        catch (Exception ex) {
            throw new IndexJournalException("Failed to transfer index ", ex);
        }
        finally {
            try {
                insertPst.close();
            }
            catch (Exception ex) {
                log.debug((Object)ex);
            }
        }
        return jms;
    }

    @Override
    public void commitSave(JournalManagerState jms) throws IndexJournalException {
        Connection connection = ((JournalManagerStateImpl)jms).connection;
        PreparedStatement success = null;
        try {
            success = connection.prepareStatement("update search_journal set status = 'committed' where txid = ? ");
            success.clearParameters();
            success.setLong(1, ((JournalManagerStateImpl)jms).getTransactionId());
            if (success.executeUpdate() != 1) {
                throw new IndexJournalException("Failed to update index journal");
            }
            connection.commit();
        }
        catch (Exception ex) {
            try {
                connection.rollback();
            }
            catch (Exception ex2) {
                log.debug((Object)ex);
            }
            throw new IndexJournalException("Failed to commit index ", ex);
        }
        finally {
            try {
                success.close();
            }
            catch (Exception ex) {
                log.debug((Object)ex);
            }
            try {
                connection.close();
            }
            catch (Exception ex) {
                log.debug((Object)ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rollbackSave(JournalManagerState jms) {
        if (jms != null) {
            Connection connection = ((JournalManagerStateImpl)jms).connection;
            try {
                connection.rollback();
            }
            catch (Exception ex) {
                log.error((Object)"Failed to Rollback");
            }
            finally {
                try {
                    connection.close();
                }
                catch (Exception ex) {
                    log.debug((Object)ex);
                }
            }
        }
    }

    @Override
    public void doOpenTransaction(IndexTransaction transaction) {
    }

    public ServerConfigurationService getServerConfigurationService() {
        return this.serverConfigurationService;
    }

    public void setServerConfigurationService(ServerConfigurationService serverConfigurationService) {
        this.serverConfigurationService = serverConfigurationService;
    }

    private static class JournalManagerStateImpl
    implements JournalManagerState {
        private long transactionId;
        public Connection connection;

        public JournalManagerStateImpl(long transactionId) {
            this.transactionId = transactionId;
        }

        public long getTransactionId() {
            return this.transactionId;
        }
    }
}

