/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.search.journal.impl;

import java.io.File;
import java.io.IOException;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.sakaiproject.search.indexer.impl.SearchBuilderItemSerializer;
import org.sakaiproject.search.journal.api.IndexMergeTransaction;
import org.sakaiproject.search.journal.api.JournalErrorException;
import org.sakaiproject.search.journal.api.JournalManager;
import org.sakaiproject.search.journal.api.JournalStorage;
import org.sakaiproject.search.journal.api.JournaledIndex;
import org.sakaiproject.search.journal.api.JournaledObject;
import org.sakaiproject.search.journal.api.MergeTransactionListener;
import org.sakaiproject.search.model.SearchBuilderItem;
import org.sakaiproject.search.transaction.api.IndexTransaction;
import org.sakaiproject.search.transaction.api.IndexTransactionException;

public class JournaledFSIndexStorageUpdateTransactionListener
implements MergeTransactionListener {
    private static final Log log = LogFactory.getLog(JournaledFSIndexStorageUpdateTransactionListener.class);
    private JournaledIndex journaledIndex;
    private JournalManager journalManager;
    private SearchBuilderItemSerializer searchBuilderItemSerializer = new SearchBuilderItemSerializer();
    private JournalStorage journalStorage;

    public void init() {
    }

    public void destroy() {
    }

    @Override
    public void open(IndexTransaction transaction) throws IndexTransactionException {
        long lastJournalEntry = this.journaledIndex.getLastJournalEntry();
        long thisJournalEntry = this.journaledIndex.getJournalSavePoint();
        long nextJournalEntry = this.journalManager.getNextSavePoint(thisJournalEntry);
        if (nextJournalEntry == lastJournalEntry) {
            throw new JournalErrorException("Journal is stalled at ID " + lastJournalEntry);
        }
        this.journaledIndex.setLastJournalEntry(nextJournalEntry);
        ((IndexMergeTransaction)transaction).setJournalEntry(nextJournalEntry);
        transaction.put(JournaledObject.class.getName() + ".thisJournalEntry", thisJournalEntry);
    }

    @Override
    public void prepare(IndexTransaction transaction) throws IndexTransactionException {
        long journalEntry = ((IndexMergeTransaction)transaction).getJournalEntry();
        if (journalEntry == -1L) {
            throw new JournalErrorException("No target journal entry ");
        }
        try {
            String workingSpace = this.journaledIndex.getWorkingSpace();
            this.journalStorage.retrieveSavePoint(journalEntry, workingSpace);
            File f = new File(workingSpace, String.valueOf(journalEntry));
            File segments = new File(f, "segments.gen");
            if (segments.exists()) {
                List<SearchBuilderItem> deleteDocuments = this.searchBuilderItemSerializer.loadTransactionList(f);
                if (deleteDocuments.size() > 0) {
                    IndexReader deleteIndexReader = this.journaledIndex.getDeletionIndexReader();
                    log.debug((Object)("Deletion index reader is " + deleteIndexReader));
                    transaction.put(JournaledFSIndexStorageUpdateTransactionListener.class.getName() + ".deleteIndexReader", deleteIndexReader);
                    log.debug((Object)("Deleting documents for savePoint " + journalEntry));
                    for (SearchBuilderItem sbi : deleteDocuments) {
                        if (!SearchBuilderItem.ACTION_DELETE.equals(sbi.getSearchaction()) && !SearchBuilderItem.ACTION_ADD.equals(sbi.getSearchaction())) continue;
                        log.debug((Object)("Deleting " + sbi.getName() + " for savePoint " + journalEntry));
                        int ndel = deleteIndexReader.deleteDocuments(new Term("reference", sbi.getName()));
                        if (ndel == 0) {
                            log.debug((Object)("Tried to delete " + sbi.getName() + " but it was not found in the local index "));
                            continue;
                        }
                        log.debug((Object)("Deleted " + ndel + " in merge"));
                    }
                } else {
                    log.debug((Object)("No Documents to delete for savePoint " + journalEntry));
                }
                log.debug((Object)("Adding segment to journaledIndex " + this.journaledIndex));
                this.journaledIndex.addSegment(f);
            }
        }
        catch (IOException ioex) {
            throw new IndexTransactionException("Failed to delete documents ", ioex);
        }
        log.debug((Object)"Finished");
    }

    @Override
    public void rollback(IndexTransaction transaction) throws IndexTransactionException {
        IndexReader deleteIndexReader = (IndexReader)transaction.get(JournaledFSIndexStorageUpdateTransactionListener.class.getName() + ".deleteIndexReader");
        transaction.clear(JournaledFSIndexStorageUpdateTransactionListener.class.getName() + ".deleteIndexReader");
        try {
            if (deleteIndexReader != null) {
                deleteIndexReader.close();
            }
        }
        catch (IOException e) {
            throw new IndexTransactionException("Failed to close index with deletions ", e);
        }
    }

    @Override
    public void close(IndexTransaction transaction) throws IndexTransactionException {
    }

    @Override
    public void commit(IndexTransaction transaction) throws IndexTransactionException {
        IndexReader deleteIndexReader = (IndexReader)transaction.get(JournaledFSIndexStorageUpdateTransactionListener.class.getName() + ".deleteIndexReader");
        long journalEntry = ((IndexMergeTransaction)transaction).getJournalEntry();
        if (journalEntry == -1L) {
            throw new JournalErrorException("No target journal entry ");
        }
        try {
            if (deleteIndexReader != null) {
                deleteIndexReader.close();
            }
            this.journaledIndex.setJournalIndexEntry(journalEntry);
            this.journaledIndex.saveSegmentList();
            this.journaledIndex.loadIndexReader();
        }
        catch (IOException e) {
            throw new IndexTransactionException("Failed to close index with deletions", e);
        }
        transaction.clear(JournaledFSIndexStorageUpdateTransactionListener.class.getName() + ".deleteIndexReader");
    }

    public JournaledIndex getJournaledIndex() {
        return this.journaledIndex;
    }

    public void setJournaledIndex(JournaledIndex journaledIndex) {
        this.journaledIndex = journaledIndex;
    }

    public JournalManager getJournalManager() {
        return this.journalManager;
    }

    public void setJournalManager(JournalManager journalManager) {
        this.journalManager = journalManager;
    }

    public JournalStorage getJournalStorage() {
        return this.journalStorage;
    }

    public void setJournalStorage(JournalStorage journalStorage) {
        this.journalStorage = journalStorage;
    }
}

