/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.search.journal.impl;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.store.Directory;
import org.sakaiproject.search.journal.api.IndexMonitorListener;

public class MonitoredIndexWriter
extends IndexWriter {
    private List<IndexMonitorListener> indexMonitorListeners = new ArrayList<IndexMonitorListener>();

    public MonitoredIndexWriter(String arg0, Analyzer arg1, boolean arg2) throws IOException {
        super(arg0, arg1, arg2);
    }

    public MonitoredIndexWriter(File arg0, Analyzer arg1, boolean arg2) throws IOException {
        super(arg0, arg1, arg2);
    }

    public MonitoredIndexWriter(Directory arg0, Analyzer arg1, boolean arg2) throws IOException {
        super(arg0, arg1, arg2);
    }

    public synchronized void close() throws IOException {
        super.close();
        this.fireIndexClosed();
    }

    private void fireIndexClosed() {
        for (IndexMonitorListener tl : this.indexMonitorListeners) {
            tl.doIndexMonitorClose(this);
        }
    }

    private List<IndexMonitorListener> getMonitorIndexListeners() {
        return this.indexMonitorListeners;
    }

    public void addMonitorIndexListener(IndexMonitorListener indexListener) {
        ArrayList<IndexMonitorListener> tl = new ArrayList<IndexMonitorListener>();
        tl.addAll(this.indexMonitorListeners);
        tl.add(indexListener);
        this.indexMonitorListeners = tl;
    }

    public void setMonitorIndexListener(List<IndexMonitorListener> indexListeners) {
        ArrayList<IndexMonitorListener> tl = new ArrayList<IndexMonitorListener>();
        tl.addAll(indexListeners);
        this.indexMonitorListeners = tl;
    }
}

