/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.search.transaction.impl;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sakaiproject.search.transaction.api.TransactionSequence;

public class TransactionSequenceImpl
implements TransactionSequence {
    private static final Log log = LogFactory.getLog(TransactionSequenceImpl.class);
    private DataSource datasource;
    private long localId = System.currentTimeMillis();
    private String name = "indexupdate";
    private boolean checked = false;
    private boolean wrap = false;
    private long maxValue = -1L;
    private long minValue = 0L;

    public void destroy() {
    }

    public void init() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void check() {
        if (this.checked) {
            return;
        }
        this.checked = true;
        Connection connection = null;
        Statement stmt = null;
        ResultSet rs = null;
        long txid = this.minValue;
        try {
            connection = this.datasource.getConnection();
            stmt = connection.createStatement();
            rs = stmt.executeQuery("select txid  from search_transaction  where txname = '" + this.name + "'");
            if (!rs.next()) {
                stmt.executeUpdate("insert into search_transaction ( txid, txname ) values (" + this.minValue + ",'" + this.name + "')");
                txid = this.minValue;
            } else {
                txid = rs.getLong(1);
            }
            connection.commit();
        }
        catch (SQLException ex) {
            log.warn((Object)("Failed to check transaction table, ignore for HSQLDB pre-1.9+ versions. " + ex.getMessage()));
        }
        finally {
            try {
                rs.close();
            }
            catch (Exception ex) {
                log.debug((Object)ex);
            }
            try {
                stmt.close();
            }
            catch (Exception ex) {
                log.debug((Object)ex);
            }
            try {
                connection.close();
            }
            catch (Exception ex) {
                log.debug((Object)ex);
            }
        }
        log.debug((Object)("Transaction Sequence " + this.getName() + " Started at " + txid));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getNextId() {
        this.check();
        Connection connection = null;
        Statement selectpst = null;
        Statement updatepst = null;
        Statement resetpst = null;
        ResultSet rs = null;
        try {
            connection = this.datasource.getConnection();
            selectpst = connection.prepareStatement("select txid from search_transaction where txname = '" + this.name + "'");
            resetpst = connection.prepareStatement("update search_transaction set txid = " + this.minValue + "  where  txname = '" + this.name + "'");
            updatepst = connection.prepareStatement("update search_transaction set txid = txid + 1  where  txname = '" + this.name + "'");
            boolean success = false;
            long txid = 0L;
            long retries = 0L;
            while (!success) {
                updatepst.clearParameters();
                boolean bl = success = updatepst.executeUpdate() == 1;
                if (!success) {
                    connection.rollback();
                    ++retries;
                } else {
                    rs = selectpst.executeQuery();
                    if (rs.next()) {
                        txid = rs.getLong(1);
                        if (this.wrap && txid > this.maxValue) {
                            resetpst.clearParameters();
                            boolean bl2 = success = resetpst.executeUpdate() == 1;
                            if (!success) {
                                throw new RuntimeException("Failed to reset ");
                            }
                            success = false;
                        }
                    } else {
                        log.error((Object)"Transaction Record has been removed");
                    }
                    rs.close();
                }
                if (retries <= 10L) continue;
                throw new RuntimeException("Failed to get a transaction, retried 10 times ");
            }
            connection.commit();
            long l = txid;
            return l;
        }
        catch (Exception ex) {
            try {
                connection.rollback();
            }
            catch (Exception ex2) {
                // empty catch block
            }
            log.warn((Object)("Failed to get a transaction id, ignore for HSQLDB pre-1.9+ versions. " + ex.getMessage()));
            long l = -1L;
            return l;
        }
        finally {
            try {
                rs.close();
            }
            catch (Exception ex2) {
                log.debug((Object)ex2);
            }
            try {
                selectpst.close();
            }
            catch (Exception ex2) {
                log.debug((Object)ex2);
            }
            try {
                updatepst.close();
            }
            catch (Exception ex2) {
                log.debug((Object)ex2);
            }
            try {
                resetpst.close();
            }
            catch (Exception ex2) {
                log.debug((Object)ex2);
            }
            try {
                connection.close();
            }
            catch (Exception ex2) {
                log.debug((Object)ex2);
            }
        }
    }

    public DataSource getDatasource() {
        return this.datasource;
    }

    public void setDatasource(DataSource datasource) {
        this.datasource = datasource;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public long getLocalId() {
        long next = this.localId++;
        return next;
    }

    public long getMaxValue() {
        return this.maxValue;
    }

    public void setMaxValue(long maxValue) {
        this.maxValue = maxValue;
        this.wrap = true;
    }

    public long getMinValue() {
        return this.minValue;
    }

    public void setMinValue(long minValue) {
        this.minValue = minValue;
    }
}

