/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.search.util;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.Token;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.queryParser.ParseException;
import org.apache.lucene.queryParser.QueryParser;
import org.apache.lucene.search.PhraseQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.spell.SpellChecker;
import org.apache.lucene.store.Directory;

public class DidYouMeanParser {
    private static Log log = LogFactory.getLog(DidYouMeanParser.class);
    private String defaultField;
    private Directory spellIndexDirectory;
    private IndexReader origionalIndex;

    public DidYouMeanParser(String defaultField, Directory spellIndexDirectory) {
        this.defaultField = defaultField;
        this.spellIndexDirectory = spellIndexDirectory;
    }

    public DidYouMeanParser(String defaultField, Directory spellIndexDirectory, IndexReader origionalIndex) {
        this.defaultField = defaultField;
        this.spellIndexDirectory = spellIndexDirectory;
        this.origionalIndex = origionalIndex;
    }

    public Query parse(String queryString) throws ParseException {
        QueryParser queryParser = new QueryParser(this.defaultField, (Analyzer)new StandardAnalyzer());
        queryParser.setDefaultOperator(QueryParser.Operator.AND);
        return queryParser.parse(queryString);
    }

    public Query suggest(String queryString) throws ParseException {
        QuerySuggester querySuggester = new QuerySuggester(this.defaultField, (Analyzer)new StandardAnalyzer());
        querySuggester.setDefaultOperator(QueryParser.Operator.AND);
        Query query = querySuggester.parse(queryString);
        if (querySuggester.hasSuggestedQuery()) {
            log.info((Object)("got a suggestion: " + query.toString()));
            return query;
        }
        return null;
    }

    private class QuerySuggester
    extends QueryParser {
        private boolean suggestedQuery;

        public QuerySuggester(String field, Analyzer analyzer) {
            super(field, analyzer);
            this.suggestedQuery = false;
        }

        protected Query getFieldQuery(String field, String queryText) throws ParseException {
            TokenStream source = this.getAnalyzer().tokenStream(field, (Reader)new StringReader(queryText));
            Vector<String> v = new Vector<String>();
            while (true) {
                Token t;
                try {
                    t = source.next();
                }
                catch (IOException e) {
                    t = null;
                }
                if (t == null) break;
                v.addElement(t.term());
            }
            try {
                source.close();
            }
            catch (IOException e) {
                // empty catch block
            }
            if (v.size() == 0) {
                return null;
            }
            if (v.size() == 1) {
                return new TermQuery(this.getTerm(field, (String)v.elementAt(0)));
            }
            PhraseQuery q = new PhraseQuery();
            q.setSlop(this.getPhraseSlop());
            for (int i = 0; i < v.size(); ++i) {
                q.add(this.getTerm(field, (String)v.elementAt(i)));
            }
            return q;
        }

        private Term getTerm(String field, String queryText) throws ParseException {
            log.info((Object)("getting similar terms for: " + queryText));
            SpellChecker spellChecker = null;
            try {
                spellChecker = new SpellChecker(DidYouMeanParser.this.spellIndexDirectory);
                if (spellChecker.exist(queryText)) {
                    return new Term(field, queryText);
                }
                String[] similarWords = null;
                similarWords = DidYouMeanParser.this.origionalIndex == null ? spellChecker.suggestSimilar(queryText, 1) : spellChecker.suggestSimilar(queryText, 1, DidYouMeanParser.this.origionalIndex, DidYouMeanParser.this.defaultField, true);
                if (similarWords.length == 0) {
                    log.info((Object)"no suggestions found");
                    return new Term(field, queryText);
                }
                this.suggestedQuery = true;
                log.info((Object)"got a suggestion!");
                return new Term(field, similarWords[0]);
            }
            catch (IOException e) {
                throw new ParseException(e.getMessage());
            }
        }

        public boolean hasSuggestedQuery() {
            return this.suggestedQuery;
        }
    }
}

