/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.search.component.service.impl;

import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Stack;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.search.Query;
import org.sakaiproject.search.api.EntityContentProducer;
import org.sakaiproject.search.api.PortalUrlEnabledProducer;
import org.sakaiproject.search.api.SearchIndexBuilder;
import org.sakaiproject.search.api.SearchList;
import org.sakaiproject.search.api.SearchResult;
import org.sakaiproject.search.api.SearchService;
import org.sakaiproject.search.component.service.impl.SearchResultResponseImpl;
import org.sakaiproject.search.filter.SearchItemFilter;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.XMLReaderFactory;

public class SearchListResponseImpl
implements SearchList,
ContentHandler {
    private static Log log = LogFactory.getLog(SearchListResponseImpl.class);
    private Query query;
    private int start = 0;
    private int end = 500;
    private Analyzer analyzer;
    private SearchItemFilter filter;
    private SearchIndexBuilder searchIndexBuilder;
    private SearchService searchService;
    private List<SearchResult> resultsList;
    private Stack<StackElement> stack;
    private Object errorMessage = null;
    private int size;
    private int fullsize;

    public SearchListResponseImpl(String response, Query query, int start, int end, Analyzer analyzer, SearchItemFilter filter, SearchIndexBuilder searchIndexBuilder, SearchService searchService) throws SAXException, IOException {
        this.query = query;
        this.start = start;
        this.end = end;
        this.analyzer = analyzer;
        this.filter = filter;
        this.searchIndexBuilder = searchIndexBuilder;
        this.searchService = searchService;
        if (log.isDebugEnabled()) {
            log.debug((Object)("search response: [" + response + "]"));
        }
        XMLReader xr = XMLReaderFactory.createXMLReader();
        xr.setContentHandler(this);
        InputSource is = new InputSource(new StringReader(response));
        xr.parse(is);
        if (this.errorMessage != null) {
            log.error((Object)("Failed to perform remote request, remote exception was: \n" + this.errorMessage));
            throw new IOException("Failed to perform remote request ");
        }
    }

    public Iterator<SearchResult> iterator(final int startAt) {
        return new Iterator<SearchResult>(){
            int counter;
            {
                this.counter = Math.max(startAt, SearchListResponseImpl.this.start) - SearchListResponseImpl.this.start;
            }

            @Override
            public boolean hasNext() {
                return this.counter < SearchListResponseImpl.this.resultsList.size();
            }

            @Override
            public SearchResult next() {
                SearchResult ret;
                String url;
                int thisHit = this.counter++;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Iterator Getting item " + thisHit));
                }
                if ((url = this.checkUrl((ret = (SearchResult)SearchListResponseImpl.this.resultsList.get(thisHit)).getReference())) != null) {
                    ret.setUrl(url);
                }
                return SearchListResponseImpl.this.filter.filter(ret);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Not Implemented");
            }

            private String checkUrl(String reference) {
                log.debug((Object)("checkUrl(" + reference));
                if (SearchListResponseImpl.this.searchIndexBuilder != null) {
                    EntityContentProducer ecp = SearchListResponseImpl.this.searchIndexBuilder.newEntityContentProducer(reference);
                    if (ecp == null) {
                        return null;
                    }
                    if (PortalUrlEnabledProducer.class.isAssignableFrom(ecp.getClass())) {
                        return ecp.getUrl(reference);
                    }
                }
                return null;
            }
        };
    }

    public int size() {
        return this.size;
    }

    public int getFullSize() {
        return this.fullsize;
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public boolean contains(Object arg0) {
        throw new UnsupportedOperationException("Not Implemented");
    }

    public Iterator<SearchResult> iterator() {
        return this.iterator(0);
    }

    public Object[] toArray() {
        Object[] o = new Object[this.size()];
        for (int i = 0; i < o.length; ++i) {
            o[i] = this.filter.filter(this.resultsList.get(i));
        }
        return o;
    }

    public Object[] toArray(Object[] arg0) {
        if (arg0 instanceof SearchResult[]) {
            return this.toArray();
        }
        return null;
    }

    public boolean add(SearchResult arg0) {
        throw new UnsupportedOperationException("Not Implemented");
    }

    public boolean remove(Object arg0) {
        throw new UnsupportedOperationException("Not Implemented");
    }

    public boolean containsAll(Collection arg0) {
        throw new UnsupportedOperationException("Not Implemented");
    }

    public boolean addAll(Collection arg0) {
        throw new UnsupportedOperationException("Not Implemented");
    }

    public boolean addAll(int arg0, Collection arg1) {
        throw new UnsupportedOperationException("Not Implemented");
    }

    public boolean removeAll(Collection arg0) {
        throw new UnsupportedOperationException("Not Implemented");
    }

    public boolean retainAll(Collection arg0) {
        throw new UnsupportedOperationException("Not Implemented");
    }

    public void clear() {
        throw new UnsupportedOperationException("Not Implemented");
    }

    public SearchResult get(int arg0) {
        SearchResult sr = this.resultsList.get(arg0);
        String url = this.checkUrl(sr.getReference());
        if (url != null) {
            sr.setUrl(url);
        }
        return this.filter.filter(sr);
    }

    public SearchResult set(int arg0, SearchResult arg1) {
        throw new UnsupportedOperationException("Not Implemented");
    }

    public void add(int arg0, SearchResult arg1) {
        throw new UnsupportedOperationException("Not Implemented");
    }

    public SearchResult remove(int arg0) {
        throw new UnsupportedOperationException("Not Implemented");
    }

    public int indexOf(Object arg0) {
        throw new UnsupportedOperationException("Not Implemented");
    }

    public int lastIndexOf(Object arg0) {
        throw new UnsupportedOperationException("Not Implemented");
    }

    public ListIterator<SearchResult> listIterator() {
        throw new UnsupportedOperationException("Not Implemented");
    }

    public ListIterator<SearchResult> listIterator(int arg0) {
        throw new UnsupportedOperationException("Not Implemented");
    }

    public List<SearchResult> subList(int arg0, int arg1) {
        throw new UnsupportedOperationException("Not Implemented");
    }

    public int getStart() {
        return this.start;
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        StackElement se = this.stack.peek();
        se.append(ch, start, length);
    }

    @Override
    public void endDocument() throws SAXException {
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("End Element uri:" + uri + " ln:" + localName + " qn:" + qName));
        }
        StackElement se = this.stack.pop();
        if ("error".equals(localName)) {
            this.errorMessage = se.getContent();
            log.error((Object)("Error Message found from remote search " + this.errorMessage));
        } else if ("result".equals(localName)) {
            SearchResultResponseImpl sr;
            try {
                sr = new SearchResultResponseImpl(se.getAttributes(), this.query, this.analyzer, this.searchIndexBuilder, this.searchService);
            }
            catch (IOException e) {
                throw new SAXException(e.getMessage(), e);
            }
            this.resultsList.add(sr);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Added Search Result " + this.resultsList.size()));
            }
        } else if ("results".equals(localName)) {
            this.fullsize = Integer.parseInt(se.getAttributes().getValue("fullsize"));
            this.start = Integer.parseInt(se.getAttributes().getValue("start"));
            this.size = Integer.parseInt(se.getAttributes().getValue("size"));
        }
    }

    @Override
    public void endPrefixMapping(String prefix) throws SAXException {
    }

    @Override
    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
    }

    @Override
    public void processingInstruction(String target, String data) throws SAXException {
    }

    @Override
    public void setDocumentLocator(Locator locator) {
    }

    @Override
    public void skippedEntity(String name) throws SAXException {
    }

    @Override
    public void startDocument() throws SAXException {
        this.resultsList = new ArrayList<SearchResult>();
        this.stack = new Stack();
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Start Element uri:" + uri + " ln:" + localName + " qn:" + qName));
        }
        StackElement se = new StackElement(uri, localName, qName, atts);
        this.stack.push(se);
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) throws SAXException {
    }

    private String checkUrl(String reference) {
        if (this.searchIndexBuilder != null) {
            EntityContentProducer ecp = this.searchIndexBuilder.newEntityContentProducer(reference);
            if (ecp == null) {
                return null;
            }
            if (PortalUrlEnabledProducer.class.isAssignableFrom(ecp.getClass())) {
                return ecp.getUrl(reference);
            }
        }
        return null;
    }

    public class StackElement {
        private String uri;
        private String localName;
        private String name;
        private Attributes atts;
        private StringBuilder content;

        public StackElement(String uri, String localName, String name, Attributes atts) {
            this.uri = uri;
            this.localName = localName;
            this.name = name;
            this.atts = new AttributesImpl(atts);
            this.content = new StringBuilder();
        }

        public Attributes getAttributes() {
            return this.atts;
        }

        public String getContent() {
            return this.content.toString();
        }

        public void append(char[] ch, int start, int length) {
            this.content.append(ch, start, length);
        }
    }
}

