/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.search.component.service.impl;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.search.Hits;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.highlight.Encoder;
import org.apache.lucene.search.highlight.Formatter;
import org.apache.lucene.search.highlight.Highlighter;
import org.apache.lucene.search.highlight.InvalidTokenOffsetsException;
import org.apache.lucene.search.highlight.QueryScorer;
import org.apache.lucene.search.highlight.Scorer;
import org.apache.lucene.search.highlight.SimpleHTMLEncoder;
import org.apache.lucene.search.highlight.SimpleHTMLFormatter;
import org.sakaiproject.search.api.EntityContentProducer;
import org.sakaiproject.search.api.PortalUrlEnabledProducer;
import org.sakaiproject.search.api.SearchIndexBuilder;
import org.sakaiproject.search.api.SearchResult;
import org.sakaiproject.search.api.SearchService;
import org.sakaiproject.search.api.StoredDigestContentProducer;
import org.sakaiproject.search.api.TermFrequency;
import org.sakaiproject.search.component.Messages;
import org.sakaiproject.search.util.DigestStorageUtil;

public class SearchResultImpl
implements SearchResult {
    private static Log log = LogFactory.getLog(SearchResultImpl.class);
    private Hits h;
    private int index;
    private Document doc;
    String[] fieldNames = null;
    private Query query = null;
    private Analyzer analyzer = null;
    private SearchIndexBuilder searchIndexBuilder;
    private SearchService searchService;
    private String url;

    public SearchResultImpl(Hits h, int index, Query query, Analyzer analyzer, SearchIndexBuilder searchIndexBuilder, SearchService searchService) throws IOException {
        this.h = h;
        this.index = index;
        this.doc = h.doc(index);
        this.query = query;
        this.analyzer = analyzer;
        this.searchIndexBuilder = searchIndexBuilder;
        this.searchService = searchService;
    }

    public float getScore() {
        try {
            return this.h.score(this.index);
        }
        catch (IOException e) {
            throw new RuntimeException("Cant determine score ", e);
        }
    }

    public String getId() {
        return this.doc.get("id");
    }

    public String[] getFieldNames() {
        if (this.fieldNames != null) {
            return this.fieldNames;
        }
        HashMap<String, Field> al = new HashMap<String, Field>();
        List e = this.doc.getFields();
        for (int i = 0; i < e.size(); ++i) {
            Field f = (Field)e.get(i);
            al.put(f.name(), f);
        }
        this.fieldNames = new String[al.size()];
        int ii = 0;
        Iterator i = al.keySet().iterator();
        while (i.hasNext()) {
            this.fieldNames[ii++] = (String)i.next();
        }
        return this.fieldNames;
    }

    public String[] getValues(String fieldName) {
        return this.doc.getValues(fieldName);
    }

    public Map<String, String[]> getValueMap() {
        HashMap<String, String[]> hm = new HashMap<String, String[]>();
        String[] fieldNames = this.getFieldNames();
        for (int i = 0; i < fieldNames.length; ++i) {
            hm.put(fieldNames[i], this.doc.getValues(fieldNames[i]));
        }
        return hm;
    }

    public String getUrl() {
        if (this.url == null) {
            this.url = this.doc.get("url");
        }
        return this.url;
    }

    public String getTitle() {
        return this.doc.get("title");
    }

    public String getTool() {
        return this.doc.get("tool");
    }

    public int getIndex() {
        return this.index;
    }

    public String getSearchResult() {
        try {
            QueryScorer scorer = new QueryScorer(this.query);
            Highlighter hightlighter = new Highlighter((Formatter)new SimpleHTMLFormatter(), (Encoder)new SimpleHTMLEncoder(), (Scorer)scorer);
            StringBuilder sb = new StringBuilder();
            String[] references = this.doc.getValues("reference");
            DigestStorageUtil digestStorageUtil = new DigestStorageUtil(this.searchService);
            if (references != null && references.length > 0) {
                for (int i = 0; i < references.length; ++i) {
                    EntityContentProducer sep = this.searchIndexBuilder.newEntityContentProducer(references[i]);
                    if (sep == null) continue;
                    if (sep instanceof StoredDigestContentProducer) {
                        String digestCount = this.doc.get("digestCount");
                        if (digestCount == null) {
                            digestCount = "1";
                        }
                        log.debug((Object)("This file possibly has FS digests with index of " + digestCount));
                        StringBuilder sb1 = digestStorageUtil.getFileContents(this.doc.get("reference"), digestCount);
                        if (sb1.length() > 0) {
                            sb.append((CharSequence)sb1);
                            continue;
                        }
                        String digest = sep.getContent(references[i]);
                        sb.append(digest);
                        digestStorageUtil.saveContentToStore(this.doc.get("reference"), sb.toString(), 1);
                        continue;
                    }
                    sb.append(sep.getContent(references[i]));
                }
            }
            String text = sb.toString();
            TokenStream tokenStream = this.analyzer.tokenStream("contents", (Reader)new StringReader(text));
            return hightlighter.getBestFragments(tokenStream, text, 5, " ... ");
        }
        catch (IOException e) {
            return Messages.getString("SearchResultImpl.2") + e.getMessage();
        }
        catch (InvalidTokenOffsetsException e) {
            return Messages.getString("SearchResultResponseImpl.11") + e.getMessage();
        }
    }

    public String getReference() {
        return this.doc.get("reference");
    }

    public TermFrequency getTerms() throws IOException {
        return this.searchService.getTerms(this.h.id(this.index));
    }

    public void toXMLString(StringBuilder sb) {
        sb.append("<result");
        sb.append(" index=\"").append(this.getIndex()).append("\" ");
        sb.append(" score=\"").append(this.getScore()).append("\" ");
        sb.append(" sid=\"").append(StringEscapeUtils.escapeXml((String)this.getId())).append("\" ");
        sb.append(" site=\"").append(StringEscapeUtils.escapeXml((String)this.getSiteId())).append("\" ");
        sb.append(" reference=\"").append(StringEscapeUtils.escapeXml((String)this.getReference())).append("\" ");
        try {
            sb.append(" title=\"").append(new String(Base64.encodeBase64((byte[])this.getTitle().getBytes("UTF-8")), "UTF-8")).append("\" ");
        }
        catch (UnsupportedEncodingException e) {
            sb.append(" title=\"").append(StringEscapeUtils.escapeXml((String)this.getTitle())).append("\" ");
        }
        sb.append(" tool=\"").append(StringEscapeUtils.escapeXml((String)this.getTool())).append("\" ");
        sb.append(" url=\"").append(StringEscapeUtils.escapeXml((String)this.getUrl())).append("\" />");
    }

    public String getSiteId() {
        return this.doc.get("siteid");
    }

    public boolean isCensored() {
        return false;
    }

    public void setUrl(String newUrl) {
        this.url = newUrl;
    }

    public boolean hasPortalUrl() {
        log.debug((Object)("hasPortalUrl(" + this.getReference()));
        EntityContentProducer sep = this.searchIndexBuilder.newEntityContentProducer(this.getReference());
        if (sep != null) {
            log.debug((Object)("got ECP for " + this.getReference()));
            if (PortalUrlEnabledProducer.class.isAssignableFrom(sep.getClass())) {
                log.debug((Object)"has portalURL!");
                return true;
            }
        }
        return false;
    }
}

