/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.search.journal.impl;

import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sakaiproject.search.journal.impl.SegmentListStore;

public class SegmentListWriter {
    private File out;
    private Log log = LogFactory.getLog(SegmentListWriter.class);

    public SegmentListWriter(File out) {
        this.out = out;
    }

    public void write(List<File> segments) throws IOException {
        if (!(this.out.exists() || this.out.getParentFile().exists() || this.out.getParentFile().mkdirs())) {
            throw new IOException("Can't create folder " + this.out.getParentFile().getPath());
        }
        FileOutputStream fout = new FileOutputStream(this.out);
        DataOutputStream dout = new DataOutputStream(fout);
        dout.write(SegmentListStore.SEGMENT_LIST_SIGNATURE);
        dout.writeInt(1);
        dout.writeInt(segments.size());
        StringBuilder sb = new StringBuilder();
        sb.append(segments.size()).append(" Segments \n");
        for (File segs : segments) {
            String s = segs.getAbsolutePath();
            sb.append("\t").append(s).append("\n");
            dout.writeUTF(s);
        }
        dout.close();
        fout.close();
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Saved: " + sb.toString()));
        }
    }
}

