/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.search.optimize.shared.impl;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.Term;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.sakaiproject.search.indexer.impl.SearchBuilderItemSerializer;
import org.sakaiproject.search.journal.impl.JournalSettings;
import org.sakaiproject.search.model.SearchBuilderItem;
import org.sakaiproject.search.optimize.api.OptimizeTransactionListener;
import org.sakaiproject.search.optimize.api.OptimizedFailedIndexTransactionException;
import org.sakaiproject.search.optimize.shared.api.JournalOptimizationTransaction;
import org.sakaiproject.search.transaction.api.IndexTransaction;
import org.sakaiproject.search.transaction.api.IndexTransactionException;
import org.sakaiproject.search.util.FileUtils;

public class OptimizeSharedTransactionListenerImpl
implements OptimizeTransactionListener {
    private static final Log log = LogFactory.getLog(OptimizeSharedTransactionListenerImpl.class);
    private SearchBuilderItemSerializer searchBuilderItemSerializer = new SearchBuilderItemSerializer();
    private JournalSettings journalSettings;

    public void init() {
    }

    public void destroy() {
    }

    @Override
    public void close(IndexTransaction transaction) throws IndexTransactionException {
    }

    @Override
    public void commit(IndexTransaction transaction) throws IndexTransactionException {
        try {
            JournalOptimizationTransaction jtransaction = (JournalOptimizationTransaction)transaction;
            File workingSegment = jtransaction.getWorkingSegment();
            if (workingSegment != null) {
                FileUtils.deleteAll((File)workingSegment);
            }
        }
        catch (Exception ex) {
            log.warn((Object)"Failed to rollback ", (Throwable)ex);
        }
    }

    @Override
    public void open(IndexTransaction transaction) throws IndexTransactionException {
    }

    @Override
    public void prepare(IndexTransaction transaction) throws IndexTransactionException {
        IndexReader reader = null;
        IndexWriter indexWriter = null;
        try {
            JournalOptimizationTransaction jtransaction = (JournalOptimizationTransaction)transaction;
            String indexWorkingSpace = jtransaction.getWorkingSpace();
            long targetSavePoint = jtransaction.getTargetSavePoint();
            List<File> optimizableSegments = jtransaction.getMergeSegmentList();
            File workingSegment = new File(indexWorkingSpace, targetSavePoint + "." + System.currentTimeMillis());
            jtransaction.setWorkingSegment(workingSegment);
            FSDirectory workingDirectory = FSDirectory.open((File)workingSegment);
            long mergeStart = System.currentTimeMillis();
            indexWriter = new IndexWriter((Directory)workingDirectory, jtransaction.getAnalyzer(), true, IndexWriter.MaxFieldLength.UNLIMITED);
            indexWriter.setUseCompoundFile(true);
            indexWriter.setMaxMergeDocs(this.journalSettings.getSharedMaxMergeDocs());
            indexWriter.setMaxBufferedDocs(this.journalSettings.getSharedMaxBufferedDocs());
            indexWriter.setMergeFactor(this.journalSettings.getSharedMaxMergeFactor());
            boolean reverseMerge = true;
            StringBuilder timings = new StringBuilder();
            if (reverseMerge) {
                HashMap<String, String> deletedReferences = new HashMap<String, String>();
                for (int i = optimizableSegments.size() - 1; i >= 0; --i) {
                    File f = optimizableSegments.get(i);
                    FSDirectory d = FSDirectory.open((File)f);
                    long start = System.currentTimeMillis();
                    reader = IndexReader.open((Directory)d, (boolean)false);
                    for (String toDelete : deletedReferences.values()) {
                        reader.deleteDocuments(new Term("reference", toDelete));
                    }
                    reader.close();
                    indexWriter.addIndexesNoOptimize(new Directory[]{d});
                    indexWriter.optimize();
                    List<SearchBuilderItem> deleteDocuments = this.searchBuilderItemSerializer.loadTransactionList(f);
                    for (SearchBuilderItem sbi : deleteDocuments) {
                        if (!SearchBuilderItem.ACTION_DELETE.equals(sbi.getSearchaction())) continue;
                        deletedReferences.put(sbi.getName(), sbi.getName());
                    }
                    this.searchBuilderItemSerializer.removeTransactionList(f);
                    long end = System.currentTimeMillis();
                    log.info((Object)("Merged SavePoint " + f + " in " + (end - start) + " ms " + f.getPath()));
                    timings.append("\n\tMerged SavePoint ").append(f.getName()).append(" in ").append(end - start).append(" ms ");
                }
            } else {
                for (File f : optimizableSegments) {
                    FSDirectory d = FSDirectory.open((File)f);
                    long start = System.currentTimeMillis();
                    reader = IndexReader.open((Directory)d, (boolean)false);
                    List<SearchBuilderItem> deleteDocuments = this.searchBuilderItemSerializer.loadTransactionList(f);
                    for (SearchBuilderItem sbi : deleteDocuments) {
                        if (!SearchBuilderItem.ACTION_DELETE.equals(sbi.getSearchaction())) continue;
                        reader.deleteDocuments(new Term("reference", sbi.getName()));
                    }
                    reader.close();
                    indexWriter.addIndexesNoOptimize(new Directory[]{d});
                    indexWriter.optimize();
                    this.searchBuilderItemSerializer.removeTransactionList(f);
                    long end = System.currentTimeMillis();
                    log.info((Object)("Merged SavePoint " + f + " in " + (end - start) + " ms " + f.getPath()));
                    timings.append("\n\tMerged SavePoint ").append(f.getName()).append(" in ").append(end - start).append(" ms ");
                }
            }
            long start = System.currentTimeMillis();
            indexWriter.optimize();
            indexWriter.commit();
            indexWriter.close();
            long end = System.currentTimeMillis();
            log.info((Object)("Optimized Working SavePoint in " + (end - start) + " ms "));
            timings.append("\n\tOptimized Working SavePoint in ").append(end - start).append(" ms ");
            timings.append("\n\tTotal Shared Optimize Merge Time (no transfer) ").append(end - mergeStart).append(" ms ");
            log.info((Object)("Shared Optimize Timings " + timings.toString() + "\n"));
        }
        catch (IOException e) {
            throw new OptimizedFailedIndexTransactionException("Failed to Optimize indexes ", e);
        }
        finally {
            try {
                reader.close();
            }
            catch (Exception ex) {
                log.debug((Object)ex);
            }
            try {
                indexWriter.close();
            }
            catch (Exception ex) {
                log.debug((Object)ex);
            }
        }
    }

    @Override
    public void rollback(IndexTransaction transaction) throws IndexTransactionException {
        try {
            JournalOptimizationTransaction jtransaction = (JournalOptimizationTransaction)transaction;
            File workingSegment = jtransaction.getWorkingSegment();
            if (workingSegment != null) {
                FileUtils.deleteAll((File)workingSegment);
            }
        }
        catch (Exception ex) {
            log.warn((Object)"Failed to rollback ", (Throwable)ex);
        }
    }

    public JournalSettings getJournalSettings() {
        return this.journalSettings;
    }

    public void setJournalSettings(JournalSettings journalSettings) {
        this.journalSettings = journalSettings;
    }
}

