/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.search.component.service.impl;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import java.util.UUID;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sakaiproject.component.api.ServerConfigurationService;
import org.sakaiproject.component.cover.ComponentManager;
import org.sakaiproject.entity.api.EntityManager;
import org.sakaiproject.event.api.EventTrackingService;
import org.sakaiproject.search.api.SearchIndexBuilderWorker;
import org.sakaiproject.search.api.SearchService;
import org.sakaiproject.search.component.service.impl.SearchIndexBuilderImpl;
import org.sakaiproject.search.dao.SearchIndexBuilderWorkerDao;
import org.sakaiproject.search.indexer.api.IndexQueueListener;
import org.sakaiproject.search.model.SearchBuilderItem;
import org.sakaiproject.search.model.SearchWriterLock;
import org.sakaiproject.search.model.impl.SearchWriterLockImpl;
import org.sakaiproject.tool.api.SessionManager;
import org.sakaiproject.user.api.UserDirectoryService;

public class SearchIndexBuilderWorkerImpl
implements Runnable,
SearchIndexBuilderWorker {
    private static Log log = LogFactory.getLog(SearchIndexBuilderWorkerImpl.class);
    public static final String LOCKKEY = "searchlockkey";
    protected static final Object GLOBAL_CONTEXT = null;
    private static final String NO_NODE = "none";
    private static final String NODE_LOCK = "nodelockkey";
    private final int numThreads = 2;
    public long sleepTime = 300000L;
    private long loadFactor = 1000L;
    private Thread[] indexBuilderThread = new Thread[2];
    private Object threadStartLock = new Object();
    private SearchIndexBuilderImpl searchIndexBuilder = null;
    private SearchService searchService = null;
    private ServerConfigurationService serverConfigurationService;
    private DataSource dataSource = null;
    private Object sem = new Object();
    private boolean enabled = false;
    private SessionManager sessionManager;
    private UserDirectoryService userDirectoryService;
    private EntityManager entityManager;
    private EventTrackingService eventTrackingService;
    private boolean runThreads = false;
    private ThreadLocal<String> nodeIDHolder = new ThreadLocal();
    private SearchIndexBuilderWorkerDao searchIndexBuilderWorkerDao = null;
    private long lastLock = System.currentTimeMillis();
    private long lastEvent = System.currentTimeMillis();
    private long lastIndex;
    private long startDocIndex;
    private String nowIndexing;
    private String lastIndexing;
    private boolean soakTest = false;
    private boolean started = false;
    private boolean indexExists = false;
    private static HashMap<String, String> nodeIDList = new HashMap();
    private static String lockedTo = null;
    private static String SELECT_LOCK_SQL = "select id, nodename, lockkey, expires from searchwriterlock where lockkey = ?";
    private static String UPDATE_LOCK_SQL = "update searchwriterlock set nodename = ?, expires = ? where id = ? and nodename = ? and lockkey = ? ";
    private static String INSERT_LOCK_SQL = "insert into searchwriterlock ( id,nodename,lockkey, expires ) values ( ?, ?, ?, ? )";
    private static String COUNT_WORK_SQL = " select count(*) from searchbuilderitem where searchstate = ? ";
    private static String CLEAR_LOCK_SQL = "update searchwriterlock set nodename = ?, expires = ? where nodename = ? and lockkey = ? ";
    private static String SELECT_NODE_LOCK_SQL = "select id, nodename, lockkey, expires from searchwriterlock where lockkey like 'nodelockkey%'";
    private static String UPDATE_NODE_LOCK_SQL = "update searchwriterlock set expires = ? where nodename = ? and lockkey = ? ";
    private static final String SELECT_EXPIRED_NODES_SQL = "select id from searchwriterlock where lockkey like 'nodelockkey%' and expires < ? ";
    private static final String DELETE_LOCKNODE_SQL = "delete from searchwriterlock where id = ? ";

    public void init() {
        if (this.started && !this.runThreads) {
            log.warn((Object)"JVM Shutdown in progress, will not startup");
            return;
        }
        if (ComponentManager.hasBeenClosed()) {
            log.warn((Object)"Component manager Shutdown in progress, will not startup");
            return;
        }
        this.started = true;
        this.runThreads = true;
        this.enabled = "true".equals(this.serverConfigurationService.getString("search.enable", "false"));
        this.enabled = this.enabled && this.serverConfigurationService.getBoolean("search.indexbuild", true);
        try {
            if (this.searchIndexBuilder == null) {
                log.error((Object)"Search Index Worker needs SearchIndexBuilder ");
            }
            if (this.searchService == null) {
                log.error((Object)"Search Index Worker needs SearchService ");
            }
            if (this.searchIndexBuilderWorkerDao == null) {
                log.error((Object)"Search Index Worker needs SearchIndexBuilderWorkerDao ");
            }
            if (this.eventTrackingService == null) {
                log.error((Object)"Search Index Worker needs EventTrackingService ");
            }
            if (this.entityManager == null) {
                log.error((Object)"Search Index Worker needs EntityManager ");
            }
            if (this.userDirectoryService == null) {
                log.error((Object)"Search Index Worker needs UserDirectortyService ");
            }
            if (this.sessionManager == null) {
                log.error((Object)"Search Index Worker needs SessionManager ");
            }
            log.debug((Object)"init start");
            for (int i = 0; i < this.indexBuilderThread.length; ++i) {
                this.indexBuilderThread[i] = new Thread(this);
                this.indexBuilderThread[i].setName("SearchBuilder_" + String.valueOf(i));
                this.indexBuilderThread[i].start();
            }
            this.eventTrackingService.addLocalObserver(new Observer(){

                @Override
                public void update(Observable arg0, Object arg1) {
                    SearchIndexBuilderWorkerImpl.this.lastEvent = System.currentTimeMillis();
                }
            });
            this.searchIndexBuilder.addIndexQueueListener(new IndexQueueListener(){

                @Override
                public void added(String name) {
                    SearchIndexBuilderWorkerImpl.this.checkRunning();
                }
            });
            Runtime.getRuntime().addShutdownHook(new Thread(){

                @Override
                public void run() {
                    SearchIndexBuilderWorkerImpl.this.runThreads = false;
                }
            });
        }
        catch (Throwable t) {
            log.error((Object)"Failed to init ", t);
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public void run() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private String getNodeID() {
        String nodeID = this.nodeIDHolder.get();
        if (nodeID == null) {
            nodeID = UUID.randomUUID().toString();
            this.nodeIDHolder.set(nodeID);
            if (nodeIDList.get(nodeID) == null) {
                nodeIDList.put(nodeID, nodeID);
            } else {
                log.error((Object)("============NODE ID " + nodeID + " has already been issued, there must be a clash"));
            }
        }
        return nodeID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateNodeLock(long lifeLeft) throws SQLException {
        Connection connection = null;
        String nodeID = this.getNodeID();
        PreparedStatement updateNodeLock = null;
        PreparedStatement deleteExpiredNodeLock = null;
        Statement selectExpiredNodeLock = null;
        Statement insertLock = null;
        ResultSet resultSet = null;
        String threadID = Thread.currentThread().getName();
        boolean savedautocommit = false;
        Timestamp now = new Timestamp(System.currentTimeMillis());
        Timestamp nodeExpired = new Timestamp(now.getTime() + lifeLeft);
        try {
            connection = this.dataSource.getConnection();
            connection.setAutoCommit(false);
            updateNodeLock = connection.prepareStatement(UPDATE_NODE_LOCK_SQL);
            deleteExpiredNodeLock = connection.prepareStatement(DELETE_LOCKNODE_SQL);
            selectExpiredNodeLock = connection.prepareStatement(SELECT_EXPIRED_NODES_SQL);
            insertLock = connection.prepareStatement(INSERT_LOCK_SQL);
            int retries = 5;
            boolean updated = false;
            while (!updated && retries > 0) {
                try {
                    block69: {
                        try {
                            insertLock.clearParameters();
                            insertLock.setString(1, "Node:" + nodeID);
                            insertLock.setString(2, nodeID);
                            insertLock.setString(3, NODE_LOCK + nodeID);
                            insertLock.setTimestamp(4, nodeExpired);
                            log.debug((Object)(threadID + " Doing " + INSERT_LOCK_SQL + ":{" + "Node:" + nodeID + "}{" + nodeID + "}{" + NODE_LOCK + nodeID + "}{" + nodeExpired + "}"));
                            insertLock.executeUpdate();
                        }
                        catch (SQLException ex) {
                            updateNodeLock.clearParameters();
                            updateNodeLock.setTimestamp(1, nodeExpired);
                            updateNodeLock.setString(2, nodeID);
                            updateNodeLock.setString(3, NODE_LOCK + nodeID);
                            log.debug((Object)(threadID + " Doing " + UPDATE_NODE_LOCK_SQL + ":{" + nodeExpired + "}{" + nodeID + "}{" + NODE_LOCK + nodeID + "}"));
                            if (updateNodeLock.executeUpdate() == 1) break block69;
                            log.warn((Object)("Failed to update node heartbeat " + nodeID));
                        }
                    }
                    log.debug((Object)(threadID + " Doing Commit "));
                    connection.commit();
                    updated = true;
                }
                catch (SQLException e) {
                    log.warn((Object)"Retrying ", (Throwable)e);
                    try {
                        connection.rollback();
                    }
                    catch (Exception ex) {
                        log.debug((Object)ex);
                    }
                    --retries;
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException ie) {
                        log.debug((Object)ie);
                    }
                }
            }
            if (!updated) {
                log.error((Object)"Failed to update node lock, will try next time ");
            } else {
                log.debug((Object)("Updated Node Lock on " + nodeID + " to Expire at" + nodeExpired));
            }
            retries = 5;
            updated = false;
            while (!updated && retries > 0) {
                try {
                    selectExpiredNodeLock.clearParameters();
                    selectExpiredNodeLock.setTimestamp(1, now);
                    log.debug((Object)(threadID + " Doing " + SELECT_EXPIRED_NODES_SQL + ":{" + now + "}"));
                    resultSet = selectExpiredNodeLock.executeQuery();
                    while (resultSet.next()) {
                        String id = resultSet.getString(1);
                        deleteExpiredNodeLock.clearParameters();
                        deleteExpiredNodeLock.setString(1, id);
                        deleteExpiredNodeLock.execute();
                        connection.commit();
                    }
                    log.debug((Object)(threadID + " Doing Commit"));
                    connection.commit();
                    resultSet.close();
                    updated = true;
                }
                catch (SQLException e) {
                    log.info((Object)("Retrying Delete Due to  " + e.getMessage()));
                    log.debug((Object)"Detailed Traceback  ", (Throwable)e);
                    try {
                        resultSet.close();
                    }
                    catch (Exception ex) {
                        log.debug((Object)ex);
                    }
                    try {
                        connection.rollback();
                    }
                    catch (Exception ex) {
                        log.debug((Object)ex);
                    }
                    --retries;
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException ie) {
                        log.debug((Object)ie);
                    }
                }
            }
            if (!updated) {
                log.warn((Object)"Failed to clear old nodes, will try next time ");
            }
        }
        catch (Exception ex) {
            log.error((Object)"Failed to register node ", (Throwable)ex);
            connection.rollback();
        }
        finally {
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (SQLException e) {
                    log.debug((Object)e);
                }
            }
            if (insertLock != null) {
                try {
                    insertLock.close();
                }
                catch (SQLException e) {
                    log.debug((Object)e);
                }
            }
            if (updateNodeLock != null) {
                try {
                    updateNodeLock.close();
                }
                catch (SQLException e) {
                    log.debug((Object)e);
                }
            }
            if (selectExpiredNodeLock != null) {
                try {
                    selectExpiredNodeLock.close();
                }
                catch (SQLException e) {
                    log.debug((Object)e);
                }
            }
            if (deleteExpiredNodeLock != null) {
                try {
                    deleteExpiredNodeLock.close();
                }
                catch (SQLException e) {
                    log.debug((Object)e);
                }
            }
            if (connection != null) {
                try {
                    connection.setAutoCommit(savedautocommit);
                    connection.close();
                }
                catch (SQLException e) {
                    log.debug((Object)e);
                }
                connection = null;
            }
        }
    }

    public boolean getLockTransaction(long nodeLifetime) {
        return this.getLockTransaction(nodeLifetime, false);
    }

    public boolean getLockTransaction(long nodeLifetime, boolean forceLock) {
        if (this.searchIndexBuilderWorkerDao.isLockRequired()) {
            return this.getHardLock(nodeLifetime, forceLock);
        }
        try {
            this.updateNodeLock(nodeLifetime);
        }
        catch (SQLException e) {
            log.warn((Object)("Failed to update node lock " + e.getClass().getName() + " :" + e.getMessage()));
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getHardLock(long nodeLifetime, boolean forceLock) {
        String nodeID = this.getNodeID();
        Connection connection = null;
        boolean locked = false;
        boolean autoCommit = false;
        Statement selectLock = null;
        Statement updateLock = null;
        Statement insertLock = null;
        Statement countWork = null;
        ResultSet resultSet = null;
        Timestamp now = new Timestamp(System.currentTimeMillis());
        Timestamp expiryDate = new Timestamp(now.getTime() + 600000L);
        try {
            this.updateNodeLock(nodeLifetime);
            connection = this.dataSource.getConnection();
            autoCommit = connection.getAutoCommit();
            if (autoCommit) {
                connection.setAutoCommit(false);
            }
            selectLock = connection.prepareStatement(SELECT_LOCK_SQL);
            updateLock = connection.prepareStatement(UPDATE_LOCK_SQL);
            insertLock = connection.prepareStatement(INSERT_LOCK_SQL);
            countWork = connection.prepareStatement(COUNT_WORK_SQL);
            SearchWriterLockImpl swl = null;
            selectLock.clearParameters();
            selectLock.setString(1, LOCKKEY);
            resultSet = selectLock.executeQuery();
            if (resultSet.next()) {
                swl = new SearchWriterLockImpl();
                swl.setId(resultSet.getString(1));
                swl.setNodename(resultSet.getString(2));
                swl.setLockkey(resultSet.getString(3));
                swl.setExpires((Date)resultSet.getTimestamp(4));
                log.debug((Object)("GOT Lock Record " + swl.getId() + "::" + swl.getNodename() + "::" + swl.getExpires()));
            }
            resultSet.close();
            resultSet = null;
            boolean takelock = false;
            if (swl == null) {
                log.debug((Object)"_-------------NO Lock Record");
                takelock = true;
            } else if (NO_NODE.equals(swl.getNodename())) {
                takelock = true;
                log.debug((Object)(nodeID + "_-------------no lock"));
            } else if (nodeID.equals(swl.getNodename())) {
                takelock = true;
                log.debug((Object)(nodeID + "_------------matched threadid "));
            } else if (swl.getExpires() == null || swl.getExpires().before(now)) {
                takelock = true;
                log.debug((Object)(nodeID + "_------------thread dead "));
            }
            if (takelock) {
                int nitems = 0;
                if (!forceLock) {
                    countWork.clearParameters();
                    countWork.setInt(1, SearchBuilderItem.STATE_PENDING);
                    resultSet = countWork.executeQuery();
                    if (resultSet.next()) {
                        nitems = resultSet.getInt(1);
                    }
                    resultSet.close();
                    resultSet = null;
                }
                if (nitems > 0 || forceLock) {
                    try {
                        if (swl == null) {
                            insertLock.clearParameters();
                            insertLock.setString(1, nodeID);
                            insertLock.setString(2, nodeID);
                            insertLock.setString(3, LOCKKEY);
                            insertLock.setTimestamp(4, expiryDate);
                            if (insertLock.executeUpdate() == 1) {
                                log.debug((Object)("INSERT Lock Record " + nodeID + "::" + nodeID + "::" + expiryDate));
                                locked = true;
                            }
                        } else {
                            updateLock.clearParameters();
                            updateLock.setString(1, nodeID);
                            updateLock.setTimestamp(2, expiryDate);
                            updateLock.setString(3, swl.getId());
                            updateLock.setString(4, swl.getNodename());
                            updateLock.setString(5, swl.getLockkey());
                            if (updateLock.executeUpdate() == 1) {
                                log.debug((Object)("UPDATED Lock Record " + swl.getId() + "::" + nodeID + "::" + expiryDate));
                                locked = true;
                            }
                        }
                    }
                    catch (SQLException sqlex) {
                        locked = false;
                        log.debug((Object)"Failed to get lock, but this is Ok ", (Throwable)sqlex);
                    }
                }
            }
            connection.commit();
        }
        catch (Exception ex) {
            if (connection != null) {
                try {
                    connection.rollback();
                }
                catch (SQLException e) {
                    log.debug((Object)e);
                }
            }
            log.error((Object)("Failed to get lock " + ex.getMessage()));
            locked = false;
        }
        finally {
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (SQLException e) {
                    log.debug((Object)e);
                }
            }
            if (selectLock != null) {
                try {
                    selectLock.close();
                }
                catch (SQLException e) {
                    log.debug((Object)e);
                }
            }
            if (updateLock != null) {
                try {
                    updateLock.close();
                }
                catch (SQLException e) {
                    log.debug((Object)e);
                }
            }
            if (insertLock != null) {
                try {
                    insertLock.close();
                }
                catch (SQLException e) {
                    log.debug((Object)e);
                }
            }
            if (countWork != null) {
                try {
                    countWork.close();
                }
                catch (SQLException e) {
                    log.debug((Object)e);
                }
            }
            if (connection != null) {
                try {
                    connection.setAutoCommit(autoCommit);
                }
                catch (SQLException e) {}
                try {
                    connection.close();
                    log.debug((Object)"Connection Closed ");
                }
                catch (SQLException e) {
                    log.error((Object)"Error Closing Connection ", (Throwable)e);
                }
                connection = null;
            }
        }
        return locked;
    }

    private void clearLockTransaction() {
        if (this.searchIndexBuilderWorkerDao.isLockRequired()) {
            this.clearHardLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearHardLock() {
        String nodeID = this.getNodeID();
        Connection connection = null;
        Statement clearLock = null;
        try {
            connection = this.dataSource.getConnection();
            clearLock = connection.prepareStatement(CLEAR_LOCK_SQL);
            clearLock.clearParameters();
            clearLock.setString(1, NO_NODE);
            clearLock.setTimestamp(2, new Timestamp(System.currentTimeMillis()));
            clearLock.setString(3, nodeID);
            clearLock.setString(4, LOCKKEY);
            if (clearLock.executeUpdate() == 1) {
                log.debug((Object)("UNLOCK - OK::" + nodeID + "::now"));
            } else {
                log.debug((Object)("UNLOCK - no-lock::" + nodeID + "::now"));
            }
            connection.commit();
        }
        catch (Exception ex) {
            try {
                connection.rollback();
            }
            catch (SQLException e) {
                // empty catch block
            }
            log.error((Object)("Failed to clear lock" + ex.getMessage()));
        }
        finally {
            if (clearLock != null) {
                try {
                    clearLock.close();
                }
                catch (SQLException e) {
                    log.error((Object)"Error Closing Prepared Statement ", (Throwable)e);
                }
            }
            if (connection != null) {
                try {
                    connection.close();
                    log.debug((Object)"Connection Closed");
                }
                catch (SQLException e) {
                    log.error((Object)"Error Closing Connection", (Throwable)e);
                }
            }
        }
    }

    public boolean isRunning() {
        if (ComponentManager.hasBeenClosed()) {
            this.runThreads = false;
        }
        return this.runThreads;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkRunning() {
        if (!this.enabled) {
            return;
        }
        this.runThreads = true;
        Object object = this.threadStartLock;
        synchronized (object) {
            for (int i = 0; i < this.indexBuilderThread.length; ++i) {
                if (this.indexBuilderThread[i] != null) continue;
                this.indexBuilderThread[i] = new Thread(this);
                this.indexBuilderThread[i].setName(String.valueOf(i) + "::" + this.getClass().getName());
                this.indexBuilderThread[i].start();
            }
        }
        object = this.sem;
        synchronized (object) {
            log.debug((Object)"_________NOTIFY");
            this.sem.notify();
            log.debug((Object)"_________NOTIFY COMPLETE");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        if (!this.enabled) {
            return;
        }
        log.debug((Object)"Destroy SearchIndexBuilderWorker ");
        this.runThreads = false;
        Object object = this.sem;
        synchronized (object) {
            this.sem.notifyAll();
        }
    }

    public long getSleepTime() {
        return this.sleepTime;
    }

    public void setSleepTime(long sleepTime) {
        this.sleepTime = sleepTime;
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public SearchIndexBuilderWorkerDao getSearchIndexBuilderWorkerDao() {
        return this.searchIndexBuilderWorkerDao;
    }

    public void setSearchIndexBuilderWorkerDao(SearchIndexBuilderWorkerDao searchIndexBuilderWorkerDao) {
        this.searchIndexBuilderWorkerDao = searchIndexBuilderWorkerDao;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SearchWriterLock getCurrentLock() {
        this.getNodeID();
        Connection connection = null;
        PreparedStatement selectLock = null;
        ResultSet resultSet = null;
        try {
            connection = this.dataSource.getConnection();
            selectLock = connection.prepareStatement(SELECT_LOCK_SQL);
            SearchWriterLockImpl swl = null;
            selectLock.clearParameters();
            selectLock.setString(1, LOCKKEY);
            resultSet = selectLock.executeQuery();
            if (resultSet.next()) {
                swl = new SearchWriterLockImpl();
                swl.setId(resultSet.getString(1));
                swl.setNodename(resultSet.getString(2));
                swl.setLockkey(resultSet.getString(3));
                swl.setExpires((Date)resultSet.getTimestamp(4));
                log.debug((Object)("GOT Lock Record " + swl.getId() + "::" + swl.getNodename() + "::" + swl.getExpires()));
            }
            resultSet.close();
            resultSet = null;
            if (swl == null) {
                swl = new SearchWriterLockImpl();
                swl.setNodename(NO_NODE);
                swl.setLockkey(LOCKKEY);
                swl.setExpires((Date)new Timestamp(0L));
            }
            SearchWriterLockImpl searchWriterLockImpl = swl;
            return searchWriterLockImpl;
        }
        catch (Exception ex) {
            log.error((Object)("Failed to get lock " + ex.getMessage()));
            SearchWriterLockImpl swl = new SearchWriterLockImpl();
            swl.setNodename(NO_NODE);
            swl.setLockkey(LOCKKEY);
            swl.setExpires((Date)new Timestamp(0L));
            SearchWriterLockImpl searchWriterLockImpl = swl;
            return searchWriterLockImpl;
        }
        finally {
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (SQLException e) {}
            }
            if (selectLock != null) {
                try {
                    selectLock.close();
                }
                catch (SQLException e) {}
            }
            if (connection != null) {
                try {
                    connection.close();
                    log.debug((Object)"Connection Closed ");
                }
                catch (SQLException e) {
                    log.error((Object)"Error Closing Connection ", (Throwable)e);
                }
                connection = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<SearchWriterLock> getNodeStatus() {
        this.getNodeID();
        Connection connection = null;
        PreparedStatement selectLock = null;
        ResultSet resultSet = null;
        ArrayList<SearchWriterLock> locks = new ArrayList<SearchWriterLock>();
        try {
            Object swl;
            connection = this.dataSource.getConnection();
            selectLock = connection.prepareStatement(SELECT_NODE_LOCK_SQL);
            selectLock.clearParameters();
            resultSet = selectLock.executeQuery();
            while (resultSet.next()) {
                swl = new SearchWriterLockImpl();
                swl.setId(resultSet.getString(1));
                swl.setNodename(resultSet.getString(2));
                swl.setLockkey(resultSet.getString(3));
                swl.setExpires((Date)resultSet.getTimestamp(4));
                log.debug((Object)("GOT Lock Record " + swl.getId() + "::" + swl.getNodename() + "::" + swl.getExpires()));
                locks.add((SearchWriterLock)swl);
            }
            resultSet.close();
            resultSet = null;
            swl = locks;
            return swl;
        }
        catch (Exception ex) {
            log.error((Object)"Failed to load nodes ", (Throwable)ex);
            ArrayList<SearchWriterLock> arrayList = locks;
            return arrayList;
        }
        finally {
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (SQLException e) {}
            }
            if (selectLock != null) {
                try {
                    selectLock.close();
                }
                catch (SQLException e) {}
            }
            if (connection != null) {
                try {
                    connection.close();
                    log.debug((Object)"Connection Closed ");
                }
                catch (SQLException e) {
                    log.error((Object)"Error Closing Connection ", (Throwable)e);
                }
                connection = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeWorkerLock() {
        Connection connection = null;
        Statement selectLock = null;
        PreparedStatement selectNodeLock = null;
        Statement clearLock = null;
        ResultSet resultSet = null;
        try {
            connection = this.dataSource.getConnection();
            selectNodeLock = connection.prepareStatement(SELECT_NODE_LOCK_SQL);
            selectLock = connection.prepareStatement(SELECT_LOCK_SQL);
            clearLock = connection.prepareStatement(CLEAR_LOCK_SQL);
            SearchWriterLockImpl swl = null;
            selectLock.clearParameters();
            selectLock.setString(1, LOCKKEY);
            resultSet = selectLock.executeQuery();
            if (!resultSet.next()) {
                connection.rollback();
                boolean bl = true;
                return bl;
            }
            swl = new SearchWriterLockImpl();
            swl.setId(resultSet.getString(1));
            swl.setNodename(resultSet.getString(2));
            swl.setLockkey(resultSet.getString(3));
            swl.setExpires((Date)resultSet.getTimestamp(4));
            resultSet.close();
            resultSet = null;
            selectNodeLock.clearParameters();
            resultSet = selectLock.executeQuery();
            while (resultSet.next()) {
                SearchWriterLockImpl node = new SearchWriterLockImpl();
                node.setId(resultSet.getString(1));
                node.setNodename(resultSet.getString(2));
                node.setLockkey(resultSet.getString(3));
                node.setExpires((Date)resultSet.getTimestamp(4));
                if (!swl.getNodename().equals(node.getNodename())) continue;
                log.info((Object)("Cant remove Lock to node " + node.getNodename() + " node exists "));
                connection.rollback();
                boolean e = false;
                return e;
            }
            resultSet.close();
            resultSet = null;
            clearLock.clearParameters();
            clearLock.setString(1, NO_NODE);
            clearLock.setTimestamp(2, new Timestamp(System.currentTimeMillis()));
            clearLock.setString(3, swl.getNodename());
            clearLock.setString(4, LOCKKEY);
            if (clearLock.executeUpdate() != 1) {
                log.info((Object)("NODE NOT UNLOCKED BY USER " + swl.getNodename()));
                connection.commit();
                boolean bl = false;
                return bl;
            }
            log.warn((Object)("NODE UNLOCKED BY USER " + swl.getNodename()));
            connection.commit();
            boolean bl = true;
            return bl;
        }
        catch (Exception ex) {
            log.error((Object)"Failed to unlock ", (Throwable)ex);
            boolean bl = false;
            return bl;
        }
        finally {
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (SQLException e) {}
            }
            if (selectLock != null) {
                try {
                    selectLock.close();
                }
                catch (SQLException e) {}
            }
            if (selectNodeLock != null) {
                try {
                    selectNodeLock.close();
                }
                catch (SQLException e) {}
            }
            if (clearLock != null) {
                try {
                    clearLock.close();
                }
                catch (SQLException e) {}
            }
            if (connection != null) {
                try {
                    connection.close();
                    log.debug((Object)"Connection Closed ");
                }
                catch (SQLException e) {
                    log.error((Object)"Error Closing Connection ", (Throwable)e);
                }
                connection = null;
            }
        }
    }

    public long getLastEventTime() {
        return this.lastEvent;
    }

    public void setLastIndex(long l) {
        this.lastIndex = l;
    }

    public void setStartDocIndex(long startDocIndex) {
        this.startDocIndex = startDocIndex;
    }

    public void setNowIndexing(String reference) {
        this.lastIndexing = this.nowIndexing;
        this.nowIndexing = reference;
    }

    public long getLastIndex() {
        return this.lastIndex;
    }

    public String getNowIndexing() {
        return this.nowIndexing;
    }

    public long getStartDocIndex() {
        return this.startDocIndex;
    }

    public String getLastDocument() {
        return this.lastIndexing;
    }

    public String getLastElapsed() {
        long l = this.lastIndex;
        long h = l / 3600000L;
        long m = (l -= 3600000L * h) / 600000L;
        long s = (l -= 60000L * m) / 1000L;
        return "" + h + "h" + m + "m" + s + "." + (l -= 1000L * s) + "s";
    }

    public String getCurrentDocument() {
        return this.nowIndexing;
    }

    public String getCurrentElapsed() {
        long l = System.currentTimeMillis() - this.startDocIndex;
        long h = l / 3600000L;
        long m = (l -= 3600000L * h) / 60000L;
        long s = (l -= 60000L * m) / 1000L;
        return "" + h + "h" + m + "m" + s + "." + (l -= 1000L * s) + "s";
    }

    public long getLoadFactor() {
        return this.loadFactor;
    }

    public void setLoadFactor(long loadFactor) {
        this.loadFactor = loadFactor;
    }

    public boolean isLocalLock() {
        if (lockedTo == null) {
            return false;
        }
        return !this.getNodeID().equals(lockedTo);
    }

    public boolean getSoakTest() {
        return this.soakTest;
    }

    public void setSoakTest(boolean soakTest) {
        this.soakTest = soakTest;
        if (soakTest) {
            log.warn((Object)"SOAK TEST ACTIVE ======================DONT USE FOR PRODUCTION ");
        }
    }

    public EntityManager getEntityManager() {
        return this.entityManager;
    }

    public void setEntityManager(EntityManager entityManager) {
        this.entityManager = entityManager;
    }

    public EventTrackingService getEventTrackingService() {
        return this.eventTrackingService;
    }

    public void setEventTrackingService(EventTrackingService eventTrackingService) {
        this.eventTrackingService = eventTrackingService;
    }

    public SearchIndexBuilderImpl getSearchIndexBuilder() {
        return this.searchIndexBuilder;
    }

    public void setSearchIndexBuilder(SearchIndexBuilderImpl searchIndexBuilder) {
        this.searchIndexBuilder = searchIndexBuilder;
    }

    public SearchService getSearchService() {
        return this.searchService;
    }

    public void setSearchService(SearchService searchService) {
        this.searchService = searchService;
    }

    public ServerConfigurationService getServerConfigurationService() {
        return this.serverConfigurationService;
    }

    public void setServerConfigurationService(ServerConfigurationService serverConfigurationService) {
        this.serverConfigurationService = serverConfigurationService;
    }

    public SessionManager getSessionManager() {
        return this.sessionManager;
    }

    public void setSessionManager(SessionManager sessionManager) {
        this.sessionManager = sessionManager;
    }

    public UserDirectoryService getUserDirectoryService() {
        return this.userDirectoryService;
    }

    public void setUserDirectoryService(UserDirectoryService userDirectoryService) {
        this.userDirectoryService = userDirectoryService;
    }
}

